/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Parcelable;
import android.os.PowerManager;
import android.util.Log;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.FirebaseInstanceIdReceiver;
import com.google.firebase.iid.zzai;
import com.google.firebase.iid.zzaq;
import com.google.firebase.iid.zzas;
import com.google.firebase.iid.zzau;
import com.google.firebase.iid.zzax;
import java.io.IOException;

final class zzav
implements Runnable {
    private final long zza;
    private final PowerManager.WakeLock zzb;
    private final FirebaseInstanceId zzc;
    private final zzax zzd;

    @VisibleForTesting
    zzav(FirebaseInstanceId firebaseInstanceId, zzai zzai2, zzax zzax2, long l) {
        this.zzc = firebaseInstanceId;
        this.zzd = zzax2;
        this.zza = l;
        PowerManager powerManager = (PowerManager)this.zza().getSystemService("power");
        this.zzb = powerManager.newWakeLock(1, "fiid-sync");
        this.zzb.setReferenceCounted(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @SuppressLint(value={"Wakelock"})
    public final void run() {
        if (zzaq.zza().zza(this.zza())) {
            this.zzb.acquire();
        }
        try {
            this.zzc.zza(true);
            if (!this.zzc.zzf()) {
                this.zzc.zza(false);
                return;
            }
            if (zzaq.zza().zzb(this.zza()) && !this.zzb()) {
                new zzau(this).zza();
                return;
            }
            if (this.zzc() && this.zzd.zza(this.zzc)) {
                this.zzc.zza(false);
            } else {
                this.zzc.zza(this.zza);
            }
            if (!zzaq.zza().zza(this.zza())) return;
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            Log.e((String)"FirebaseInstanceId", (String)new StringBuilder(93 + String.valueOf(string).length()).append("Topic sync or token retrieval failed on hard failure exceptions: ").append(string).append(". Won't retry the operation.").toString());
            this.zzc.zza(false);
            return;
        }
        finally {
            if (!zzaq.zza().zza(this.zza())) return;
            this.zzb.release();
        }
        this.zzb.release();
        return;
    }

    @VisibleForTesting
    private final boolean zzc() throws IOException {
        zzas zzas2 = this.zzc.zzb();
        if (!this.zzc.zza(zzas2)) {
            return true;
        }
        try {
            String string = this.zzc.zzc();
            if (string == null) {
                Log.e((String)"FirebaseInstanceId", (String)"Token retrieval failed: null");
                return false;
            }
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                Log.d((String)"FirebaseInstanceId", (String)"Token successfully retrieved");
            }
            if (zzas2 == null || zzas2 != null && !string.equals(zzas2.zza)) {
                String string2 = string;
                zzav zzav2 = this;
                if ("[DEFAULT]".equals(zzav2.zzc.zza().getName())) {
                    if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                        String string3 = String.valueOf(zzav2.zzc.zza().getName());
                        Log.d((String)"FirebaseInstanceId", (String)(string3.length() != 0 ? "Invoking onNewToken for app: ".concat(string3) : new String("Invoking onNewToken for app: ")));
                    }
                    Intent intent = new Intent("com.google.firebase.messaging.NEW_TOKEN");
                    intent.putExtra("token", string2);
                    Intent intent2 = intent;
                    Context context = zzav2.zza();
                    Intent intent3 = intent2;
                    String string4 = "com.google.firebase.MESSAGING_EVENT";
                    Context context2 = context;
                    Intent intent4 = new Intent(context2, FirebaseInstanceIdReceiver.class);
                    intent4.setAction(string4);
                    intent4.putExtra("wrapped_intent", (Parcelable)intent3);
                    context.sendBroadcast(intent4);
                }
            }
            return true;
        }
        catch (IOException iOException) {
            if ("SERVICE_NOT_AVAILABLE".equals(iOException.getMessage()) || "INTERNAL_SERVER_ERROR".equals(iOException.getMessage())) {
                Log.w((String)"FirebaseInstanceId", (String)"Token retrieval failed without exception message. Will retry token retrieval");
                return false;
            }
            if (iOException.getMessage() == null) {
                String string = iOException.getMessage();
                Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(52 + String.valueOf(string).length()).append("Token retrieval failed: ").append(string).append(". Will retry token retrieval").toString());
                return false;
            }
            throw iOException;
        }
        catch (SecurityException securityException) {
            Log.w((String)"FirebaseInstanceId", (String)"Token retrieval failed with SecurityException. Will retry token retrieval");
            return false;
        }
    }

    final Context zza() {
        return this.zzc.zza().getApplicationContext();
    }

    final boolean zzb() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.zza().getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager != null ? connectivityManager.getActiveNetworkInfo() : null;
        return networkInfo != null && networkInfo.isConnected();
    }
}

