/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.firebase.iid.zzaz;
import com.google.firebase.iid.zzbd;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

public final class zzba
implements ServiceConnection {
    private final Context zza;
    private final Intent zzb;
    private final ScheduledExecutorService zzc;
    private final Queue<zzbd> zzd = new ArrayDeque<zzbd>();
    @Nullable
    private zzaz zze;
    @GuardedBy(value="this")
    private boolean zzf = false;

    public zzba(Context context, String string) {
        this(context, string, new ScheduledThreadPoolExecutor(0, (ThreadFactory)new NamedThreadFactory("Firebase-FirebaseInstanceIdServiceConnection")));
    }

    @VisibleForTesting
    private zzba(Context context, String string, ScheduledExecutorService scheduledExecutorService) {
        this.zza = context.getApplicationContext();
        this.zzb = new Intent(string).setPackage(this.zza.getPackageName());
        this.zzc = scheduledExecutorService;
    }

    public final synchronized void zza(Intent intent, BroadcastReceiver.PendingResult pendingResult) {
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            Log.d((String)"FirebaseInstanceId", (String)"new intent queued in the bind-strategy delivery");
        }
        this.zzd.add(new zzbd(intent, pendingResult, this.zzc));
        this.zza();
    }

    private final synchronized void zza() {
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            Log.d((String)"FirebaseInstanceId", (String)"flush queue called");
        }
        while (!this.zzd.isEmpty()) {
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                Log.d((String)"FirebaseInstanceId", (String)"found intent to be delivered");
            }
            if (this.zze != null && this.zze.isBinderAlive()) {
                if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                    Log.d((String)"FirebaseInstanceId", (String)"binder is alive, sending the intent.");
                }
                zzbd zzbd2 = this.zzd.poll();
                this.zze.zza(zzbd2);
                continue;
            }
            zzba zzba2 = this;
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                boolean bl = !zzba2.zzf;
                Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(39).append("binder is dead. start connection? ").append(bl).toString());
            }
            if (!zzba2.zzf) {
                zzba2.zzf = true;
                try {
                    if (ConnectionTracker.getInstance().bindService(zzba2.zza, zzba2.zzb, (ServiceConnection)zzba2, 65)) {
                        return;
                    }
                    Log.e((String)"FirebaseInstanceId", (String)"binding to the service failed");
                }
                catch (SecurityException securityException) {
                    Log.e((String)"FirebaseInstanceId", (String)"Exception while binding the service", (Throwable)securityException);
                }
                zzba2.zzf = false;
                zzba2.zzb();
            }
            return;
        }
    }

    @GuardedBy(value="this")
    private final void zzb() {
        while (!this.zzd.isEmpty()) {
            this.zzd.poll().zza();
        }
    }

    public final synchronized void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        String string;
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            string = String.valueOf(componentName);
            Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(20 + String.valueOf(string).length()).append("onServiceConnected: ").append(string).toString());
        }
        this.zzf = false;
        if (!(iBinder instanceof zzaz)) {
            string = String.valueOf(iBinder);
            Log.e((String)"FirebaseInstanceId", (String)new StringBuilder(28 + String.valueOf(string).length()).append("Invalid service connection: ").append(string).toString());
            this.zzb();
            return;
        }
        this.zze = (zzaz)iBinder;
        this.zza();
    }

    public final void onServiceDisconnected(ComponentName componentName) {
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            String string = String.valueOf(componentName);
            Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(23 + String.valueOf(string).length()).append("onServiceDisconnected: ").append(string).toString());
        }
        this.zza();
    }
}

