/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.iid.zzbc;
import com.google.firebase.iid.zzbg;
import com.google.firebase.iid.zzbi;
import com.google.firebase.iid.zzbj;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class zzbh
implements ServiceConnection {
    private final Context zza;
    private final Intent zzb;
    private final ScheduledExecutorService zzc;
    private final Queue<zzbg> zzd = new ArrayDeque<zzbg>();
    @Nullable
    private zzbc zze;
    @GuardedBy(value="this")
    private boolean zzf = false;

    public zzbh(Context context, String string) {
        this(context, string, new ScheduledThreadPoolExecutor(0, (ThreadFactory)new NamedThreadFactory("Firebase-FirebaseInstanceIdServiceConnection")));
    }

    @VisibleForTesting
    private zzbh(Context context, String string, ScheduledExecutorService scheduledExecutorService) {
        this.zza = context.getApplicationContext();
        this.zzb = new Intent(string).setPackage(this.zza.getPackageName());
        this.zzc = scheduledExecutorService;
    }

    public final synchronized Task<Void> zza(Intent intent) {
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            Log.d((String)"FirebaseInstanceId", (String)"new intent queued in the bind-strategy delivery");
        }
        zzbg zzbg2 = new zzbg(intent);
        ScheduledExecutorService scheduledExecutorService = this.zzc;
        zzbg zzbg3 = zzbg2;
        ScheduledFuture<?> scheduledFuture = scheduledExecutorService.schedule(new zzbj(zzbg3), 9000L, TimeUnit.MILLISECONDS);
        zzbg3.zza().addOnCompleteListener((Executor)scheduledExecutorService, (OnCompleteListener)new zzbi(scheduledFuture));
        this.zzd.add(zzbg2);
        this.zza();
        return zzbg2.zza();
    }

    private final synchronized void zza() {
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            Log.d((String)"FirebaseInstanceId", (String)"flush queue called");
        }
        while (!this.zzd.isEmpty()) {
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                Log.d((String)"FirebaseInstanceId", (String)"found intent to be delivered");
            }
            if (this.zze != null && this.zze.isBinderAlive()) {
                if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                    Log.d((String)"FirebaseInstanceId", (String)"binder is alive, sending the intent.");
                }
                zzbg zzbg2 = this.zzd.poll();
                this.zze.zza(zzbg2);
                continue;
            }
            zzbh zzbh2 = this;
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                boolean bl = !zzbh2.zzf;
                Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(39).append("binder is dead. start connection? ").append(bl).toString());
            }
            if (!zzbh2.zzf) {
                zzbh2.zzf = true;
                try {
                    if (ConnectionTracker.getInstance().bindService(zzbh2.zza, zzbh2.zzb, (ServiceConnection)zzbh2, 65)) {
                        return;
                    }
                    Log.e((String)"FirebaseInstanceId", (String)"binding to the service failed");
                }
                catch (SecurityException securityException) {
                    Log.e((String)"FirebaseInstanceId", (String)"Exception while binding the service", (Throwable)securityException);
                }
                zzbh2.zzf = false;
                zzbh2.zzb();
            }
            return;
        }
    }

    @GuardedBy(value="this")
    private final void zzb() {
        while (!this.zzd.isEmpty()) {
            this.zzd.poll().zzb();
        }
    }

    public final synchronized void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        String string;
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            string = String.valueOf(componentName);
            Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(20 + String.valueOf(string).length()).append("onServiceConnected: ").append(string).toString());
        }
        this.zzf = false;
        if (!(iBinder instanceof zzbc)) {
            string = String.valueOf(iBinder);
            Log.e((String)"FirebaseInstanceId", (String)new StringBuilder(28 + String.valueOf(string).length()).append("Invalid service connection: ").append(string).toString());
            this.zzb();
            return;
        }
        this.zze = (zzbc)iBinder;
        this.zza();
    }

    public final void onServiceDisconnected(ComponentName componentName) {
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            String string = String.valueOf(componentName);
            Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(23 + String.valueOf(string).length()).append("onServiceDisconnected: ").append(string).toString());
        }
        this.zza();
    }
}

