/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.DataCollectionDefaultChange;
import com.google.firebase.FirebaseApp;
import com.google.firebase.events.EventHandler;
import com.google.firebase.events.Subscriber;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.iid.zzaa;
import com.google.firebase.iid.zzao;
import com.google.firebase.iid.zzat;
import com.google.firebase.iid.zzay;
import com.google.firebase.iid.zzaz;
import com.google.firebase.iid.zzbb;
import com.google.firebase.iid.zzh;
import com.google.firebase.iid.zzk;
import com.google.firebase.iid.zzl;
import com.google.firebase.iid.zzm;
import com.google.firebase.iid.zzn;
import com.google.firebase.iid.zzo;
import com.google.firebase.iid.zzp;
import com.google.firebase.iid.zzq;
import com.google.firebase.iid.zzt;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import javax.annotation.concurrent.GuardedBy;

public class FirebaseInstanceId {
    private static final long zza = TimeUnit.HOURS.toSeconds(8L);
    private static zzaz zzb;
    private static final Pattern zzc;
    @GuardedBy(value="FirebaseInstanceId.class")
    @VisibleForTesting
    private static ScheduledExecutorService zzd;
    @VisibleForTesting
    private final Executor zze;
    private final FirebaseApp zzf;
    private final zzao zzg;
    private final zzt zzh;
    private final zzat zzi;
    private final FirebaseInstallationsApi zzj;
    @GuardedBy(value="this")
    private boolean zzk = false;
    private final zza zzl;

    @NonNull
    public static FirebaseInstanceId getInstance() {
        return FirebaseInstanceId.getInstance(FirebaseApp.getInstance());
    }

    @Keep
    @NonNull
    public static FirebaseInstanceId getInstance(@NonNull FirebaseApp firebaseApp) {
        FirebaseInstanceId.zza(firebaseApp);
        return (FirebaseInstanceId)firebaseApp.get(FirebaseInstanceId.class);
    }

    FirebaseInstanceId(FirebaseApp firebaseApp, Subscriber subscriber, UserAgentPublisher userAgentPublisher, HeartBeatInfo heartBeatInfo, FirebaseInstallationsApi firebaseInstallationsApi) {
        this(firebaseApp, new zzao(firebaseApp.getApplicationContext()), com.google.firebase.iid.zzh.zzb(), com.google.firebase.iid.zzh.zzb(), subscriber, userAgentPublisher, heartBeatInfo, firebaseInstallationsApi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FirebaseInstanceId(FirebaseApp firebaseApp, zzao zzao2, Executor executor, Executor executor2, Subscriber subscriber, UserAgentPublisher userAgentPublisher, HeartBeatInfo heartBeatInfo, FirebaseInstallationsApi firebaseInstallationsApi) {
        if (zzao.zza(firebaseApp) == null) {
            throw new IllegalStateException("FirebaseInstanceId failed to initialize, FirebaseApp is missing project ID");
        }
        Class<FirebaseInstanceId> clazz = FirebaseInstanceId.class;
        synchronized (FirebaseInstanceId.class) {
            if (zzb == null) {
                zzb = new zzaz(firebaseApp.getApplicationContext());
            }
            // ** MonitorExit[var9_9] (shouldn't be in output)
            this.zzf = firebaseApp;
            this.zzg = zzao2;
            this.zzh = new zzt(firebaseApp, zzao2, executor, userAgentPublisher, heartBeatInfo, firebaseInstallationsApi);
            this.zze = executor2;
            this.zzl = new zza(subscriber);
            this.zzi = new zzat(executor);
            this.zzj = firebaseInstallationsApi;
            executor2.execute(new zzl(this));
            return;
        }
    }

    private final void zzj() {
        zzay zzay2 = this.zzb();
        if (this.zza(zzay2)) {
            this.zzk();
        }
    }

    final FirebaseApp zza() {
        return this.zzf;
    }

    final synchronized void zza(boolean bl) {
        this.zzk = bl;
    }

    private final synchronized void zzk() {
        if (!this.zzk) {
            this.zza(0L);
        }
    }

    final synchronized void zza(long l) {
        long l2 = Math.min(Math.max(30L, l << 1), zza);
        FirebaseInstanceId.zza(new zzbb(this, l2), l);
        this.zzk = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zza(Runnable runnable, long l) {
        Class<FirebaseInstanceId> clazz = FirebaseInstanceId.class;
        synchronized (FirebaseInstanceId.class) {
            if (zzd == null) {
                zzd = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("FirebaseInstanceId"));
            }
            zzd.schedule(runnable, l, TimeUnit.SECONDS);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    @WorkerThread
    @NonNull
    public String getId() {
        FirebaseInstanceId.zza(this.zzf);
        this.zzj();
        return this.zzl();
    }

    private static void zza(@NonNull FirebaseApp firebaseApp) {
        Preconditions.checkNotEmpty((String)firebaseApp.getOptions().getProjectId(), (Object)"Please set your project ID. A valid Firebase project ID is required to communicate with Firebase server APIs: It identifies your project with Google.");
        Preconditions.checkNotEmpty((String)firebaseApp.getOptions().getApplicationId(), (Object)"Please set your Application ID. A valid Firebase App ID is required to communicate with Firebase server APIs: It identifies your application with Firebase.");
        Preconditions.checkNotEmpty((String)firebaseApp.getOptions().getApiKey(), (Object)"Please set a valid API key. A Firebase API key is required to communicate with Firebase server APIs: It authenticates your project with Google.");
        Preconditions.checkArgument((boolean)firebaseApp.getOptions().getApplicationId().contains(":"), (Object)"Please set your Application ID. A valid Firebase App ID is required to communicate with Firebase server APIs: It identifies your application with Firebase.Please refer to https://firebase.google.com/support/privacy/init-options.");
        String string = firebaseApp.getOptions().getApiKey();
        Preconditions.checkArgument((boolean)zzc.matcher(string).matches(), (Object)"Please set a valid API key. A Firebase API key is required to communicate with Firebase server APIs: It authenticates your project with Google.Please refer to https://firebase.google.com/support/privacy/init-options.");
    }

    private final String zzl() {
        try {
            zzb.zzb(this.zzf.getPersistenceKey());
            Task task = this.zzj.getId();
            Preconditions.checkNotNull((Object)task, (Object)"Task must not be null");
            CountDownLatch countDownLatch = new CountDownLatch(1);
            task.addOnCompleteListener(zzn.zza, (OnCompleteListener)new zzm(countDownLatch));
            countDownLatch.await(30000L, TimeUnit.MILLISECONDS);
            Task task2 = task;
            if (!task2.isSuccessful()) {
                if (task2.isCanceled()) {
                    throw new CancellationException("Task is already canceled");
                }
                throw new IllegalStateException(task2.getException());
            }
            return (String)task2.getResult();
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException(interruptedException);
        }
    }

    public long getCreationTime() {
        return zzb.zza(this.zzf.getPersistenceKey());
    }

    @NonNull
    public Task<InstanceIdResult> getInstanceId() {
        FirebaseInstanceId.zza(this.zzf);
        return this.zza(zzao.zza(this.zzf), "*");
    }

    private final Task<InstanceIdResult> zza(String string, String string2) {
        String string3 = FirebaseInstanceId.zza(string2);
        return Tasks.forResult(null).continueWithTask(this.zze, (Continuation)new zzk(this, string, string3));
    }

    @WorkerThread
    public void deleteInstanceId() throws IOException {
        FirebaseInstanceId.zza(this.zzf);
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        this.zza(this.zzj.delete());
        this.zze();
    }

    @Deprecated
    @Nullable
    public String getToken() {
        FirebaseInstanceId.zza(this.zzf);
        zzay zzay2 = this.zzb();
        if (this.zza(zzay2)) {
            this.zzk();
        }
        return zzay.zza(zzay2);
    }

    @Nullable
    @WorkerThread
    public String getToken(@NonNull String string, @NonNull String string2) throws IOException {
        FirebaseInstanceId.zza(this.zzf);
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        return this.zza(this.zza(string, string2)).getToken();
    }

    @Nullable
    final zzay zzb() {
        return this.zzb(zzao.zza(this.zzf), "*");
    }

    @Nullable
    @VisibleForTesting
    private final zzay zzb(String string, String string2) {
        return zzb.zza(this.zzm(), string, string2);
    }

    final String zzc() throws IOException {
        return this.getToken(zzao.zza(this.zzf), "*");
    }

    private final <T> T zza(Task<T> task) throws IOException {
        try {
            return (T)Tasks.await(task, (long)30000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException executionException) {
            ExecutionException executionException2 = executionException;
            Throwable throwable = executionException.getCause();
            if (throwable instanceof IOException) {
                if ("INSTANCE_ID_RESET".equals(throwable.getMessage())) {
                    this.zze();
                }
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IOException(executionException2);
        }
        catch (InterruptedException | TimeoutException exception) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
    }

    @WorkerThread
    public void deleteToken(@NonNull String string, @NonNull String string2) throws IOException {
        FirebaseInstanceId.zza(this.zzf);
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        string2 = FirebaseInstanceId.zza(string2);
        String string3 = this.zzl();
        this.zza(this.zzh.zzb(string3, string, string2));
        zzb.zzb(this.zzm(), string, string2);
    }

    static boolean zzd() {
        return Log.isLoggable((String)"FirebaseInstanceId", (int)3) || Build.VERSION.SDK_INT == 23 && Log.isLoggable((String)"FirebaseInstanceId", (int)3);
    }

    final synchronized void zze() {
        zzb.zza();
        if (this.zzl.zza()) {
            this.zzk();
        }
    }

    @VisibleForTesting
    public final boolean zzf() {
        return this.zzg.zza();
    }

    final void zzg() {
        zzb.zzc(this.zzm());
        this.zzk();
    }

    @VisibleForTesting
    public final boolean zzh() {
        return this.zzl.zza();
    }

    @VisibleForTesting
    public final void zzb(boolean bl) {
        this.zzl.zza(bl);
    }

    private static String zza(String string) {
        if (string.isEmpty() || string.equalsIgnoreCase("fcm") || string.equalsIgnoreCase("gcm")) {
            return "*";
        }
        return string;
    }

    private final String zzm() {
        if ("[DEFAULT]".equals(this.zzf.getName())) {
            return "";
        }
        return this.zzf.getPersistenceKey();
    }

    final boolean zza(@Nullable zzay zzay2) {
        return zzay2 == null || zzay2.zzb(this.zzg.zzc());
    }

    static final /* synthetic */ void zza(CountDownLatch countDownLatch, Task task) {
        countDownLatch.countDown();
    }

    final /* synthetic */ Task zza(String string, String string2, Task task) throws Exception {
        String string3 = this.zzl();
        zzay zzay2 = this.zzb(string, string2);
        if (!this.zza(zzay2)) {
            return Tasks.forResult((Object)new zzaa(string3, zzay2.zza));
        }
        return this.zzi.zza(string, string2, new zzp(this, string3, string, string2));
    }

    final /* synthetic */ Task zza(String string, String string2, String string3) {
        return this.zzh.zza(string, string2, string3).onSuccessTask(this.zze, (SuccessContinuation)new zzo(this, string2, string3, string));
    }

    final /* synthetic */ Task zza(String string, String string2, String string3, String string4) throws Exception {
        zzb.zza(this.zzm(), string, string2, string4, this.zzg.zzc());
        return Tasks.forResult((Object)new zzaa(string3, string4));
    }

    final /* synthetic */ void zzi() {
        if (this.zzl.zza()) {
            this.zzj();
        }
    }

    static {
        zzc = Pattern.compile("\\AA[\\w-]{38}\\z");
    }

    private final class zza {
        private boolean zzb;
        private final Subscriber zzc;
        @GuardedBy(value="this")
        private boolean zzd;
        @GuardedBy(value="this")
        @Nullable
        private EventHandler<DataCollectionDefaultChange> zze;
        @GuardedBy(value="this")
        @Nullable
        private Boolean zzf;

        zza(Subscriber subscriber) {
            this.zzc = subscriber;
        }

        private final synchronized void zzb() {
            if (this.zzd) {
                return;
            }
            this.zzb = this.zzd();
            this.zzf = this.zzc();
            if (this.zzf == null && this.zzb) {
                this.zze = new zzq(this);
                this.zzc.subscribe(DataCollectionDefaultChange.class, this.zze);
            }
            this.zzd = true;
        }

        final synchronized boolean zza() {
            this.zzb();
            if (this.zzf != null) {
                return this.zzf;
            }
            return this.zzb && FirebaseInstanceId.this.zzf.isDataCollectionDefaultEnabled();
        }

        final synchronized void zza(boolean bl) {
            this.zzb();
            if (this.zze != null) {
                this.zzc.unsubscribe(DataCollectionDefaultChange.class, this.zze);
                this.zze = null;
            }
            SharedPreferences.Editor editor = FirebaseInstanceId.this.zzf.getApplicationContext().getSharedPreferences("com.google.firebase.messaging", 0).edit();
            editor.putBoolean("auto_init", bl);
            editor.apply();
            if (bl) {
                FirebaseInstanceId.this.zzj();
            }
            this.zzf = bl;
        }

        @Nullable
        private final Boolean zzc() {
            Context context = FirebaseInstanceId.this.zzf.getApplicationContext();
            SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.firebase.messaging", 0);
            if (sharedPreferences.contains("auto_init")) {
                return sharedPreferences.getBoolean("auto_init", false);
            }
            try {
                ApplicationInfo applicationInfo;
                PackageManager packageManager = context.getPackageManager();
                if (packageManager != null && (applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128)) != null && applicationInfo.metaData != null && applicationInfo.metaData.containsKey("firebase_messaging_auto_init_enabled")) {
                    return applicationInfo.metaData.getBoolean("firebase_messaging_auto_init_enabled");
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
            return null;
        }

        private final boolean zzd() {
            try {
                Class.forName("com.google.firebase.messaging.FirebaseMessaging");
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Context context = FirebaseInstanceId.this.zzf.getApplicationContext();
                Intent intent = new Intent("com.google.firebase.MESSAGING_EVENT");
                intent.setPackage(context.getPackageName());
                ResolveInfo resolveInfo = context.getPackageManager().resolveService(intent, 0);
                return resolveInfo != null && resolveInfo.serviceInfo != null;
            }
        }
    }
}

