/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.SystemClock;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.FirebaseInstanceIdInternalReceiver;
import com.google.firebase.iid.zzb;
import com.google.firebase.iid.zzd;
import com.google.firebase.iid.zze;
import com.google.firebase.iid.zzf;
import java.io.IOException;

public class FirebaseInstanceIdService
extends zzb {
    private static BroadcastReceiver baz;
    private static final Object baA;
    private static boolean baB;
    private boolean baC = false;

    @Override
    protected int zzab(Intent intent) {
        this.baC = Log.isLoggable((String)"FirebaseInstanceId", (int)3);
        if (intent.getStringExtra("error") != null || intent.getStringExtra("registration_id") != null) {
            String string = this.zzad(intent);
            if (this.baC) {
                String string2 = String.valueOf(string);
                Log.d((String)"FirebaseInstanceId", (String)(string2.length() != 0 ? "Register result in service ".concat(string2) : new String("Register result in service ")));
            }
            this.zzsy(string).zzcwz().zzv(intent);
            this.zzble();
            return 2;
        }
        return super.zzab(intent);
    }

    @Override
    public void zzm(Intent intent) {
        String string = intent.getAction();
        if (string == null) {
            string = "";
        }
        switch (string) {
            case "ACTION_TOKEN_REFRESH_RETRY": {
                this.zza(intent, false);
                return;
            }
        }
        this.zzac(intent);
    }

    @Override
    protected Intent zzaa(Intent intent) {
        return FirebaseInstanceIdInternalReceiver.zzcww();
    }

    public void zzac(Intent intent) {
        String string = this.zzad(intent);
        zzd zzd2 = this.zzsy(string);
        String string2 = intent.getStringExtra("CMD");
        if (this.baC) {
            String string3 = String.valueOf(intent.getExtras());
            Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(18 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Service command ").append(string).append(" ").append(string2).append(" ").append(string3).toString());
        }
        if (null != intent.getStringExtra("unregistered")) {
            zzd2.zzcwy().zzkj(string == null ? "" : string);
            zzd2.zzcwz().zzv(intent);
            return;
        }
        if ("gcm.googleapis.com/refresh".equals(intent.getStringExtra("from"))) {
            zzd2.zzcwy().zzkj(string);
            this.zza(intent, false);
            return;
        }
        if ("RST".equals(string2)) {
            zzd2.zzblx();
            zzd2.zzcwy().zzkj(string);
            this.zza(intent, true);
        } else if ("RST_FULL".equals(string2)) {
            if (!zzd2.zzcwy().isEmpty()) {
                zzd2.zzblx();
                zzd2.zzcwy().zzbmd();
                this.zza(intent, true);
            }
        } else if ("SYNC".equals(string2)) {
            zzd2.zzcwy().zzkj(string);
            this.zza(intent, false);
        } else if ("PING".equals(string2)) {
            this.zza(zzd2.zzcwz(), intent.getExtras());
        }
    }

    private String zzad(Intent intent) {
        String string = intent.getStringExtra("subtype");
        return string == null ? "" : string;
    }

    private zzd zzsy(String string) {
        if (string == null) {
            return zzd.zzb((Context)this, null);
        }
        Bundle bundle = new Bundle();
        bundle.putString("subtype", string);
        return zzd.zzb((Context)this, bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(Intent intent, boolean bl) {
        Object object = baA;
        synchronized (object) {
            baB = false;
        }
        if (zzf.zzdi((Context)this) == null) {
            return;
        }
        object = FirebaseInstanceId.getInstance();
        zze zze2 = ((FirebaseInstanceId)object).zzcwv();
        if (((FirebaseInstanceId)object).zzcwt() == null) {
            try {
                String string = ((FirebaseInstanceId)object).zzcwu();
                if (string != null) {
                    if (this.baC) {
                        Log.d((String)"FirebaseInstanceId", (String)"get master token succeeded");
                    }
                    FirebaseInstanceIdService.zza((Context)this, (FirebaseInstanceId)object);
                    this.onTokenRefresh();
                    return;
                }
                this.zzd(intent, "returned token is null");
            }
            catch (IOException iOException) {
                this.zzd(intent, iOException.getMessage());
            }
            catch (SecurityException securityException) {
                Log.e((String)"FirebaseInstanceId", (String)"Unable to get master token", (Throwable)securityException);
                return;
            }
            return;
        }
        String string = zze2.zzcxa();
        while (string != null) {
            String[] stringArray = string.split("!");
            if (stringArray.length == 2) {
                String string2 = stringArray[0];
                String string3 = stringArray[1];
                try {
                    switch (string2) {
                        case "S": {
                            FirebaseInstanceId.getInstance().zzsw(string3);
                            if (!this.baC) break;
                            Log.d((String)"FirebaseInstanceId", (String)"subscribe operation succeeded");
                            break;
                        }
                        case "U": {
                            FirebaseInstanceId.getInstance().zzsx(string3);
                            if (!this.baC) break;
                            Log.d((String)"FirebaseInstanceId", (String)"unsubscribe operation succeeded");
                        }
                    }
                }
                catch (IOException iOException) {
                    this.zzd(intent, iOException.getMessage());
                    return;
                }
            }
            zze2.zzsz(string);
            string = zze2.zzcxa();
        }
        Log.d((String)"FirebaseInstanceId", (String)"topic sync succeeded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzd(Intent intent, String string) {
        boolean bl = FirebaseInstanceIdService.zzeo((Context)this);
        final int n = this.zzb(intent, bl);
        Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(47 + String.valueOf(string).length()).append("background sync failed: ").append(string).append(", retry in ").append(n).append("s").toString());
        Object object = baA;
        synchronized (object) {
            this.zzafb(n);
            baB = true;
        }
        if (!bl) {
            if (this.baC) {
                Log.d((String)"FirebaseInstanceId", (String)"device not connected. Connectivity change received registered");
            }
            if (baz == null) {
                baz = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        if (FirebaseInstanceIdService.zzeo(context)) {
                            if (FirebaseInstanceIdService.this.baC) {
                                Log.d((String)"FirebaseInstanceId", (String)"connectivity changed. starting background sync.");
                            }
                            FirebaseInstanceIdService.this.getApplicationContext().unregisterReceiver((BroadcastReceiver)this);
                            context.sendBroadcast(FirebaseInstanceIdService.zzafa(n));
                        }
                    }
                };
            }
            this.getApplicationContext().registerReceiver(baz, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zza(Context context, FirebaseInstanceId firebaseInstanceId) {
        Object object = baA;
        synchronized (object) {
            if (baB) {
                return;
            }
        }
        if (firebaseInstanceId.zzcwt() != null && firebaseInstanceId.zzcwv().zzcxa() == null) {
            return;
        }
        FirebaseInstanceIdService.zzen(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zzen(Context context) {
        if (zzf.zzdi(context) == null) {
            return;
        }
        Object object = baA;
        synchronized (object) {
            if (!baB) {
                context.sendBroadcast(FirebaseInstanceIdService.zzafa(0));
                baB = true;
            }
        }
    }

    private static Intent zzafa(int n) {
        Context context = FirebaseApp.getInstance().getApplicationContext();
        Intent intent = new Intent("ACTION_TOKEN_REFRESH_RETRY");
        intent.putExtra("next_retry_delay_in_seconds", n);
        return FirebaseInstanceIdInternalReceiver.zzh(context, intent);
    }

    private void zzafb(int n) {
        AlarmManager alarmManager = (AlarmManager)this.getSystemService("alarm");
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)FirebaseInstanceIdService.zzafa(n * 2), (int)0x10000000);
        alarmManager.set(3, SystemClock.elapsedRealtime() + (long)(n * 1000), pendingIntent);
    }

    private int zzb(Intent intent, boolean bl) {
        int n = intent == null ? 10 : intent.getIntExtra("next_retry_delay_in_seconds", 0);
        if (n < 10 && !bl) {
            n = 30;
        } else if (n < 10) {
            n = 10;
        } else if (n > 28800) {
            n = 28800;
        }
        return n;
    }

    private static boolean zzeo(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    private void zza(zzf zzf2, Bundle bundle) {
        String string = zzf.zzdi((Context)this);
        if (string == null) {
            Log.w((String)"FirebaseInstanceId", (String)"Unable to respond to ping due to missing target package");
            return;
        }
        Intent intent = new Intent("com.google.android.gcm.intent.SEND");
        intent.setPackage(string);
        intent.putExtras(bundle);
        zzf2.zzs(intent);
        intent.putExtra("google.to", "google.com/iid");
        intent.putExtra("google.message_id", zzf.zzbmc());
        this.sendOrderedBroadcast(intent, "com.google.android.gtalkservice.permission.GTALK_SERVICE");
    }

    @WorkerThread
    public void onTokenRefresh() {
    }

    static {
        baA = new Object();
        baB = false;
    }
}

