/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.display.internal;

import androidx.annotation.Nullable;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.Target;
import com.google.firebase.inappmessaging.FirebaseInAppMessagingDisplayCallbacks;
import com.google.firebase.inappmessaging.display.internal.Logging;
import com.google.firebase.inappmessaging.display.internal.injection.scopes.FirebaseAppScope;
import com.google.firebase.inappmessaging.model.InAppMessage;
import javax.inject.Inject;

@FirebaseAppScope
public class GlideErrorListener
implements RequestListener<Object> {
    private InAppMessage inAppMessage;
    private FirebaseInAppMessagingDisplayCallbacks displayCallbacks;

    @Inject
    GlideErrorListener() {
    }

    public void setInAppMessage(InAppMessage inAppMessage, FirebaseInAppMessagingDisplayCallbacks displayCallbacks) {
        this.inAppMessage = inAppMessage;
        this.displayCallbacks = displayCallbacks;
    }

    public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Object> target, boolean isFirstResource) {
        Logging.logd("Image Downloading  Error : " + e.getMessage() + ":" + e.getCause());
        if (this.inAppMessage != null && this.displayCallbacks != null) {
            if (e.getLocalizedMessage().contains("Failed to decode")) {
                this.displayCallbacks.displayErrorEncountered(FirebaseInAppMessagingDisplayCallbacks.InAppMessagingErrorReason.IMAGE_UNSUPPORTED_FORMAT);
            } else {
                this.displayCallbacks.displayErrorEncountered(FirebaseInAppMessagingDisplayCallbacks.InAppMessagingErrorReason.UNSPECIFIED_RENDER_ERROR);
            }
        }
        return false;
    }

    public boolean onResourceReady(Object resource, Object model, Target<Object> target, DataSource dataSource, boolean isFirstResource) {
        Logging.logd("Image Downloading  Success : " + resource);
        return false;
    }
}

