/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.internal;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.os.Handler;
import com.google.firebase.inappmessaging.internal.Logging;
import io.reactivex.BackpressureStrategy;
import io.reactivex.flowables.ConnectableFlowable;
import io.reactivex.subjects.BehaviorSubject;

public class ForegroundNotifier
implements Application.ActivityLifecycleCallbacks {
    public static final long DELAY_MILLIS = 1000L;
    private final Handler handler = new Handler();
    private boolean foreground = false;
    private boolean paused = true;
    private Runnable check;
    private final BehaviorSubject<String> foregroundSubject = BehaviorSubject.create();

    public ConnectableFlowable<String> foregroundFlowable() {
        return this.foregroundSubject.toFlowable(BackpressureStrategy.BUFFER).publish();
    }

    public void onActivityResumed(Activity activity) {
        this.paused = false;
        boolean wasBackground = !this.foreground;
        this.foreground = true;
        if (this.check != null) {
            this.handler.removeCallbacks(this.check);
        }
        if (wasBackground) {
            Logging.logi("went foreground");
            this.foregroundSubject.onNext((Object)"ON_FOREGROUND");
        }
    }

    public void onActivityPaused(Activity activity) {
        this.paused = true;
        if (this.check != null) {
            this.handler.removeCallbacks(this.check);
        }
        this.check = () -> {
            this.foreground = (!this.foreground || !this.paused) && this.foreground;
        };
        this.handler.postDelayed(this.check, 1000L);
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

