/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.internal;

import android.app.Application;
import com.google.firebase.inappmessaging.internal.Logging;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Parser;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ProtoStorageClient {
    private final Application application;
    private final String fileName;

    public ProtoStorageClient(Application application, String fileName) {
        this.application = application;
        this.fileName = fileName;
    }

    public Completable write(AbstractMessageLite messageLite) {
        return Completable.fromCallable(() -> {
            ProtoStorageClient protoStorageClient = this;
            synchronized (protoStorageClient) {
                AbstractMessageLite abstractMessageLite;
                block9: {
                    FileOutputStream output = this.application.openFileOutput(this.fileName, 0);
                    try {
                        output.write(messageLite.toByteArray());
                        abstractMessageLite = messageLite;
                        if (output == null) break block9;
                    }
                    catch (Throwable throwable) {
                        if (output != null) {
                            try {
                                output.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    output.close();
                }
                return abstractMessageLite;
            }
        });
    }

    public <T extends AbstractMessageLite> Maybe<T> read(Parser<T> parser) {
        return Maybe.fromCallable(() -> {
            ProtoStorageClient protoStorageClient = this;
            synchronized (protoStorageClient) {
                AbstractMessageLite abstractMessageLite;
                block12: {
                    FileInputStream inputStream = this.application.openFileInput(this.fileName);
                    try {
                        abstractMessageLite = (AbstractMessageLite)parser.parseFrom((InputStream)inputStream);
                        if (inputStream == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (InvalidProtocolBufferException | FileNotFoundException e) {
                            Logging.logi("Recoverable exception while reading cache: " + e.getMessage());
                            return null;
                        }
                    }
                    inputStream.close();
                }
                return abstractMessageLite;
            }
        });
    }
}

