/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.model;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.inappmessaging.model.Action;
import com.google.firebase.inappmessaging.model.CampaignMetadata;
import com.google.firebase.inappmessaging.model.ImageData;
import com.google.firebase.inappmessaging.model.InAppMessage;
import com.google.firebase.inappmessaging.model.MessageType;
import com.google.firebase.inappmessaging.model.Text;
import java.util.Map;

public class CardMessage
extends InAppMessage {
    @NonNull
    private final Text title;
    @Nullable
    private final Text body;
    @NonNull
    private final String backgroundHexColor;
    @NonNull
    private final Action primaryAction;
    @Nullable
    private final Action secondaryAction;
    @Nullable
    private final ImageData portraitImageData;
    @Nullable
    private final ImageData landscapeImageData;

    public int hashCode() {
        int bodyHash = this.body != null ? this.body.hashCode() : 0;
        int secondaryActionHash = this.secondaryAction != null ? this.secondaryAction.hashCode() : 0;
        int portraitImageHash = this.portraitImageData != null ? this.portraitImageData.hashCode() : 0;
        int landscapeImageHash = this.landscapeImageData != null ? this.landscapeImageData.hashCode() : 0;
        return this.title.hashCode() + bodyHash + this.backgroundHexColor.hashCode() + this.primaryAction.hashCode() + secondaryActionHash + portraitImageHash + landscapeImageHash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CardMessage)) {
            return false;
        }
        CardMessage c = (CardMessage)o;
        if (this.hashCode() != c.hashCode()) {
            return false;
        }
        if (this.body == null && c.body != null || this.body != null && !this.body.equals(c.body)) {
            return false;
        }
        if (this.secondaryAction == null && c.secondaryAction != null || this.secondaryAction != null && !this.secondaryAction.equals(c.secondaryAction)) {
            return false;
        }
        if (this.portraitImageData == null && c.portraitImageData != null || this.portraitImageData != null && !this.portraitImageData.equals(c.portraitImageData)) {
            return false;
        }
        if (this.landscapeImageData == null && c.landscapeImageData != null || this.landscapeImageData != null && !this.landscapeImageData.equals(c.landscapeImageData)) {
            return false;
        }
        if (!this.title.equals(c.title)) {
            return false;
        }
        if (!this.primaryAction.equals(c.primaryAction)) {
            return false;
        }
        return this.backgroundHexColor.equals(c.backgroundHexColor);
    }

    private CardMessage(@NonNull CampaignMetadata campaignMetadata, @NonNull Text title, @Nullable Text body, @Nullable ImageData portraitImageData, @Nullable ImageData landscapeImageData, @NonNull String backgroundHexColor, @NonNull Action primaryAction, @Nullable Action secondaryAction, @Nullable Map<String, String> data) {
        super(campaignMetadata, MessageType.CARD, data);
        this.title = title;
        this.body = body;
        this.portraitImageData = portraitImageData;
        this.landscapeImageData = landscapeImageData;
        this.backgroundHexColor = backgroundHexColor;
        this.primaryAction = primaryAction;
        this.secondaryAction = secondaryAction;
    }

    @Nullable
    public ImageData getPortraitImageData() {
        return this.portraitImageData;
    }

    @Nullable
    public ImageData getLandscapeImageData() {
        return this.landscapeImageData;
    }

    @Override
    @NonNull
    public String getBackgroundHexColor() {
        return this.backgroundHexColor;
    }

    @NonNull
    public Action getPrimaryAction() {
        return this.primaryAction;
    }

    @Nullable
    public Action getSecondaryAction() {
        return this.secondaryAction;
    }

    @Override
    @Deprecated
    @Nullable
    public Action getAction() {
        return this.primaryAction;
    }

    @Override
    @NonNull
    public Text getTitle() {
        return this.title;
    }

    @Override
    @Nullable
    public Text getBody() {
        return this.body;
    }

    @Override
    @Deprecated
    @Nullable
    public ImageData getImageData() {
        return this.portraitImageData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable
        ImageData portraitImageData;
        @Nullable
        ImageData landscapeImageData;
        @Nullable
        String backgroundHexColor;
        @Nullable
        Action primaryAction;
        @Nullable
        Text title;
        @Nullable
        Text body;
        @Nullable
        Action secondaryAction;

        public Builder setPortraitImageData(@Nullable ImageData portraitImageData) {
            this.portraitImageData = portraitImageData;
            return this;
        }

        public Builder setLandscapeImageData(@Nullable ImageData landscapeImageData) {
            this.landscapeImageData = landscapeImageData;
            return this;
        }

        public Builder setBackgroundHexColor(@Nullable String backgroundHexColor) {
            this.backgroundHexColor = backgroundHexColor;
            return this;
        }

        public Builder setPrimaryAction(@Nullable Action primaryAction) {
            this.primaryAction = primaryAction;
            return this;
        }

        public Builder setSecondaryAction(@Nullable Action secondaryAction) {
            this.secondaryAction = secondaryAction;
            return this;
        }

        public Builder setTitle(@Nullable Text title) {
            this.title = title;
            return this;
        }

        public Builder setBody(@Nullable Text body) {
            this.body = body;
            return this;
        }

        public CardMessage build(CampaignMetadata campaignMetadata, @Nullable Map<String, String> data) {
            if (this.primaryAction == null) {
                throw new IllegalArgumentException("Card model must have a primary action");
            }
            if (this.primaryAction.getButton() == null) {
                throw new IllegalArgumentException("Card model must have a primary action button");
            }
            if (this.secondaryAction != null && this.secondaryAction.getButton() == null) {
                throw new IllegalArgumentException("Card model secondary action must be null or have a button");
            }
            if (this.title == null) {
                throw new IllegalArgumentException("Card model must have a title");
            }
            if (this.portraitImageData == null && this.landscapeImageData == null) {
                throw new IllegalArgumentException("Card model must have at least one image");
            }
            if (TextUtils.isEmpty((CharSequence)this.backgroundHexColor)) {
                throw new IllegalArgumentException("Card model must have a background color");
            }
            return new CardMessage(campaignMetadata, this.title, this.body, this.portraitImageData, this.landscapeImageData, this.backgroundHexColor, this.primaryAction, this.secondaryAction, data);
        }
    }
}

