/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.internal;

import android.app.Application;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;
import com.google.developers.mobile.targeting.proto.ClientSignalsProto;
import com.google.firebase.FirebaseApp;
import com.google.firebase.inappmessaging.internal.GrpcClient;
import com.google.firebase.inappmessaging.internal.InstallationIdResult;
import com.google.firebase.inappmessaging.internal.Logging;
import com.google.firebase.inappmessaging.internal.ProviderInstaller;
import com.google.firebase.inappmessaging.internal.injection.scopes.FirebaseAppScope;
import com.google.firebase.inappmessaging.internal.time.Clock;
import com.google.internal.firebase.inappmessaging.v1.sdkserving.CampaignImpressionList;
import com.google.internal.firebase.inappmessaging.v1.sdkserving.ClientAppInfo;
import com.google.internal.firebase.inappmessaging.v1.sdkserving.FetchEligibleCampaignsRequest;
import com.google.internal.firebase.inappmessaging.v1.sdkserving.FetchEligibleCampaignsResponse;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.inject.Provider;

@FirebaseAppScope
public class ApiClient {
    private static final String FETCHING_CAMPAIGN_MESSAGE = "Fetching campaigns from service.";
    private final Provider<GrpcClient> grpcClient;
    private final FirebaseApp firebaseApp;
    private final Application application;
    private final Clock clock;
    private final ProviderInstaller providerInstaller;

    public ApiClient(Provider<GrpcClient> grpcClient, FirebaseApp firebaseApp, Application application, Clock clock, ProviderInstaller providerInstaller) {
        this.grpcClient = grpcClient;
        this.firebaseApp = firebaseApp;
        this.application = application;
        this.clock = clock;
        this.providerInstaller = providerInstaller;
    }

    FetchEligibleCampaignsResponse getFiams(InstallationIdResult installationIdResult, CampaignImpressionList impressionList) {
        Logging.logi(FETCHING_CAMPAIGN_MESSAGE);
        this.providerInstaller.install();
        return this.withCacheExpirationSafeguards(((GrpcClient)this.grpcClient.get()).fetchEligibleCampaigns((FetchEligibleCampaignsRequest)FetchEligibleCampaignsRequest.newBuilder().setProjectNumber(this.firebaseApp.getOptions().getGcmSenderId()).addAllAlreadySeenCampaigns(impressionList.getAlreadySeenCampaignsList()).setClientSignals(this.getClientSignals()).setRequestingClientApp(this.getClientAppInfo(installationIdResult)).build()));
    }

    private FetchEligibleCampaignsResponse withCacheExpirationSafeguards(FetchEligibleCampaignsResponse resp) {
        if (resp.getExpirationEpochTimestampMillis() < this.clock.now() + TimeUnit.MINUTES.toMillis(1L) || resp.getExpirationEpochTimestampMillis() > this.clock.now() + TimeUnit.DAYS.toMillis(3L)) {
            return (FetchEligibleCampaignsResponse)((FetchEligibleCampaignsResponse.Builder)resp.toBuilder()).setExpirationEpochTimestampMillis(this.clock.now() + TimeUnit.DAYS.toMillis(1L)).build();
        }
        return resp;
    }

    private ClientSignalsProto.ClientSignals getClientSignals() {
        ClientSignalsProto.ClientSignals.Builder clientSignals = ClientSignalsProto.ClientSignals.newBuilder().setPlatformVersion(String.valueOf(Build.VERSION.SDK_INT)).setLanguageCode(Locale.getDefault().toString()).setTimeZone(TimeZone.getDefault().getID());
        String versionName = this.getVersionName();
        if (!TextUtils.isEmpty((CharSequence)versionName)) {
            clientSignals.setAppVersion(versionName);
        }
        return (ClientSignalsProto.ClientSignals)clientSignals.build();
    }

    private ClientAppInfo getClientAppInfo(InstallationIdResult installationIdResult) {
        return (ClientAppInfo)ClientAppInfo.newBuilder().setGmpAppId(this.firebaseApp.getOptions().getApplicationId()).setAppInstanceId(installationIdResult.installationId()).setAppInstanceIdToken(installationIdResult.installationTokenResult().getToken()).build();
    }

    @Nullable
    private String getVersionName() {
        try {
            PackageInfo pInfo = this.application.getPackageManager().getPackageInfo(this.application.getPackageName(), 0);
            return pInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            Logging.loge("Error finding versionName : " + e.getMessage());
            return null;
        }
    }
}

