/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.installations.remote;

import android.content.Context;
import android.content.pm.PackageManager;
import android.net.TrafficStats;
import android.text.TextUtils;
import android.util.JsonReader;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.AndroidUtilsLight;
import com.google.android.gms.common.util.Hex;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.heartbeatinfo.HeartBeatController;
import com.google.firebase.inject.Provider;
import com.google.firebase.installations.FirebaseInstallationsException;
import com.google.firebase.installations.remote.InstallationResponse;
import com.google.firebase.installations.remote.RequestLimiter;
import com.google.firebase.installations.remote.TokenResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import org.json.JSONException;
import org.json.JSONObject;

public class FirebaseInstallationServiceClient {
    private static final int TRAFFIC_STATS_FIREBASE_INSTALLATIONS_TAG = 32768;
    private static final int TRAFFIC_STATS_CREATE_INSTALLATION_TAG = 32769;
    private static final int TRAFFIC_STATS_DELETE_INSTALLATION_TAG = 32770;
    private static final int TRAFFIC_STATS_GENERATE_AUTH_TOKEN_TAG = 32771;
    private static final String FIREBASE_INSTALLATIONS_API_DOMAIN = "firebaseinstallations.googleapis.com";
    private static final String CREATE_REQUEST_RESOURCE_NAME_FORMAT = "projects/%s/installations";
    private static final String GENERATE_AUTH_TOKEN_REQUEST_RESOURCE_NAME_FORMAT = "projects/%s/installations/%s/authTokens:generate";
    private static final String DELETE_REQUEST_RESOURCE_NAME_FORMAT = "projects/%s/installations/%s";
    private static final String FIREBASE_INSTALLATIONS_API_VERSION = "v1";
    private static final String FIREBASE_INSTALLATION_AUTH_VERSION = "FIS_v2";
    private static final String CONTENT_TYPE_HEADER_KEY = "Content-Type";
    private static final String ACCEPT_HEADER_KEY = "Accept";
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final String CONTENT_ENCODING_HEADER_KEY = "Content-Encoding";
    private static final String GZIP_CONTENT_ENCODING = "gzip";
    private static final String CACHE_CONTROL_HEADER_KEY = "Cache-Control";
    private static final String CACHE_CONTROL_DIRECTIVE = "no-cache";
    private static final String FIREBASE_INSTALLATIONS_ID_HEARTBEAT_TAG = "fire-installations-id";
    private static final String HEART_BEAT_HEADER = "x-firebase-client";
    private static final String X_ANDROID_PACKAGE_HEADER_KEY = "X-Android-Package";
    private static final String X_ANDROID_CERT_HEADER_KEY = "X-Android-Cert";
    private static final String X_ANDROID_IID_MIGRATION_KEY = "x-goog-fis-android-iid-migration-auth";
    private static final String API_KEY_HEADER = "x-goog-api-key";
    private static final int NETWORK_TIMEOUT_MILLIS = 10000;
    private static final Pattern EXPIRATION_TIMESTAMP_PATTERN = Pattern.compile("[0-9]+s");
    private static final int MAX_RETRIES = 1;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String SDK_VERSION_PREFIX = "a:";
    private static final String FIS_TAG = "Firebase-Installations";
    private boolean shouldServerErrorRetry;
    @VisibleForTesting
    static final String PARSING_EXPIRATION_TIME_ERROR_MESSAGE = "Invalid Expiration Timestamp.";
    private final Context context;
    private final Provider<HeartBeatController> heartBeatProvider;
    private final RequestLimiter requestLimiter;

    public FirebaseInstallationServiceClient(@NonNull Context context, @NonNull Provider<HeartBeatController> heartBeatProvider) {
        this.context = context;
        this.heartBeatProvider = heartBeatProvider;
        this.requestLimiter = new RequestLimiter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public InstallationResponse createFirebaseInstallation(@NonNull String apiKey, @Nullable String fid, @NonNull String projectID, @NonNull String appId, @Nullable String iidToken) throws FirebaseInstallationsException {
        if (!this.requestLimiter.isRequestAllowed()) {
            throw new FirebaseInstallationsException("Firebase Installations Service is unavailable. Please try again later.", FirebaseInstallationsException.Status.UNAVAILABLE);
        }
        String resourceName = String.format(CREATE_REQUEST_RESOURCE_NAME_FORMAT, projectID);
        URL url = this.getFullyQualifiedRequestUri(resourceName);
        for (int retryCount = 0; retryCount <= 1; ++retryCount) {
            TrafficStats.setThreadStatsTag((int)32769);
            HttpURLConnection httpURLConnection = this.openHttpURLConnection(url, apiKey);
            try {
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.setDoOutput(true);
                if (iidToken != null) {
                    httpURLConnection.addRequestProperty(X_ANDROID_IID_MIGRATION_KEY, iidToken);
                }
                this.writeFIDCreateRequestBodyToOutputStream(httpURLConnection, fid, appId);
                int httpResponseCode = httpURLConnection.getResponseCode();
                this.requestLimiter.setNextRequestTime(httpResponseCode);
                if (FirebaseInstallationServiceClient.isSuccessfulResponseCode(httpResponseCode)) {
                    InstallationResponse installationResponse = this.readCreateResponse(httpURLConnection);
                    return installationResponse;
                }
                FirebaseInstallationServiceClient.logFisCommunicationError(httpURLConnection, appId, apiKey, projectID);
                if (httpResponseCode == 429) {
                    throw new FirebaseInstallationsException("Firebase servers have received too many requests from this client in a short period of time. Please try again later.", FirebaseInstallationsException.Status.TOO_MANY_REQUESTS);
                }
                if (httpResponseCode >= 500 && httpResponseCode < 600) continue;
                FirebaseInstallationServiceClient.logBadConfigError();
                InstallationResponse installationResponse = InstallationResponse.builder().setResponseCode(InstallationResponse.ResponseCode.BAD_CONFIG).build();
                return installationResponse;
            }
            catch (IOException | AssertionError ignored) {
                continue;
            }
            finally {
                httpURLConnection.disconnect();
                TrafficStats.clearThreadStatsTag();
            }
        }
        throw new FirebaseInstallationsException("Firebase Installations Service is unavailable. Please try again later.", FirebaseInstallationsException.Status.UNAVAILABLE);
    }

    private void writeFIDCreateRequestBodyToOutputStream(HttpURLConnection httpURLConnection, @Nullable String fid, @NonNull String appId) throws IOException {
        FirebaseInstallationServiceClient.writeRequestBodyToOutputStream(httpURLConnection, FirebaseInstallationServiceClient.getJsonBytes(FirebaseInstallationServiceClient.buildCreateFirebaseInstallationRequestBody(fid, appId)));
    }

    private static byte[] getJsonBytes(JSONObject jsonObject) throws IOException {
        return jsonObject.toString().getBytes("UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeRequestBodyToOutputStream(URLConnection urlConnection, byte[] jsonBytes) throws IOException {
        OutputStream outputStream = urlConnection.getOutputStream();
        if (outputStream == null) {
            throw new IOException("Cannot send request to FIS servers. No OutputStream available.");
        }
        GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStream);
        try {
            gzipOutputStream.write(jsonBytes);
        }
        finally {
            try {
                gzipOutputStream.close();
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static JSONObject buildCreateFirebaseInstallationRequestBody(@Nullable String fid, @NonNull String appId) {
        try {
            JSONObject firebaseInstallationData = new JSONObject();
            firebaseInstallationData.put("fid", (Object)fid);
            firebaseInstallationData.put("appId", (Object)appId);
            firebaseInstallationData.put("authVersion", (Object)FIREBASE_INSTALLATION_AUTH_VERSION);
            firebaseInstallationData.put("sdkVersion", (Object)"a:17.0.3");
            return firebaseInstallationData;
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
    }

    private void writeGenerateAuthTokenRequestBodyToOutputStream(HttpURLConnection httpURLConnection) throws IOException {
        FirebaseInstallationServiceClient.writeRequestBodyToOutputStream(httpURLConnection, FirebaseInstallationServiceClient.getJsonBytes(FirebaseInstallationServiceClient.buildGenerateAuthTokenRequestBody()));
    }

    private static JSONObject buildGenerateAuthTokenRequestBody() {
        try {
            JSONObject sdkVersionData = new JSONObject();
            sdkVersionData.put("sdkVersion", (Object)"a:17.0.3");
            JSONObject firebaseInstallationData = new JSONObject();
            firebaseInstallationData.put("installation", (Object)sdkVersionData);
            return firebaseInstallationData;
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public void deleteFirebaseInstallation(@NonNull String apiKey, @NonNull String fid, @NonNull String projectID, @NonNull String refreshToken) throws FirebaseInstallationsException {
        String resourceName = String.format(DELETE_REQUEST_RESOURCE_NAME_FORMAT, projectID, fid);
        URL url = this.getFullyQualifiedRequestUri(resourceName);
        int retryCount = 0;
        while (retryCount <= 1) {
            HttpURLConnection httpURLConnection;
            block8: {
                int httpResponseCode;
                block7: {
                    TrafficStats.setThreadStatsTag((int)32770);
                    httpURLConnection = this.openHttpURLConnection(url, apiKey);
                    httpURLConnection.setRequestMethod("DELETE");
                    httpURLConnection.addRequestProperty("Authorization", "FIS_v2 " + refreshToken);
                    httpResponseCode = httpURLConnection.getResponseCode();
                    if (httpResponseCode != 200 && httpResponseCode != 401 && httpResponseCode != 404) break block7;
                    httpURLConnection.disconnect();
                    TrafficStats.clearThreadStatsTag();
                    return;
                }
                FirebaseInstallationServiceClient.logFisCommunicationError(httpURLConnection, null, apiKey, projectID);
                if (httpResponseCode != 429 && (httpResponseCode < 500 || httpResponseCode >= 600)) break block8;
                ++retryCount;
                httpURLConnection.disconnect();
                TrafficStats.clearThreadStatsTag();
                continue;
            }
            try {
                try {
                    FirebaseInstallationServiceClient.logBadConfigError();
                    throw new FirebaseInstallationsException("Bad config while trying to delete FID", FirebaseInstallationsException.Status.BAD_CONFIG);
                }
                catch (IOException ignored) {
                    ++retryCount;
                    httpURLConnection.disconnect();
                    TrafficStats.clearThreadStatsTag();
                }
            }
            catch (Throwable throwable) {
                httpURLConnection.disconnect();
                TrafficStats.clearThreadStatsTag();
                throw throwable;
            }
        }
        throw new FirebaseInstallationsException("Firebase Installations Service is unavailable. Please try again later.", FirebaseInstallationsException.Status.UNAVAILABLE);
    }

    private URL getFullyQualifiedRequestUri(String resourceName) throws FirebaseInstallationsException {
        try {
            return new URL(String.format("https://%s/%s/%s", FIREBASE_INSTALLATIONS_API_DOMAIN, FIREBASE_INSTALLATIONS_API_VERSION, resourceName));
        }
        catch (MalformedURLException e) {
            throw new FirebaseInstallationsException(e.getMessage(), FirebaseInstallationsException.Status.UNAVAILABLE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public TokenResult generateAuthToken(@NonNull String apiKey, @NonNull String fid, @NonNull String projectID, @NonNull String refreshToken) throws FirebaseInstallationsException {
        if (!this.requestLimiter.isRequestAllowed()) {
            throw new FirebaseInstallationsException("Firebase Installations Service is unavailable. Please try again later.", FirebaseInstallationsException.Status.UNAVAILABLE);
        }
        String resourceName = String.format(GENERATE_AUTH_TOKEN_REQUEST_RESOURCE_NAME_FORMAT, projectID, fid);
        URL url = this.getFullyQualifiedRequestUri(resourceName);
        for (int retryCount = 0; retryCount <= 1; ++retryCount) {
            TrafficStats.setThreadStatsTag((int)32771);
            HttpURLConnection httpURLConnection = this.openHttpURLConnection(url, apiKey);
            try {
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.addRequestProperty("Authorization", "FIS_v2 " + refreshToken);
                httpURLConnection.setDoOutput(true);
                this.writeGenerateAuthTokenRequestBodyToOutputStream(httpURLConnection);
                int httpResponseCode = httpURLConnection.getResponseCode();
                this.requestLimiter.setNextRequestTime(httpResponseCode);
                if (FirebaseInstallationServiceClient.isSuccessfulResponseCode(httpResponseCode)) {
                    TokenResult tokenResult = this.readGenerateAuthTokenResponse(httpURLConnection);
                    return tokenResult;
                }
                FirebaseInstallationServiceClient.logFisCommunicationError(httpURLConnection, null, apiKey, projectID);
                if (httpResponseCode == 401 || httpResponseCode == 404) {
                    TokenResult tokenResult = TokenResult.builder().setResponseCode(TokenResult.ResponseCode.AUTH_ERROR).build();
                    return tokenResult;
                }
                if (httpResponseCode == 429) {
                    throw new FirebaseInstallationsException("Firebase servers have received too many requests from this client in a short period of time. Please try again later.", FirebaseInstallationsException.Status.TOO_MANY_REQUESTS);
                }
                if (httpResponseCode >= 500 && httpResponseCode < 600) continue;
                FirebaseInstallationServiceClient.logBadConfigError();
                TokenResult tokenResult = TokenResult.builder().setResponseCode(TokenResult.ResponseCode.BAD_CONFIG).build();
                return tokenResult;
            }
            catch (IOException | AssertionError ignored) {
                continue;
            }
            finally {
                httpURLConnection.disconnect();
                TrafficStats.clearThreadStatsTag();
            }
        }
        throw new FirebaseInstallationsException("Firebase Installations Service is unavailable. Please try again later.", FirebaseInstallationsException.Status.UNAVAILABLE);
    }

    private static boolean isSuccessfulResponseCode(int responseCode) {
        return responseCode >= 200 && responseCode < 300;
    }

    private static void logBadConfigError() {
        Log.e((String)FIS_TAG, (String)"Firebase Installations can not communicate with Firebase server APIs due to invalid configuration. Please update your Firebase initialization process and set valid Firebase options (API key, Project ID, Application ID) when initializing Firebase.");
    }

    private HttpURLConnection openHttpURLConnection(URL url, String apiKey) throws FirebaseInstallationsException {
        HttpURLConnection httpURLConnection;
        try {
            httpURLConnection = (HttpURLConnection)url.openConnection();
        }
        catch (IOException ignored) {
            throw new FirebaseInstallationsException("Firebase Installations Service is unavailable. Please try again later.", FirebaseInstallationsException.Status.UNAVAILABLE);
        }
        httpURLConnection.setConnectTimeout(10000);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setReadTimeout(10000);
        httpURLConnection.addRequestProperty(CONTENT_TYPE_HEADER_KEY, JSON_CONTENT_TYPE);
        httpURLConnection.addRequestProperty(ACCEPT_HEADER_KEY, JSON_CONTENT_TYPE);
        httpURLConnection.addRequestProperty(CONTENT_ENCODING_HEADER_KEY, GZIP_CONTENT_ENCODING);
        httpURLConnection.addRequestProperty(CACHE_CONTROL_HEADER_KEY, CACHE_CONTROL_DIRECTIVE);
        httpURLConnection.addRequestProperty(X_ANDROID_PACKAGE_HEADER_KEY, this.context.getPackageName());
        HeartBeatController heartBeatController = (HeartBeatController)this.heartBeatProvider.get();
        if (heartBeatController != null) {
            try {
                httpURLConnection.addRequestProperty(HEART_BEAT_HEADER, (String)Tasks.await((Task)heartBeatController.getHeartBeatsHeader()));
            }
            catch (ExecutionException e) {
                Log.w((String)"ContentValues", (String)"Failed to get heartbeats header", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Log.w((String)"ContentValues", (String)"Failed to get heartbeats header", (Throwable)e);
            }
        }
        httpURLConnection.addRequestProperty(X_ANDROID_CERT_HEADER_KEY, this.getFingerprintHashForPackage());
        httpURLConnection.addRequestProperty(API_KEY_HEADER, apiKey);
        return httpURLConnection;
    }

    private InstallationResponse readCreateResponse(HttpURLConnection conn) throws AssertionError, IOException {
        InputStream inputStream = conn.getInputStream();
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream, UTF_8));
        TokenResult.Builder tokenResult = TokenResult.builder();
        InstallationResponse.Builder builder = InstallationResponse.builder();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("name")) {
                builder.setUri(reader.nextString());
                continue;
            }
            if (name.equals("fid")) {
                builder.setFid(reader.nextString());
                continue;
            }
            if (name.equals("refreshToken")) {
                builder.setRefreshToken(reader.nextString());
                continue;
            }
            if (name.equals("authToken")) {
                reader.beginObject();
                while (reader.hasNext()) {
                    String key = reader.nextName();
                    if (key.equals("token")) {
                        tokenResult.setToken(reader.nextString());
                        continue;
                    }
                    if (key.equals("expiresIn")) {
                        tokenResult.setTokenExpirationTimestamp(FirebaseInstallationServiceClient.parseTokenExpirationTimestamp(reader.nextString()));
                        continue;
                    }
                    reader.skipValue();
                }
                builder.setAuthToken(tokenResult.build());
                reader.endObject();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        reader.close();
        inputStream.close();
        return builder.setResponseCode(InstallationResponse.ResponseCode.OK).build();
    }

    private TokenResult readGenerateAuthTokenResponse(HttpURLConnection conn) throws AssertionError, IOException {
        InputStream inputStream = conn.getInputStream();
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream, UTF_8));
        TokenResult.Builder builder = TokenResult.builder();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("token")) {
                builder.setToken(reader.nextString());
                continue;
            }
            if (name.equals("expiresIn")) {
                builder.setTokenExpirationTimestamp(FirebaseInstallationServiceClient.parseTokenExpirationTimestamp(reader.nextString()));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        reader.close();
        inputStream.close();
        return builder.setResponseCode(TokenResult.ResponseCode.OK).build();
    }

    private String getFingerprintHashForPackage() {
        try {
            byte[] hash = AndroidUtilsLight.getPackageCertificateHashBytes((Context)this.context, (String)this.context.getPackageName());
            if (hash == null) {
                Log.e((String)"ContentValues", (String)("Could not get fingerprint hash for package: " + this.context.getPackageName()));
                return null;
            }
            return Hex.bytesToStringUppercase((byte[])hash, (boolean)false);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)"ContentValues", (String)("No such package: " + this.context.getPackageName()), (Throwable)e);
            return null;
        }
    }

    @VisibleForTesting
    static long parseTokenExpirationTimestamp(String expiresIn) {
        Preconditions.checkArgument((boolean)EXPIRATION_TIMESTAMP_PATTERN.matcher(expiresIn).matches(), (Object)PARSING_EXPIRATION_TIME_ERROR_MESSAGE);
        return expiresIn == null || expiresIn.length() == 0 ? 0L : Long.parseLong(expiresIn.substring(0, expiresIn.length() - 1));
    }

    private static void logFisCommunicationError(HttpURLConnection conn, @Nullable String appId, @NonNull String apiKey, @NonNull String projectId) {
        String logString = FirebaseInstallationServiceClient.readErrorResponse(conn);
        if (!TextUtils.isEmpty((CharSequence)logString)) {
            Log.w((String)FIS_TAG, (String)logString);
            Log.w((String)FIS_TAG, (String)FirebaseInstallationServiceClient.availableFirebaseOptions(appId, apiKey, projectId));
        }
    }

    private static String availableFirebaseOptions(@Nullable String appId, @NonNull String apiKey, @NonNull String projectId) {
        return String.format("Firebase options used while communicating with Firebase server APIs: %s, %s%s", apiKey, projectId, TextUtils.isEmpty((CharSequence)appId) ? "" : ", " + appId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String readErrorResponse(HttpURLConnection conn) {
        InputStream errorStream = conn.getErrorStream();
        if (errorStream == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream, UTF_8));
        try {
            StringBuilder response = new StringBuilder();
            String input = reader.readLine();
            while (input != null) {
                response.append(input).append('\n');
                input = reader.readLine();
            }
            String string = String.format("Error when communicating with the Firebase Installations server API. HTTP response: [%d %s: %s]", conn.getResponseCode(), conn.getResponseMessage(), response);
            return string;
        }
        catch (IOException ignored) {
            String string = null;
            return string;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }
}

