/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.analytics.connector;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.firebase.FirebaseApp;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.analytics.connector.internal.zzb;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AnalyticsConnectorImpl
implements AnalyticsConnector {
    private final AppMeasurement zzbop;
    private static volatile AnalyticsConnector zzboq;
    @VisibleForTesting
    private final Map<String, Object> zzbor;

    private AnalyticsConnectorImpl(AppMeasurement appMeasurement) {
        Preconditions.checkNotNull((Object)appMeasurement);
        this.zzbop = appMeasurement;
        this.zzbor = new ConcurrentHashMap<String, Object>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    @KeepForSdk
    public static AnalyticsConnector getInstance(Context context) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzboq != null) return zzboq;
        Class<AnalyticsConnector> clazz = AnalyticsConnector.class;
        synchronized (AnalyticsConnector.class) {
            if (zzboq != null) return zzboq;
            zzboq = new AnalyticsConnectorImpl(AppMeasurement.getInstance((Context)context));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzboq;
        }
    }

    @KeepForSdk
    public static AnalyticsConnector getInstance() {
        return AnalyticsConnectorImpl.getInstance(FirebaseApp.getInstance());
    }

    @KeepForSdk
    public static AnalyticsConnector getInstance(FirebaseApp firebaseApp) {
        return (AnalyticsConnector)firebaseApp.get(AnalyticsConnector.class);
    }

    @WorkerThread
    @KeepForSdk
    public void logEvent(@NonNull String string, @NonNull String string2, Bundle bundle) {
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (!zzb.zzfb(string)) {
            return;
        }
        if (!zzb.zza(string2, bundle)) {
            return;
        }
        if (!zzb.zzb(string, string2, bundle)) {
            return;
        }
        this.zzbop.logEventInternal(string, string2, bundle);
    }

    @KeepForSdk
    public void setUserProperty(@NonNull String string, @NonNull String string2, Object object) {
        if (!zzb.zzfb(string)) {
            return;
        }
        if (!zzb.zzfc(string2)) {
            return;
        }
        if ((string2.equals("_ce1") || string2.equals("_ce2")) && !string.equals("fcm") && !string.equals("frc")) {
            return;
        }
        this.zzbop.setUserPropertyInternal(string, string2, object);
    }

    @WorkerThread
    @KeepForSdk
    public Map<String, Object> getUserProperties(boolean bl) {
        return this.zzbop.getUserProperties(bl);
    }

    @WorkerThread
    @KeepForSdk
    public AnalyticsConnector.AnalyticsConnectorHandle registerAnalyticsConnectorListener(@NonNull String string, AnalyticsConnector.AnalyticsConnectorListener analyticsConnectorListener) {
        Preconditions.checkNotNull((Object)analyticsConnectorListener);
        if (!zzb.zzfb(string)) {
            return null;
        }
        String string2 = string;
        AnalyticsConnectorImpl analyticsConnectorImpl = this;
        if (!string2.isEmpty() && analyticsConnectorImpl.zzbor.containsKey(string2) && analyticsConnectorImpl.zzbor.get(string2) != null) {
            return null;
        }
        return null;
    }

    @KeepForSdk
    public void setConditionalUserProperty(@NonNull AnalyticsConnector.ConditionalUserProperty conditionalUserProperty) {
        if (!zzb.zza(conditionalUserProperty)) {
            return;
        }
        this.zzbop.setConditionalUserProperty(zzb.zzb(conditionalUserProperty));
    }

    @KeepForSdk
    public void clearConditionalUserProperty(@NonNull @Size(min=1L, max=24L) String string, @Nullable String string2, @Nullable Bundle bundle) {
        if (string2 != null && !zzb.zza(string2, bundle)) {
            return;
        }
        this.zzbop.clearConditionalUserProperty(string, string2, bundle);
    }

    @WorkerThread
    @KeepForSdk
    public List<AnalyticsConnector.ConditionalUserProperty> getConditionalUserProperties(@NonNull String string, @Nullable @Size(min=1L, max=23L) String string2) {
        ArrayList<AnalyticsConnector.ConditionalUserProperty> arrayList = new ArrayList<AnalyticsConnector.ConditionalUserProperty>();
        Iterator iterator = this.zzbop.getConditionalUserProperties(string, string2).iterator();
        while (iterator.hasNext()) {
            AnalyticsConnector.ConditionalUserProperty conditionalUserProperty = zzb.zzd((AppMeasurement.ConditionalUserProperty)iterator.next());
            arrayList.add(conditionalUserProperty);
        }
        return arrayList;
    }

    @WorkerThread
    @KeepForSdk
    public int getMaxUserProperties(@NonNull @Size(min=1L) String string) {
        return this.zzbop.getMaxUserProperties(string);
    }
}

