/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Color;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.Process;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.util.zzt;
import com.google.firebase.iid.zzg;
import com.google.firebase.messaging.FirebaseMessagingService;
import java.util.Arrays;
import java.util.List;
import java.util.MissingFormatArgumentException;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONException;

class zza {
    static zza zzcly;
    private final Context mContext;
    private Bundle zzaDS;
    private final AtomicInteger zzclz = new AtomicInteger((int)SystemClock.elapsedRealtime());

    static synchronized zza zzcy(Context context) {
        if (zzcly == null) {
            zzcly = new zza(context);
        }
        return zzcly;
    }

    static boolean zzE(Bundle bundle) {
        return "1".equals(zza.zzf(bundle, "gcm.n.e")) || zza.zzf(bundle, "gcm.n.icon") != null;
    }

    private boolean zzabZ() {
        KeyguardManager keyguardManager = (KeyguardManager)this.mContext.getSystemService("keyguard");
        if (keyguardManager.inKeyguardRestrictedInputMode()) {
            return false;
        }
        if (!zzt.zzzn()) {
            SystemClock.sleep((long)10L);
        }
        int n = Process.myPid();
        ActivityManager activityManager = (ActivityManager)this.mContext.getSystemService("activity");
        List list = activityManager.getRunningAppProcesses();
        if (list != null) {
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (runningAppProcessInfo.pid != n) continue;
                return runningAppProcessInfo.importance == 100;
            }
        }
        return false;
    }

    static String zzf(Bundle bundle, String string) {
        String string2 = bundle.getString(string);
        if (string2 == null) {
            string2 = bundle.getString(string.replace("gcm.n.", "gcm.notification."));
        }
        return string2;
    }

    static String zzi(Bundle bundle, String string) {
        String string2 = String.valueOf(string);
        String string3 = String.valueOf("_loc_key");
        return zza.zzf(bundle, string3.length() != 0 ? string2.concat(string3) : new String(string2));
    }

    static Object[] zzj(Bundle bundle, String string) {
        String string2 = String.valueOf(string);
        String string3 = String.valueOf("_loc_args");
        String string4 = zza.zzf(bundle, string3.length() != 0 ? string2.concat(string3) : new String(string2));
        if (TextUtils.isEmpty((CharSequence)string4)) {
            return null;
        }
        try {
            JSONArray jSONArray = new JSONArray(string4);
            Object[] objectArray = new String[jSONArray.length()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = jSONArray.opt(i);
            }
            return objectArray;
        }
        catch (JSONException jSONException) {
            String string5 = String.valueOf(string);
            String string6 = String.valueOf("_loc_args");
            String string7 = String.valueOf(zza.zzeA(string6.length() != 0 ? string5.concat(string6) : new String(string5)));
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(41 + String.valueOf(string7).length() + String.valueOf(string4).length()).append("Malformed ").append(string7).append(": ").append(string4).append("  Default value will be used.").toString());
            return null;
        }
    }

    @Nullable
    static Uri zzT(@NonNull Bundle bundle) {
        String string = zza.zzf(bundle, "gcm.n.link_android");
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = zza.zzf(bundle, "gcm.n.link");
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return Uri.parse((String)string);
        }
        return null;
    }

    private zza(Context context) {
        this.mContext = context.getApplicationContext();
    }

    boolean zzG(Bundle bundle) {
        if ("1".equals(zza.zzf(bundle, "gcm.n.noui"))) {
            return true;
        }
        if (this.zzabZ()) {
            return false;
        }
        Notification notification = this.zzH(bundle);
        this.zza(zza.zzf(bundle, "gcm.n.tag"), notification);
        return true;
    }

    private Notification zzH(Bundle bundle) {
        String string = this.zzg(bundle, "gcm.n.title");
        String string2 = this.zzg(bundle, "gcm.n.body");
        int n = this.zzeB(zza.zzf(bundle, "gcm.n.icon"));
        Integer n2 = this.zzjD(zza.zzf(bundle, "gcm.n.color"));
        Uri uri = this.zzeC(zza.zzU(bundle));
        PendingIntent pendingIntent = this.zzI(bundle);
        PendingIntent pendingIntent2 = null;
        if (FirebaseMessagingService.zzX(bundle)) {
            pendingIntent = this.zza(bundle, pendingIntent);
            pendingIntent2 = this.zzW(bundle);
        }
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.mContext).setAutoCancel(true).setSmallIcon(n);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            builder.setContentTitle((CharSequence)string);
        } else {
            builder.setContentTitle(this.mContext.getApplicationInfo().loadLabel(this.mContext.getPackageManager()));
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            builder.setContentText((CharSequence)string2);
            builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)string2));
        }
        if (n2 != null) {
            builder.setColor(n2.intValue());
        }
        if (uri != null) {
            builder.setSound(uri);
        }
        if (pendingIntent != null) {
            builder.setContentIntent(pendingIntent);
        }
        if (pendingIntent2 != null) {
            builder.setDeleteIntent(pendingIntent2);
        }
        return builder.build();
    }

    private void zza(String string, Notification notification) {
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            Log.d((String)"FirebaseMessaging", (String)"Showing notification");
        }
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        if (TextUtils.isEmpty((CharSequence)string)) {
            long l = SystemClock.uptimeMillis();
            string = new StringBuilder(37).append("GCM-Notification:").append(l).toString();
        }
        notificationManager.notify(string, 0, notification);
    }

    private String zzg(Bundle bundle, String string) {
        String string2 = zza.zzf(bundle, string);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return string2;
        }
        String string3 = zza.zzi(bundle, string);
        if (TextUtils.isEmpty((CharSequence)string3)) {
            return null;
        }
        Resources resources = this.mContext.getResources();
        int n = resources.getIdentifier(string3, "string", this.mContext.getPackageName());
        if (n == 0) {
            String string4 = String.valueOf(string);
            String string5 = String.valueOf("_loc_key");
            String string6 = String.valueOf(zza.zzeA(string5.length() != 0 ? string4.concat(string5) : new String(string4)));
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(49 + String.valueOf(string6).length() + String.valueOf(string3).length()).append(string6).append(" resource not found: ").append(string3).append(" Default value will be used.").toString());
            return null;
        }
        Object[] objectArray = zza.zzj(bundle, string);
        if (objectArray == null) {
            return resources.getString(n);
        }
        try {
            return resources.getString(n, objectArray);
        }
        catch (MissingFormatArgumentException missingFormatArgumentException) {
            String string7 = String.valueOf(Arrays.toString(objectArray));
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(58 + String.valueOf(string3).length() + String.valueOf(string7).length()).append("Missing format argument for ").append(string3).append(": ").append(string7).append(" Default value will be used.").toString(), (Throwable)missingFormatArgumentException);
            return null;
        }
    }

    private static String zzeA(String string) {
        return string.substring("gcm.n.".length());
    }

    private int zzeB(String string) {
        int n;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            Resources resources = this.mContext.getResources();
            int n2 = resources.getIdentifier(string, "drawable", this.mContext.getPackageName());
            if (n2 != 0) {
                return n2;
            }
            n2 = resources.getIdentifier(string, "mipmap", this.mContext.getPackageName());
            if (n2 != 0) {
                return n2;
            }
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(61 + String.valueOf(string).length()).append("Icon resource ").append(string).append(" not found. Notification will use default icon.").toString());
        }
        if ((n = this.zzaca().getInt("com.google.firebase.messaging.default_notification_icon", 0)) == 0) {
            n = this.mContext.getApplicationInfo().icon;
        }
        if (n == 0) {
            n = 17301651;
        }
        return n;
    }

    private Integer zzjD(String string) {
        int n;
        if (Build.VERSION.SDK_INT < 21) {
            return null;
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            try {
                return Color.parseColor((String)string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(54 + String.valueOf(string).length()).append("Color ").append(string).append(" not valid. Notification will use default color.").toString());
            }
        }
        if ((n = this.zzaca().getInt("com.google.firebase.messaging.default_notification_color", 0)) != 0) {
            try {
                return ContextCompat.getColor((Context)this.mContext, (int)n);
            }
            catch (Resources.NotFoundException notFoundException) {
                Log.w((String)"FirebaseMessaging", (String)"Cannot find the color resource referenced in AndroidManifest.");
            }
        }
        return null;
    }

    static String zzU(Bundle bundle) {
        String string = zza.zzf(bundle, "gcm.n.sound2");
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = zza.zzf(bundle, "gcm.n.sound");
        }
        return string;
    }

    private Uri zzeC(String string) {
        Resources resources;
        int n;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (!"default".equals(string) && (n = (resources = this.mContext.getResources()).getIdentifier(string, "raw", this.mContext.getPackageName())) != 0) {
            String string2 = String.valueOf("android.resource://");
            String string3 = String.valueOf(this.mContext.getPackageName());
            return Uri.parse((String)new StringBuilder(5 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string).length()).append(string2).append(string3).append("/raw/").append(string).toString());
        }
        return RingtoneManager.getDefaultUri((int)2);
    }

    private PendingIntent zzI(Bundle bundle) {
        Intent intent = this.zzV(bundle);
        if (intent == null) {
            return null;
        }
        intent.addFlags(0x4000000);
        bundle = new Bundle(bundle);
        FirebaseMessagingService.zzD(bundle);
        intent.putExtras(bundle);
        for (String string : bundle.keySet()) {
            if (!string.startsWith("gcm.n.") && !string.startsWith("gcm.notification.")) continue;
            intent.removeExtra(string);
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)this.zzGP(), (Intent)intent, (int)0x40000000);
    }

    private Intent zzV(Bundle bundle) {
        String string = zza.zzf(bundle, "gcm.n.click_action");
        if (!TextUtils.isEmpty((CharSequence)string)) {
            Intent intent = new Intent(string);
            intent.setPackage(this.mContext.getPackageName());
            intent.setFlags(0x10000000);
            return intent;
        }
        Uri uri = zza.zzT(bundle);
        if (uri != null) {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setPackage(this.mContext.getPackageName());
            intent.setData(uri);
            return intent;
        }
        PackageManager packageManager = this.mContext.getPackageManager();
        Intent intent = packageManager.getLaunchIntentForPackage(this.mContext.getPackageName());
        if (intent == null) {
            Log.w((String)"FirebaseMessaging", (String)"No activity found to launch app");
        }
        return intent;
    }

    private PendingIntent zza(Bundle bundle, PendingIntent pendingIntent) {
        Intent intent = new Intent("com.google.firebase.messaging.NOTIFICATION_OPEN");
        this.zza(intent, bundle);
        intent.putExtra("pending_intent", (Parcelable)pendingIntent);
        return zzg.zzb((Context)this.mContext, (int)this.zzGP(), (Intent)intent, (int)0x40000000);
    }

    private PendingIntent zzW(Bundle bundle) {
        Intent intent = new Intent("com.google.firebase.messaging.NOTIFICATION_DISMISS");
        this.zza(intent, bundle);
        return zzg.zzb((Context)this.mContext, (int)this.zzGP(), (Intent)intent, (int)0x40000000);
    }

    private void zza(Intent intent, Bundle bundle) {
        for (String string : bundle.keySet()) {
            if (!string.startsWith("google.c.a.") && !string.equals("from")) continue;
            intent.putExtra(string, bundle.getString(string));
        }
    }

    private int zzGP() {
        return this.zzclz.incrementAndGet();
    }

    private Bundle zzaca() {
        if (this.zzaDS != null) {
            return this.zzaDS;
        }
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = this.mContext.getPackageManager().getApplicationInfo(this.mContext.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        if (applicationInfo != null && applicationInfo.metaData != null) {
            this.zzaDS = applicationInfo.metaData;
            return this.zzaDS;
        }
        return Bundle.EMPTY;
    }
}

