/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Color;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.Process;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.R;
import com.google.firebase.iid.zzq;
import com.google.firebase.messaging.FirebaseMessagingService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.MissingFormatArgumentException;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONException;

final class zza {
    private static zza zzngg;
    private final Context mContext;
    private Bundle zzfqo;
    private Method zzhqs;
    private Method zzhqt;
    private final AtomicInteger zzngh = new AtomicInteger((int)SystemClock.elapsedRealtime());

    static synchronized zza zzeq(Context context) {
        if (zzngg == null) {
            zzngg = new zza(context);
        }
        return zzngg;
    }

    static boolean zzad(Bundle bundle) {
        return "1".equals(zza.zze(bundle, "gcm.n.e")) || zza.zze(bundle, "gcm.n.icon") != null;
    }

    static String zze(Bundle bundle, String string2) {
        String string3 = bundle.getString(string2);
        if (string3 == null) {
            string3 = bundle.getString(string2.replace("gcm.n.", "gcm.notification."));
        }
        return string3;
    }

    static String zzh(Bundle bundle, String string2) {
        String string3 = String.valueOf(string2);
        String string4 = String.valueOf("_loc_key");
        return zza.zze(bundle, string4.length() != 0 ? string3.concat(string4) : new String(string3));
    }

    static Object[] zzi(Bundle bundle, String string2) {
        String string3 = String.valueOf(string2);
        String string4 = String.valueOf("_loc_args");
        String string5 = zza.zze(bundle, string4.length() != 0 ? string3.concat(string4) : new String(string3));
        if (TextUtils.isEmpty((CharSequence)string5)) {
            return null;
        }
        try {
            JSONArray jSONArray = new JSONArray(string5);
            Object[] objectArray = new String[jSONArray.length()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = jSONArray.opt(i);
            }
            return objectArray;
        }
        catch (JSONException jSONException) {
            String string6 = String.valueOf(string2);
            String string7 = String.valueOf("_loc_args");
            String string8 = string7.length() != 0 ? string6.concat(string7) : new String(string6);
            String string9 = string8.substring(6);
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(41 + String.valueOf(string9).length() + String.valueOf(string5).length()).append("Malformed ").append(string9).append(": ").append(string5).append("  Default value will be used.").toString());
            return null;
        }
    }

    @Nullable
    static Uri zzae(@NonNull Bundle bundle) {
        String string2 = zza.zze(bundle, "gcm.n.link_android");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = zza.zze(bundle, "gcm.n.link");
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return Uri.parse((String)string2);
        }
        return null;
    }

    private zza(Context context) {
        this.mContext = context.getApplicationContext();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    final boolean zzs(Bundle var1_1) {
        if ("1".equals(zza.zze(var1_1, "gcm.n.noui"))) {
            return true;
        }
        var3_2 = this;
        if (((KeyguardManager)var3_2.mContext.getSystemService("keyguard")).inKeyguardRestrictedInputMode()) ** GOTO lbl-1000
        if (!com.google.android.gms.common.util.zzq.zzalj()) {
            SystemClock.sleep((long)10L);
        }
        var5_3 = Process.myPid();
        var7_5 = ((ActivityManager)var3_2.mContext.getSystemService("activity")).getRunningAppProcesses();
        if (var7_5 != null) {
            for (ActivityManager.RunningAppProcessInfo var9_9 : var7_5) {
                if (var9_9.pid != var5_3) continue;
                v0 = var9_9.importance == 100;
                break;
            }
        } else lbl-1000:
        // 3 sources

        {
            v0 = false;
        }
        if (v0) {
            return false;
        }
        var3_2 = this;
        var4_10 /* !! */  = var1_1;
        var5_4 /* !! */  = var3_2.zzj(var4_10 /* !! */ , "gcm.n.title");
        if (TextUtils.isEmpty((CharSequence)var5_4 /* !! */ )) {
            var5_4 /* !! */  = var3_2.mContext.getApplicationInfo().loadLabel(var3_2.mContext.getPackageManager());
        }
        var6_11 = var3_2.zzj(var4_10 /* !! */ , "gcm.n.body");
        var14_12 = zza.zze(var4_10 /* !! */ , "gcm.n.icon");
        var13_13 = var3_2;
        if (TextUtils.isEmpty((CharSequence)var14_12)) ** GOTO lbl37
        var15_14 /* !! */  = var13_13.mContext.getResources();
        var16_16 = var15_14 /* !! */ .getIdentifier(var14_12, "drawable", var13_13.mContext.getPackageName());
        if (var16_16 != 0) {
            v1 = var16_16;
        } else {
            var16_16 = var15_14 /* !! */ .getIdentifier(var14_12, "mipmap", var13_13.mContext.getPackageName());
            if (var16_16 != 0) {
                v1 = var16_16;
            } else {
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(61 + String.valueOf(var14_12).length()).append("Icon resource ").append(var14_12).append(" not found. Notification will use default icon.").toString());
lbl37:
                // 2 sources

                if ((var15_15 = var13_13.zzash().getInt("com.google.firebase.messaging.default_notification_icon", 0)) == 0) {
                    var15_15 = var13_13.mContext.getApplicationInfo().icon;
                }
                if (var15_15 == 0) {
                    var15_15 = 17301651;
                }
                v1 = var15_15;
            }
        }
        var7_6 = v1;
        var8_8 = var3_2.zzri(zza.zze(var4_10 /* !! */ , "gcm.n.color"));
        var14_12 = zza.zzaf(var4_10 /* !! */ );
        var13_13 = var3_2;
        if (TextUtils.isEmpty((CharSequence)var14_12)) {
            v2 = null;
        } else if (!"default".equals(var14_12) && var13_13.mContext.getResources().getIdentifier(var14_12, "raw", var13_13.mContext.getPackageName()) != 0) {
            var17_19 = "android.resource://";
            var18_20 = var13_13.mContext.getPackageName();
            v2 = Uri.parse((String)new StringBuilder(5 + String.valueOf(var17_19).length() + String.valueOf(var18_20).length() + String.valueOf(var14_12).length()).append((String)var17_19).append(var18_20).append("/raw/").append(var14_12).toString());
        } else {
            v2 = RingtoneManager.getDefaultUri((int)2);
        }
        var9_9 = v2;
        var10_21 = var3_2.zzt(var4_10 /* !! */ );
        var11_22 = null;
        if (FirebaseMessagingService.zzag(var4_10 /* !! */ )) {
            var15_14 /* !! */  = var10_21;
            var14_12 = var4_10 /* !! */ ;
            var13_13 = var3_2;
            var16_17 = new Intent("com.google.firebase.messaging.NOTIFICATION_OPEN");
            zza.zza(var16_17, (Bundle)var14_12);
            var16_17.putExtra("pending_intent", (Parcelable)var15_14 /* !! */ );
            var10_21 = zzq.zzb((Context)var13_13.mContext, (int)var13_13.zzngh.incrementAndGet(), (Intent)var16_17, (int)0x40000000);
            var14_12 = var4_10 /* !! */ ;
            var13_13 = var3_2;
            var15_14 /* !! */  = new Intent("com.google.firebase.messaging.NOTIFICATION_DISMISS");
            zza.zza((Intent)var15_14 /* !! */ , (Bundle)var14_12);
            var11_22 = zzq.zzb((Context)var13_13.mContext, (int)var13_13.zzngh.incrementAndGet(), (Intent)var15_14 /* !! */ , (int)0x40000000);
        }
        if (com.google.android.gms.common.util.zzq.isAtLeastO() && var3_2.mContext.getApplicationInfo().targetSdkVersion > 25) {
            var12_23 = var3_2.zzrj(zza.zze(var4_10 /* !! */ , "gcm.n.android_channel_id"));
            v3 = var3_2.zza(var5_4 /* !! */ , var6_11, var7_6, var8_8, (Uri)var9_9, var10_21, var11_22, var12_23);
        } else {
            var20_24 = var11_22;
            var19_25 = var10_21;
            var18_20 = var9_9;
            var17_19 = var8_8;
            var16_18 = var7_6;
            var15_14 /* !! */  = var6_11;
            var14_12 = var5_4 /* !! */ ;
            var13_13 = var3_2;
            var21_26 = new NotificationCompat.Builder(var13_13.mContext).setAutoCancel(true).setSmallIcon(var16_18);
            if (!TextUtils.isEmpty((CharSequence)var14_12)) {
                var21_26.setContentTitle((CharSequence)var14_12);
            }
            if (!TextUtils.isEmpty((CharSequence)var15_14 /* !! */ )) {
                var21_26.setContentText((CharSequence)var15_14 /* !! */ );
                var21_26.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)var15_14 /* !! */ ));
            }
            if (var17_19 != null) {
                var21_26.setColor(var17_19.intValue());
            }
            if (var18_20 != null) {
                var21_26.setSound((Uri)var18_20);
            }
            if (var19_25 != null) {
                var21_26.setContentIntent(var19_25);
            }
            if (var20_24 != null) {
                var21_26.setDeleteIntent(var20_24);
            }
            v3 = var21_26.build();
        }
        var2_27 = v3;
        var5_4 /* !! */  = var2_27;
        var4_10 /* !! */  = zza.zze(var1_1, "gcm.n.tag");
        var3_2 = this;
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            Log.d((String)"FirebaseMessaging", (String)"Showing notification");
        }
        var6_11 = (NotificationManager)var3_2.mContext.getSystemService("notification");
        if (TextUtils.isEmpty((CharSequence)var4_10 /* !! */ )) {
            var7_7 = SystemClock.uptimeMillis();
            var4_10 /* !! */  = new StringBuilder(37).append("FCM-Notification:").append(var7_7).toString();
        }
        var6_11.notify((String)var4_10 /* !! */ , 0, (Notification)var5_4 /* !! */ );
        return true;
    }

    @TargetApi(value=26)
    private final Notification zza(CharSequence charSequence, String string2, int n, Integer n2, Uri uri, PendingIntent pendingIntent, PendingIntent pendingIntent2, String string3) {
        Notification.Builder builder = new Notification.Builder(this.mContext).setAutoCancel(true).setSmallIcon(n);
        if (!TextUtils.isEmpty((CharSequence)charSequence)) {
            builder.setContentTitle(charSequence);
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            builder.setContentText((CharSequence)string2);
            builder.setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)string2));
        }
        if (n2 != null) {
            builder.setColor(n2.intValue());
        }
        if (uri != null) {
            builder.setSound(uri);
        }
        if (pendingIntent != null) {
            builder.setContentIntent(pendingIntent);
        }
        if (pendingIntent2 != null) {
            builder.setDeleteIntent(pendingIntent2);
        }
        if (string3 != null) {
            if (this.zzhqs == null) {
                this.zzhqs = zza.zzhq("setChannelId");
            }
            if (this.zzhqs == null) {
                this.zzhqs = zza.zzhq("setChannel");
            }
            if (this.zzhqs == null) {
                Log.e((String)"FirebaseMessaging", (String)"Error while setting the notification channel");
            } else {
                try {
                    this.zzhqs.invoke((Object)builder, string3);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Log.e((String)"FirebaseMessaging", (String)"Error while setting the notification channel", (Throwable)illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Log.e((String)"FirebaseMessaging", (String)"Error while setting the notification channel", (Throwable)invocationTargetException);
                }
                catch (SecurityException securityException) {
                    Log.e((String)"FirebaseMessaging", (String)"Error while setting the notification channel", (Throwable)securityException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Log.e((String)"FirebaseMessaging", (String)"Error while setting the notification channel", (Throwable)illegalArgumentException);
                }
            }
        }
        return builder.build();
    }

    @TargetApi(value=26)
    private static Method zzhq(String string2) {
        try {
            return Notification.Builder.class.getMethod(string2, String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {}
        return null;
    }

    private final String zzj(Bundle bundle, String string2) {
        String string3 = zza.zze(bundle, string2);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            return string3;
        }
        String string4 = zza.zzh(bundle, string2);
        if (TextUtils.isEmpty((CharSequence)string4)) {
            return null;
        }
        Resources resources = this.mContext.getResources();
        int n = resources.getIdentifier(string4, "string", this.mContext.getPackageName());
        if (n == 0) {
            String string5 = String.valueOf(string2);
            String string6 = String.valueOf("_loc_key");
            String string7 = string6.length() != 0 ? string5.concat(string6) : new String(string5);
            String string8 = string7.substring(6);
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(49 + String.valueOf(string8).length() + String.valueOf(string4).length()).append(string8).append(" resource not found: ").append(string4).append(" Default value will be used.").toString());
            return null;
        }
        Object[] objectArray = zza.zzi(bundle, string2);
        if (objectArray == null) {
            return resources.getString(n);
        }
        try {
            return resources.getString(n, objectArray);
        }
        catch (MissingFormatArgumentException missingFormatArgumentException) {
            String string9 = Arrays.toString(objectArray);
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(58 + String.valueOf(string4).length() + String.valueOf(string9).length()).append("Missing format argument for ").append(string4).append(": ").append(string9).append(" Default value will be used.").toString(), (Throwable)missingFormatArgumentException);
            return null;
        }
    }

    private final Integer zzri(String string2) {
        int n;
        if (Build.VERSION.SDK_INT < 21) {
            return null;
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                return Color.parseColor((String)string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(54 + String.valueOf(string2).length()).append("Color ").append(string2).append(" not valid. Notification will use default color.").toString());
            }
        }
        if ((n = this.zzash().getInt("com.google.firebase.messaging.default_notification_color", 0)) != 0) {
            try {
                return ContextCompat.getColor((Context)this.mContext, (int)n);
            }
            catch (Resources.NotFoundException notFoundException) {
                Log.w((String)"FirebaseMessaging", (String)"Cannot find the color resource referenced in AndroidManifest.");
            }
        }
        return null;
    }

    @TargetApi(value=26)
    private final String zzrj(String string2) {
        if (!com.google.android.gms.common.util.zzq.isAtLeastO()) {
            return null;
        }
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService(NotificationManager.class);
        try {
            String string3;
            if (this.zzhqt == null) {
                this.zzhqt = notificationManager.getClass().getMethod("getNotificationChannel", String.class);
            }
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                if (this.zzhqt.invoke((Object)notificationManager, string2) != null) {
                    return string2;
                }
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(122 + String.valueOf(string2).length()).append("Notification Channel requested (").append(string2).append(") has not been created by the app. Manifest configuration, or default, value will be used.").toString());
            }
            if (!TextUtils.isEmpty((CharSequence)(string3 = this.zzash().getString("com.google.firebase.messaging.default_notification_channel_id")))) {
                if (this.zzhqt.invoke((Object)notificationManager, string3) != null) {
                    return string3;
                }
                Log.w((String)"FirebaseMessaging", (String)"Notification Channel set in AndroidManifest.xml has not been created by the app. Default value will be used.");
            } else {
                Log.w((String)"FirebaseMessaging", (String)"Missing Default Notification Channel metadata in AndroidManifest. Default value will be used.");
            }
            if (this.zzhqt.invoke((Object)notificationManager, "fcm_fallback_notification_channel") == null) {
                Class<?> clazz = Class.forName("android.app.NotificationChannel");
                Object obj = clazz.getConstructor(String.class, CharSequence.class, Integer.TYPE).newInstance("fcm_fallback_notification_channel", this.mContext.getString(R.string.fcm_fallback_notification_channel_label), 3);
                notificationManager.getClass().getMethod("createNotificationChannel", clazz).invoke((Object)notificationManager, obj);
            }
            return "fcm_fallback_notification_channel";
        }
        catch (InstantiationException instantiationException) {
            Log.e((String)"FirebaseMessaging", (String)"Error while setting the notification channel", (Throwable)instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.e((String)"FirebaseMessaging", (String)"Error while setting the notification channel", (Throwable)invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log.e((String)"FirebaseMessaging", (String)"Error while setting the notification channel", (Throwable)noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.e((String)"FirebaseMessaging", (String)"Error while setting the notification channel", (Throwable)illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.e((String)"FirebaseMessaging", (String)"Error while setting the notification channel", (Throwable)classNotFoundException);
        }
        catch (SecurityException securityException) {
            Log.e((String)"FirebaseMessaging", (String)"Error while setting the notification channel", (Throwable)securityException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e((String)"FirebaseMessaging", (String)"Error while setting the notification channel", (Throwable)illegalArgumentException);
        }
        catch (LinkageError linkageError) {
            Log.e((String)"FirebaseMessaging", (String)"Error while setting the notification channel", (Throwable)linkageError);
        }
        return null;
    }

    static String zzaf(Bundle bundle) {
        String string2 = zza.zze(bundle, "gcm.n.sound2");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = zza.zze(bundle, "gcm.n.sound");
        }
        return string2;
    }

    private final PendingIntent zzt(Bundle bundle) {
        Uri uri;
        Uri uri2;
        Uri uri3;
        Bundle bundle2 = bundle;
        zza zza2 = this;
        String string2 = zza.zze(bundle2, "gcm.n.click_action");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            uri3 = new Intent(string2);
            uri3.setPackage(zza2.mContext.getPackageName());
            uri3.setFlags(0x10000000);
            uri2 = uri3;
        } else {
            uri3 = zza.zzae(bundle2);
            if (uri3 != null) {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setPackage(zza2.mContext.getPackageName());
                intent.setData(uri3);
                uri2 = intent;
            } else {
                Intent intent = zza2.mContext.getPackageManager().getLaunchIntentForPackage(zza2.mContext.getPackageName());
                if (intent == null) {
                    Log.w((String)"FirebaseMessaging", (String)"No activity found to launch app");
                }
                uri2 = uri = intent;
            }
        }
        if (uri2 == null) {
            return null;
        }
        uri.addFlags(0x4000000);
        bundle = new Bundle(bundle);
        FirebaseMessagingService.zzq(bundle);
        uri.putExtras(bundle);
        for (String string3 : bundle.keySet()) {
            if (!string3.startsWith("gcm.n.") && !string3.startsWith("gcm.notification.")) continue;
            uri.removeExtra(string3);
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)this.zzngh.incrementAndGet(), (Intent)uri, (int)0x40000000);
    }

    private static void zza(Intent intent, Bundle bundle) {
        for (String string2 : bundle.keySet()) {
            if (!string2.startsWith("google.c.a.") && !string2.equals("from")) continue;
            intent.putExtra(string2, bundle.getString(string2));
        }
    }

    private final Bundle zzash() {
        if (this.zzfqo != null) {
            return this.zzfqo;
        }
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = this.mContext.getPackageManager().getApplicationInfo(this.mContext.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        if (applicationInfo != null && applicationInfo.metaData != null) {
            this.zzfqo = applicationInfo.metaData;
            return this.zzfqo;
        }
        return Bundle.EMPTY;
    }
}

