/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.firebase.messaging.zza;
import com.google.firebase.messaging.zzf;
import com.google.firebase.messaging.zzg;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="RemoteMessageCreator")
public final class RemoteMessage
extends AbstractSafeParcelable {
    public static final int PRIORITY_UNKNOWN = 0;
    public static final int PRIORITY_HIGH = 1;
    public static final int PRIORITY_NORMAL = 2;
    public static final Parcelable.Creator<RemoteMessage> CREATOR = new zzg();
    @SafeParcelable.Field(id=2)
    Bundle zzeh;
    private Map<String, String> zzei;
    private Notification zzej;

    @SafeParcelable.Constructor
    public RemoteMessage(@SafeParcelable.Param(id=2) Bundle bundle) {
        this.zzeh = bundle;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        RemoteMessage remoteMessage = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeBundle((Parcel)parcel2, (int)2, (Bundle)remoteMessage.zzeh, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @Nullable
    public final String getFrom() {
        return this.zzeh.getString("from");
    }

    @Nullable
    public final String getTo() {
        return this.zzeh.getString("google.to");
    }

    public final Map<String, String> getData() {
        if (this.zzei == null) {
            Bundle bundle = this.zzeh;
            ArrayMap arrayMap = new ArrayMap();
            for (String string : bundle.keySet()) {
                Object object = bundle.get(string);
                if (!(object instanceof String)) continue;
                String string2 = (String)object;
                if (string.startsWith("google.") || string.startsWith("gcm.") || string.equals("from") || string.equals("message_type") || string.equals("collapse_key")) continue;
                arrayMap.put((Object)string, (Object)string2);
            }
            this.zzei = arrayMap;
        }
        return this.zzei;
    }

    @Nullable
    public final String getCollapseKey() {
        return this.zzeh.getString("collapse_key");
    }

    @Nullable
    public final String getMessageId() {
        String string = this.zzeh.getString("google.message_id");
        if (string == null) {
            string = this.zzeh.getString("message_id");
        }
        return string;
    }

    @Nullable
    public final String getMessageType() {
        return this.zzeh.getString("message_type");
    }

    public final long getSentTime() {
        Object object = this.zzeh.get("google.sent_time");
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(19 + String.valueOf(string).length()).append("Invalid sent time: ").append(string).toString());
            }
        }
        return 0L;
    }

    public final int getTtl() {
        Object object = this.zzeh.get("google.ttl");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(13 + String.valueOf(string).length()).append("Invalid TTL: ").append(string).toString());
            }
        }
        return 0;
    }

    public final int getOriginalPriority() {
        String string = this.zzeh.getString("google.original_priority");
        if (string == null) {
            string = this.zzeh.getString("google.priority");
        }
        return RemoteMessage.zzp(string);
    }

    public final int getPriority() {
        String string = this.zzeh.getString("google.delivered_priority");
        if (string == null) {
            if ("1".equals(this.zzeh.getString("google.priority_reduced"))) {
                return 2;
            }
            string = this.zzeh.getString("google.priority");
        }
        return RemoteMessage.zzp(string);
    }

    private static int zzp(String string) {
        if ("high".equals(string)) {
            return 1;
        }
        if ("normal".equals(string)) {
            return 2;
        }
        return 0;
    }

    @Nullable
    public final Notification getNotification() {
        if (this.zzej == null && zza.zzh(this.zzeh)) {
            this.zzej = new Notification(this.zzeh, null);
        }
        return this.zzej;
    }

    @KeepForSdk
    public final Intent toIntent() {
        Intent intent = new Intent();
        intent.putExtras(this.zzeh);
        return intent;
    }

    public static class Notification {
        private final String zzek;
        private final String zzel;
        private final String[] zzem;
        private final String zzen;
        private final String zzeo;
        private final String[] zzep;
        private final String zzeq;
        private final String zzer;
        private final String zzes;
        private final String tag;
        private final String zzet;
        private final String zzeu;
        private final String zzev;
        private final Uri zzew;

        private Notification(Bundle bundle) {
            this.zzek = zza.zza(bundle, "gcm.n.title");
            this.zzel = zza.zzd(bundle, "gcm.n.title");
            this.zzem = Notification.zzf(bundle, "gcm.n.title");
            this.zzen = zza.zza(bundle, "gcm.n.body");
            this.zzeo = zza.zzd(bundle, "gcm.n.body");
            this.zzep = Notification.zzf(bundle, "gcm.n.body");
            this.zzeq = zza.zza(bundle, "gcm.n.icon");
            this.zzes = zza.zzi(bundle);
            this.tag = zza.zza(bundle, "gcm.n.tag");
            this.zzet = zza.zza(bundle, "gcm.n.color");
            this.zzeu = zza.zza(bundle, "gcm.n.click_action");
            this.zzev = zza.zza(bundle, "gcm.n.android_channel_id");
            this.zzew = zza.zzj(bundle);
            this.zzer = zza.zza(bundle, "gcm.n.image");
        }

        private static String[] zzf(Bundle bundle, String string) {
            Object[] objectArray = zza.zzb(bundle, string);
            if (objectArray == null) {
                return null;
            }
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = String.valueOf(objectArray[i]);
            }
            return stringArray;
        }

        @Nullable
        public String getTitle() {
            return this.zzek;
        }

        @Nullable
        public String getTitleLocalizationKey() {
            return this.zzel;
        }

        @Nullable
        public String[] getTitleLocalizationArgs() {
            return this.zzem;
        }

        @Nullable
        public String getBody() {
            return this.zzen;
        }

        @Nullable
        public String getBodyLocalizationKey() {
            return this.zzeo;
        }

        @Nullable
        public String[] getBodyLocalizationArgs() {
            return this.zzep;
        }

        @Nullable
        public String getIcon() {
            return this.zzeq;
        }

        @Nullable
        public Uri getImageUrl() {
            if (this.zzer != null) {
                return Uri.parse((String)this.zzer);
            }
            return null;
        }

        @Nullable
        public String getSound() {
            return this.zzes;
        }

        @Nullable
        public String getTag() {
            return this.tag;
        }

        @Nullable
        public String getColor() {
            return this.zzet;
        }

        @Nullable
        public String getClickAction() {
            return this.zzeu;
        }

        @Nullable
        public String getChannelId() {
            return this.zzev;
        }

        @Nullable
        public Uri getLink() {
            return this.zzew;
        }

        /* synthetic */ Notification(Bundle bundle, zzf zzf2) {
            this(bundle);
        }
    }

    public static class Builder {
        private final Bundle zzeh = new Bundle();
        private final Map<String, String> zzei = new ArrayMap();

        public Builder(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                String string2 = String.valueOf(string);
                throw new IllegalArgumentException(string2.length() != 0 ? "Invalid to: ".concat(string2) : new String("Invalid to: "));
            }
            this.zzeh.putString("google.to", string);
        }

        public RemoteMessage build() {
            Bundle bundle = new Bundle();
            for (Map.Entry<String, String> entry : this.zzei.entrySet()) {
                bundle.putString(entry.getKey(), entry.getValue());
            }
            bundle.putAll(this.zzeh);
            this.zzeh.remove("from");
            return new RemoteMessage(bundle);
        }

        public Builder addData(String string, String string2) {
            this.zzei.put(string, string2);
            return this;
        }

        public Builder setData(Map<String, String> map) {
            this.zzei.clear();
            this.zzei.putAll(map);
            return this;
        }

        public Builder clearData() {
            this.zzei.clear();
            return this;
        }

        public Builder setMessageId(String string) {
            this.zzeh.putString("google.message_id", string);
            return this;
        }

        public Builder setMessageType(String string) {
            this.zzeh.putString("message_type", string);
            return this;
        }

        public Builder setTtl(@IntRange(from=0L, to=86400L) int n) {
            this.zzeh.putString("google.ttl", String.valueOf(n));
            return this;
        }

        public Builder setCollapseKey(String string) {
            this.zzeh.putString("collapse_key", string);
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MessagePriority {
    }
}

