/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.firebase.messaging.zzb;
import com.google.firebase.messaging.zzf;
import com.google.firebase.messaging.zzg;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="RemoteMessageCreator")
public final class RemoteMessage
extends AbstractSafeParcelable {
    public static final int PRIORITY_UNKNOWN = 0;
    public static final int PRIORITY_HIGH = 1;
    public static final int PRIORITY_NORMAL = 2;
    public static final Parcelable.Creator<RemoteMessage> CREATOR = new zzg();
    @SafeParcelable.Field(id=2)
    Bundle zzee;
    private Map<String, String> zzef;
    private Notification zzeg;

    @SafeParcelable.Constructor
    public RemoteMessage(@SafeParcelable.Param(id=2) Bundle bundle) {
        this.zzee = bundle;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        RemoteMessage remoteMessage = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeBundle((Parcel)parcel2, (int)2, (Bundle)remoteMessage.zzee, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @Nullable
    public final String getFrom() {
        return this.zzee.getString("from");
    }

    @Nullable
    public final String getTo() {
        return this.zzee.getString("google.to");
    }

    public final Map<String, String> getData() {
        if (this.zzef == null) {
            Bundle bundle = this.zzee;
            ArrayMap arrayMap = new ArrayMap();
            for (String string : bundle.keySet()) {
                Object object = bundle.get(string);
                if (!(object instanceof String)) continue;
                String string2 = (String)object;
                if (string.startsWith("google.") || string.startsWith("gcm.") || string.equals("from") || string.equals("message_type") || string.equals("collapse_key")) continue;
                arrayMap.put((Object)string, (Object)string2);
            }
            this.zzef = arrayMap;
        }
        return this.zzef;
    }

    @Nullable
    public final String getCollapseKey() {
        return this.zzee.getString("collapse_key");
    }

    @Nullable
    public final String getMessageId() {
        String string = this.zzee.getString("google.message_id");
        if (string == null) {
            string = this.zzee.getString("message_id");
        }
        return string;
    }

    @Nullable
    public final String getMessageType() {
        return this.zzee.getString("message_type");
    }

    public final long getSentTime() {
        Object object = this.zzee.get("google.sent_time");
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(19 + String.valueOf(string).length()).append("Invalid sent time: ").append(string).toString());
            }
        }
        return 0L;
    }

    public final int getTtl() {
        Object object = this.zzee.get("google.ttl");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(13 + String.valueOf(string).length()).append("Invalid TTL: ").append(string).toString());
            }
        }
        return 0;
    }

    public final int getOriginalPriority() {
        String string = this.zzee.getString("google.original_priority");
        if (string == null) {
            string = this.zzee.getString("google.priority");
        }
        return RemoteMessage.zzp(string);
    }

    public final int getPriority() {
        String string = this.zzee.getString("google.delivered_priority");
        if (string == null) {
            if ("1".equals(this.zzee.getString("google.priority_reduced"))) {
                return 2;
            }
            string = this.zzee.getString("google.priority");
        }
        return RemoteMessage.zzp(string);
    }

    private static int zzp(String string) {
        if ("high".equals(string)) {
            return 1;
        }
        if ("normal".equals(string)) {
            return 2;
        }
        return 0;
    }

    @Nullable
    public final Notification getNotification() {
        if (this.zzeg == null && zzb.zzh(this.zzee)) {
            this.zzeg = new Notification(this.zzee, null);
        }
        return this.zzeg;
    }

    @KeepForSdk
    public final Intent toIntent() {
        Intent intent = new Intent();
        intent.putExtras(this.zzee);
        return intent;
    }

    public static class Notification {
        private final String zzeh;
        private final String zzei;
        private final String[] zzej;
        private final String zzek;
        private final String zzel;
        private final String[] zzem;
        private final String zzen;
        private final String zzeo;
        private final String zzep;
        private final String tag;
        private final String zzeq;
        private final String zzer;
        private final String zzes;
        private final Uri zzet;

        private Notification(Bundle bundle) {
            this.zzeh = zzb.zza(bundle, "gcm.n.title");
            this.zzei = zzb.zzd(bundle, "gcm.n.title");
            this.zzej = Notification.zzf(bundle, "gcm.n.title");
            this.zzek = zzb.zza(bundle, "gcm.n.body");
            this.zzel = zzb.zzd(bundle, "gcm.n.body");
            this.zzem = Notification.zzf(bundle, "gcm.n.body");
            this.zzen = zzb.zza(bundle, "gcm.n.icon");
            this.zzep = zzb.zzi(bundle);
            this.tag = zzb.zza(bundle, "gcm.n.tag");
            this.zzeq = zzb.zza(bundle, "gcm.n.color");
            this.zzer = zzb.zza(bundle, "gcm.n.click_action");
            this.zzes = zzb.zza(bundle, "gcm.n.android_channel_id");
            this.zzet = zzb.zzj(bundle);
            this.zzeo = zzb.zza(bundle, "gcm.n.image");
        }

        private static String[] zzf(Bundle bundle, String string) {
            Object[] objectArray = zzb.zzb(bundle, string);
            if (objectArray == null) {
                return null;
            }
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = String.valueOf(objectArray[i]);
            }
            return stringArray;
        }

        @Nullable
        public String getTitle() {
            return this.zzeh;
        }

        @Nullable
        public String getTitleLocalizationKey() {
            return this.zzei;
        }

        @Nullable
        public String[] getTitleLocalizationArgs() {
            return this.zzej;
        }

        @Nullable
        public String getBody() {
            return this.zzek;
        }

        @Nullable
        public String getBodyLocalizationKey() {
            return this.zzel;
        }

        @Nullable
        public String[] getBodyLocalizationArgs() {
            return this.zzem;
        }

        @Nullable
        public String getIcon() {
            return this.zzen;
        }

        @Nullable
        public Uri getImageUrl() {
            if (this.zzeo != null) {
                return Uri.parse((String)this.zzeo);
            }
            return null;
        }

        @Nullable
        public String getSound() {
            return this.zzep;
        }

        @Nullable
        public String getTag() {
            return this.tag;
        }

        @Nullable
        public String getColor() {
            return this.zzeq;
        }

        @Nullable
        public String getClickAction() {
            return this.zzer;
        }

        @Nullable
        public String getChannelId() {
            return this.zzes;
        }

        @Nullable
        public Uri getLink() {
            return this.zzet;
        }

        /* synthetic */ Notification(Bundle bundle, zzf zzf2) {
            this(bundle);
        }
    }

    public static class Builder {
        private final Bundle zzee = new Bundle();
        private final Map<String, String> zzef = new ArrayMap();

        public Builder(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                String string2 = String.valueOf(string);
                throw new IllegalArgumentException(string2.length() != 0 ? "Invalid to: ".concat(string2) : new String("Invalid to: "));
            }
            this.zzee.putString("google.to", string);
        }

        public RemoteMessage build() {
            Bundle bundle = new Bundle();
            for (Map.Entry<String, String> entry : this.zzef.entrySet()) {
                bundle.putString(entry.getKey(), entry.getValue());
            }
            bundle.putAll(this.zzee);
            this.zzee.remove("from");
            return new RemoteMessage(bundle);
        }

        public Builder addData(String string, String string2) {
            this.zzef.put(string, string2);
            return this;
        }

        public Builder setData(Map<String, String> map) {
            this.zzef.clear();
            this.zzef.putAll(map);
            return this;
        }

        public Builder clearData() {
            this.zzef.clear();
            return this;
        }

        public Builder setMessageId(String string) {
            this.zzee.putString("google.message_id", string);
            return this;
        }

        public Builder setMessageType(String string) {
            this.zzee.putString("message_type", string);
            return this;
        }

        public Builder setTtl(@IntRange(from=0L, to=86400L) int n) {
            this.zzee.putString("google.ttl", String.valueOf(n));
            return this;
        }

        public Builder setCollapseKey(String string) {
            this.zzee.putString("collapse_key", string);
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MessagePriority {
    }
}

