/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.datatransport.TransportFactory;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.messaging.RemoteMessage;
import com.google.firebase.messaging.zzo;
import java.util.regex.Pattern;

public class FirebaseMessaging {
    public static final String INSTANCE_ID_SCOPE = "FCM";
    private static final Pattern zzb = Pattern.compile("[a-zA-Z0-9-_.~%]{1,900}");
    private final Context zzc;
    private final FirebaseInstanceId zzd;
    @Nullable
    @SuppressLint(value={"FirebaseUnknownNullness"})
    @VisibleForTesting
    static TransportFactory zza;

    @NonNull
    public static synchronized FirebaseMessaging getInstance() {
        return FirebaseMessaging.getInstance(FirebaseApp.getInstance());
    }

    @Keep
    @NonNull
    static synchronized FirebaseMessaging getInstance(@NonNull FirebaseApp firebaseApp) {
        return (FirebaseMessaging)firebaseApp.get(FirebaseMessaging.class);
    }

    FirebaseMessaging(FirebaseApp firebaseApp, FirebaseInstanceId firebaseInstanceId, TransportFactory transportFactory) {
        this.zzc = firebaseApp.getApplicationContext();
        this.zzd = firebaseInstanceId;
        zza = transportFactory;
    }

    public boolean isAutoInitEnabled() {
        return this.zzd.zzh();
    }

    public void setAutoInitEnabled(boolean bl) {
        this.zzd.zzb(bl);
    }

    @NonNull
    public boolean deliveryMetricsExportToBigQueryEnabled() {
        return zzo.zza();
    }

    public void setDeliveryMetricsExportToBigQuery(boolean bl) {
        zzo.zza(bl);
    }

    @NonNull
    public Task<Void> subscribeToTopic(@NonNull String string) {
        if (string != null && string.startsWith("/topics/")) {
            Log.w((String)"FirebaseMessaging", (String)"Format /topics/topic-name is deprecated. Only 'topic-name' should be used in subscribeToTopic.");
            string = string.substring(8);
        }
        if (string == null || !zzb.matcher(string).matches()) {
            String string2 = string;
            throw new IllegalArgumentException(new StringBuilder(78 + String.valueOf(string2).length()).append("Invalid topic name: ").append(string2).append(" does not match the allowed format [a-zA-Z0-9-_.~%]{1,900}").toString());
        }
        String string3 = String.valueOf("S!");
        String string4 = String.valueOf(string);
        return this.zzd.zza(string4.length() != 0 ? string3.concat(string4) : new String(string3));
    }

    @NonNull
    public Task<Void> unsubscribeFromTopic(@NonNull String string) {
        if (string != null && string.startsWith("/topics/")) {
            Log.w((String)"FirebaseMessaging", (String)"Format /topics/topic-name is deprecated. Only 'topic-name' should be used in unsubscribeFromTopic.");
            string = string.substring(8);
        }
        if (string == null || !zzb.matcher(string).matches()) {
            String string2 = string;
            throw new IllegalArgumentException(new StringBuilder(78 + String.valueOf(string2).length()).append("Invalid topic name: ").append(string2).append(" does not match the allowed format [a-zA-Z0-9-_.~%]{1,900}").toString());
        }
        String string3 = String.valueOf("U!");
        String string4 = String.valueOf(string);
        return this.zzd.zza(string4.length() != 0 ? string3.concat(string4) : new String(string3));
    }

    public void send(@NonNull RemoteMessage remoteMessage) {
        if (TextUtils.isEmpty((CharSequence)remoteMessage.getTo())) {
            throw new IllegalArgumentException("Missing 'to'");
        }
        Intent intent = new Intent("com.google.android.gcm.intent.SEND");
        Intent intent2 = new Intent();
        intent2.setPackage("com.google.example.invalidpackage");
        intent.putExtra("app", (Parcelable)PendingIntent.getBroadcast((Context)this.zzc, (int)0, (Intent)intent2, (int)0));
        intent.setPackage("com.google.android.gms");
        Intent intent3 = intent;
        RemoteMessage remoteMessage2 = remoteMessage;
        intent3.putExtras(remoteMessage2.zza);
        this.zzc.sendOrderedBroadcast(intent, "com.google.android.gtalkservice.permission.GTALK_SERVICE");
    }
}

