/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.iid.zzao;
import com.google.firebase.iid.zzt;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.messaging.zzv;
import com.google.firebase.messaging.zzx;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;

final class zzu {
    private static final long zza = TimeUnit.HOURS.toSeconds(8L);
    private static final Pattern zzb = Pattern.compile("[a-zA-Z0-9-_.~%]{1,900}");
    private final FirebaseInstanceId zzc;
    private final Context zzd;
    private final zzao zze;
    private final zzt zzf;
    @GuardedBy(value="this")
    private final ScheduledExecutorService zzg;
    @GuardedBy(value="this")
    private boolean zzh = false;
    @GuardedBy(value="this")
    private int zzi = 0;
    @GuardedBy(value="this")
    private final Map<Integer, TaskCompletionSource<Void>> zzj = new ArrayMap();
    @GuardedBy(value="itself")
    private final zzv zzk;

    zzu(FirebaseApp firebaseApp, FirebaseInstanceId firebaseInstanceId, zzao zzao2, UserAgentPublisher userAgentPublisher, HeartBeatInfo heartBeatInfo, FirebaseInstallationsApi firebaseInstallationsApi, Context context, Executor executor, ScheduledExecutorService scheduledExecutorService) {
        this(firebaseInstanceId, zzao2, new zzv(context), new zzt(firebaseApp, zzao2, executor, userAgentPublisher, heartBeatInfo, firebaseInstallationsApi), context, scheduledExecutorService);
    }

    @VisibleForTesting
    private zzu(FirebaseInstanceId firebaseInstanceId, zzao zzao2, zzv zzv2, zzt zzt2, Context context, @NonNull ScheduledExecutorService scheduledExecutorService) {
        this.zzc = firebaseInstanceId;
        this.zze = zzao2;
        this.zzk = zzv2;
        this.zzf = zzt2;
        this.zzd = context;
        this.zzg = scheduledExecutorService;
    }

    final Task<Void> zza(String string) {
        String string2 = String.valueOf("S!");
        String string3 = String.valueOf(zzu.zza(string, "subscribeToTopic"));
        Task<Void> task = this.zzc(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        this.zza();
        return task;
    }

    final Task<Void> zzb(String string) {
        String string2 = String.valueOf("U!");
        String string3 = String.valueOf(zzu.zza(string, "unsubscribeFromTopic"));
        Task<Void> task = this.zzc(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        this.zza();
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final synchronized Task<Void> zzc(String string) {
        String string2;
        zzv zzv2 = this.zzk;
        synchronized (zzv2) {
            string2 = this.zzk.zza();
            this.zzk.zza(new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string).length()).append(string2).append(",").append(string).toString());
        }
        zzv2 = new TaskCompletionSource();
        String string3 = string2;
        zzu zzu2 = this;
        int n = TextUtils.isEmpty((CharSequence)string3) ? 0 : string3.split(",").length - 1;
        this.zzj.put(zzu2.zzi + n, (TaskCompletionSource<Void>)zzv2);
        return zzv2.getTask();
    }

    private final synchronized boolean zzd() {
        return this.zzf() != null;
    }

    @NonNull
    private static String zza(String string, String string2) {
        if (string != null && string.startsWith("/topics/")) {
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(78 + String.valueOf(string2).length()).append("Format /topics/topic-name is deprecated. Only 'topic-name' should be used in ").append(string2).append(".").toString());
            string = string.substring(8);
        }
        if (string == null || !zzb.matcher(string).matches()) {
            String string3 = string;
            throw new IllegalArgumentException(new StringBuilder(79 + String.valueOf(string3).length()).append("Invalid topic name: ").append(string3).append(" does not match the allowed format [a-zA-Z0-9-_.~%]{1,900}.").toString());
        }
        return string;
    }

    final synchronized void zza() {
        if (this.zzd()) {
            this.zze();
        }
    }

    private final synchronized void zze() {
        if (!this.zzh) {
            this.zza(0L);
        }
    }

    final synchronized void zza(long l) {
        long l2 = Math.min(Math.max(30L, l << 1), zza);
        zzx zzx2 = new zzx(this, this.zzd, this.zze, l2);
        this.zza(zzx2, l);
        this.zzh = true;
    }

    final synchronized void zza(Runnable runnable, long l) {
        this.zzg.schedule(runnable, l, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    final boolean zzb() throws IOException {
        while (true) {
            String string;
            TaskCompletionSource<Void> taskCompletionSource = this;
            synchronized (taskCompletionSource) {
                string = this.zzf();
                if (string == null) {
                    if (zzu.zzc()) {
                        Log.d((String)"FirebaseMessaging", (String)"topic sync succeeded");
                    }
                    return true;
                }
            }
            if (!this.zzd(string)) {
                return false;
            }
            TaskCompletionSource<Void> taskCompletionSource2 = this;
            synchronized (taskCompletionSource2) {
                taskCompletionSource = this.zzj.remove(this.zzi);
                zzv zzv2 = this.zzk;
                synchronized (zzv2) {
                    this.zzk.zzb(string);
                }
                ++this.zzi;
            }
            if (taskCompletionSource == null) continue;
            taskCompletionSource.setResult(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="this")
    @Nullable
    private final String zzf() {
        String[] stringArray = this.zzk;
        synchronized (this.zzk) {
            String string = this.zzk.zza();
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (!TextUtils.isEmpty((CharSequence)string) && (stringArray = string.split(",")).length > 1 && !TextUtils.isEmpty((CharSequence)stringArray[1])) {
                return stringArray[1];
            }
            return null;
        }
    }

    @WorkerThread
    private final boolean zzd(String string) throws IOException {
        String[] stringArray = string.split("!");
        if (stringArray.length == 2) {
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            try {
                switch (string2) {
                    case "S": {
                        String string4 = string3;
                        zzu zzu2 = this;
                        InstanceIdResult instanceIdResult = (InstanceIdResult)zzu.zza(zzu2.zzc.getInstanceId());
                        zzu.zza(zzu2.zzf.zzc(instanceIdResult.getId(), instanceIdResult.getToken(), string4));
                        if (zzu.zzc()) {
                            Log.d((String)"FirebaseMessaging", (String)new StringBuilder(31 + String.valueOf(string3).length()).append("Subscribe to topic: ").append(string3).append(" succeeded.").toString());
                        }
                        break;
                    }
                    case "U": {
                        String string5 = string3;
                        zzu zzu3 = this;
                        InstanceIdResult instanceIdResult = (InstanceIdResult)zzu.zza(zzu3.zzc.getInstanceId());
                        zzu.zza(zzu3.zzf.zzd(instanceIdResult.getId(), instanceIdResult.getToken(), string5));
                        if (zzu.zzc()) {
                            Log.d((String)"FirebaseMessaging", (String)new StringBuilder(35 + String.valueOf(string3).length()).append("Unsubscribe from topic: ").append(string3).append(" succeeded.").toString());
                        }
                        break;
                    }
                    default: {
                        if (zzu.zzc()) {
                            Log.d((String)"FirebaseMessaging", (String)new StringBuilder(24 + String.valueOf(string).length()).append("Unknown topic operation").append(string).append(".").toString());
                        }
                        break;
                    }
                }
            }
            catch (IOException iOException) {
                if ("SERVICE_NOT_AVAILABLE".equals(iOException.getMessage()) || "INTERNAL_SERVER_ERROR".equals(iOException.getMessage())) {
                    String string6 = iOException.getMessage();
                    Log.e((String)"FirebaseMessaging", (String)new StringBuilder(53 + String.valueOf(string6).length()).append("Topic operation failed: ").append(string6).append(". Will retry Topic operation.").toString());
                    return false;
                }
                if (iOException.getMessage() == null) {
                    Log.e((String)"FirebaseMessaging", (String)"Topic operation failed without exception message. Will retry Topic operation.");
                    return false;
                }
                throw iOException;
            }
        }
        return true;
    }

    @WorkerThread
    private static <T> T zza(Task<T> task) throws IOException {
        try {
            return (T)Tasks.await(task, (long)30L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException executionException) {
            ExecutionException executionException2 = executionException;
            Throwable throwable = executionException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IOException(executionException2);
        }
        catch (InterruptedException | TimeoutException exception) {
            throw new IOException("SERVICE_NOT_AVAILABLE", exception);
        }
    }

    final synchronized void zza(boolean bl) {
        this.zzh = bl;
    }

    static boolean zzc() {
        return Log.isLoggable((String)"FirebaseMessaging", (int)3) || Build.VERSION.SDK_INT == 23 && Log.isLoggable((String)"FirebaseMessaging", (int)3);
    }
}

