/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.res.Resources;
import android.graphics.Color;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Arrays;
import java.util.MissingFormatArgumentException;
import org.json.JSONArray;
import org.json.JSONException;

public class NotificationParams {
    @NonNull
    private final Bundle data;

    public NotificationParams(@NonNull Bundle bundle) {
        Bundle bundle2;
        if (bundle == null) {
            Object object = new NullPointerException("data");
            throw object;
        }
        ((NotificationParams)object).data = bundle2 = new Bundle(bundle);
    }

    @Nullable
    Integer getNotificationCount() {
        if ((object = ((NotificationParams)object).getInteger("gcm.n.notification_count")) == null) {
            return null;
        }
        if ((Integer)object < 0) {
            Object object = String.valueOf(object);
            String string = String.valueOf(object);
            int n = string.length();
            StringBuilder stringBuilder = new StringBuilder(n + 67);
            stringBuilder.append("notificationCount is invalid: ");
            stringBuilder.append((String)object);
            stringBuilder.append(". Skipping setting notificationCount.");
            Log.w((String)"FirebaseMessaging", (String)stringBuilder.toString());
            return null;
        }
        return object;
    }

    @Nullable
    Integer getNotificationPriority() {
        if ((object = ((NotificationParams)object).getInteger("gcm.n.notification_priority")) == null) {
            return null;
        }
        if ((Integer)object < -2 || (Integer)object > 2) {
            Object object = String.valueOf(object);
            String string = String.valueOf(object);
            int n = string.length();
            StringBuilder stringBuilder = new StringBuilder(n + 72);
            stringBuilder.append("notificationPriority is invalid ");
            stringBuilder.append((String)object);
            stringBuilder.append(". Skipping setting notificationPriority.");
            Log.w((String)"FirebaseMessaging", (String)stringBuilder.toString());
            return null;
        }
        return object;
    }

    Integer getVisibility() {
        if ((object = ((NotificationParams)object).getInteger("gcm.n.visibility")) == null) {
            return null;
        }
        if ((Integer)object < -1 || (Integer)object > 1) {
            Object object = String.valueOf(object);
            String string = String.valueOf(object);
            int n = string.length();
            StringBuilder stringBuilder = new StringBuilder(n + 53);
            stringBuilder.append("visibility is invalid: ");
            stringBuilder.append((String)object);
            stringBuilder.append(". Skipping setting visibility.");
            Log.w((String)"NotificationParams", (String)stringBuilder.toString());
            return null;
        }
        return object;
    }

    public String getString(String string) {
        return this.data.getString(this.normalizePrefix(string));
    }

    private String normalizePrefix(String string) {
        String string2;
        if (!this.data.containsKey(string) && string.startsWith("gcm.n.") && this.data.containsKey(string2 = NotificationParams.keyWithOldPrefix(string))) {
            return string2;
        }
        return string;
    }

    public boolean getBoolean(String string) {
        return "1".equals(this = ((NotificationParams)this).getString(string)) || Boolean.parseBoolean((String)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Integer getInteger(String string) {
        if (TextUtils.isEmpty((CharSequence)(this = ((NotificationParams)this).getString(string)))) return null;
        try {
            return Integer.parseInt((String)this);
        }
        catch (NumberFormatException numberFormatException) {
            string = NotificationParams.userFriendlyKey(string);
            String string2 = String.valueOf(string);
            int n = string2.length();
            String string3 = String.valueOf(this);
            int n2 = string3.length();
            StringBuilder stringBuilder = new StringBuilder(n + 38 + n2);
            stringBuilder.append("Couldn't parse value of ");
            stringBuilder.append(string);
            stringBuilder.append("(");
            stringBuilder.append((String)this);
            stringBuilder.append(") into an int");
            Log.w((String)"NotificationParams", (String)stringBuilder.toString());
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Long getLong(String string) {
        if (TextUtils.isEmpty((CharSequence)(this = ((NotificationParams)this).getString(string)))) return null;
        try {
            return Long.parseLong((String)this);
        }
        catch (NumberFormatException numberFormatException) {
            string = NotificationParams.userFriendlyKey(string);
            String string2 = String.valueOf(string);
            int n = string2.length();
            String string3 = String.valueOf(this);
            int n2 = string3.length();
            StringBuilder stringBuilder = new StringBuilder(n + 38 + n2);
            stringBuilder.append("Couldn't parse value of ");
            stringBuilder.append(string);
            stringBuilder.append("(");
            stringBuilder.append((String)this);
            stringBuilder.append(") into a long");
            Log.w((String)"NotificationParams", (String)stringBuilder.toString());
            return null;
        }
    }

    @Nullable
    public String getLocalizationResourceForKey(String string) {
        return this.getString(String.valueOf(string).concat("_loc_key"));
    }

    @Nullable
    public Object[] getLocalizationArgsForKey(String string) {
        if ((string = this.getJSONArray(String.valueOf(string).concat("_loc_args"))) == null) {
            return null;
        }
        Object[] objectArray = new String[string.length()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = string.optString(i);
        }
        return objectArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public JSONArray getJSONArray(String string) {
        if (TextUtils.isEmpty((CharSequence)(this = ((NotificationParams)this).getString(string)))) return null;
        try {
            return new JSONArray((String)this);
        }
        catch (JSONException jSONException) {
            string = NotificationParams.userFriendlyKey(string);
            String string2 = String.valueOf(string);
            int n = string2.length();
            String string3 = String.valueOf(this);
            int n2 = string3.length();
            StringBuilder stringBuilder = new StringBuilder(n + 50 + n2);
            stringBuilder.append("Malformed JSON for key ");
            stringBuilder.append(string);
            stringBuilder.append(": ");
            stringBuilder.append((String)this);
            stringBuilder.append(", falling back to default");
            Log.w((String)"NotificationParams", (String)stringBuilder.toString());
            return null;
        }
    }

    private static String userFriendlyKey(String string) {
        if (string.startsWith("gcm.n.")) {
            return string.substring(6);
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public Uri getLink() {
        String string = ((NotificationParams)this).getString("gcm.n.link_android");
        if (!TextUtils.isEmpty((CharSequence)(this = TextUtils.isEmpty((CharSequence)string) ? ((NotificationParams)this).getString("gcm.n.link") : string))) {
            return Uri.parse((String)this);
        }
        return null;
    }

    @Nullable
    public String getSoundResourceName() {
        String string = this.getString("gcm.n.sound2");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return this.getString("gcm.n.sound");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public long[] getVibrateTimings() {
        Object object = ((NotificationParams)((Object)string)).getJSONArray("gcm.n.vibrate_timings");
        if (object == null) {
            return null;
        }
        try {
            int n = object.length();
            if (n <= 1) {
                JSONException jSONException = new JSONException("vibrateTimings have invalid length");
                throw jSONException;
            }
            long[] lArray = new long[object.length()];
            n = 0;
            while (true) {
                int n2;
                if (n >= (n2 = lArray.length)) {
                    return lArray;
                }
                lArray[n] = object.optLong(n);
                ++n;
            }
        }
        catch (NumberFormatException | JSONException throwable) {
            String string = String.valueOf(object);
            object = String.valueOf(string);
            int n = ((String)object).length();
            StringBuilder stringBuilder = new StringBuilder(n + 74);
            stringBuilder.append("User defined vibrateTimings is invalid: ");
            stringBuilder.append(string);
            stringBuilder.append(". Skipping setting vibrateTimings.");
            Log.w((String)"NotificationParams", (String)stringBuilder.toString());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    int[] getLightSettings() {
        Object object;
        if ((object = ((NotificationParams)object).getJSONArray("gcm.n.light_settings")) == null) {
            return null;
        }
        Object object2 = new int[3];
        try {
            int n = object.length();
            if (n != 3) {
                object2 = (Object)new JSONException;
                object2("lightSettings don't have all three fields");
                throw object2;
            }
            object2[0] = NotificationParams.getLightColor(object.optString(0));
            object2[1] = object.optInt(1);
            object2[2] = object.optInt(2);
            return object2;
        }
        catch (JSONException jSONException) {
            object = String.valueOf(object);
            object2 = String.valueOf(object);
            int n = ((String)object2).length();
            StringBuilder stringBuilder = new StringBuilder(n + 58);
            stringBuilder.append("LightSettings is invalid: ");
            stringBuilder.append((String)object);
            stringBuilder.append(". Skipping setting LightSettings");
            Log.w((String)"NotificationParams", (String)stringBuilder.toString());
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            object = String.valueOf(object);
            String string = illegalArgumentException.getMessage();
            String string2 = String.valueOf(object);
            int n = string2.length();
            String string3 = String.valueOf(string);
            int n2 = string3.length();
            StringBuilder stringBuilder = new StringBuilder(n + 60 + n2);
            stringBuilder.append("LightSettings is invalid: ");
            stringBuilder.append((String)object);
            stringBuilder.append(". ");
            stringBuilder.append(string);
            stringBuilder.append(". Skipping setting LightSettings");
            Log.w((String)"NotificationParams", (String)stringBuilder.toString());
            return null;
        }
    }

    public Bundle paramsWithReservedKeysRemoved() {
        Bundle bundle = new Bundle(((NotificationParams)this).data);
        for (String string : ((NotificationParams)this).data.keySet()) {
            if (!NotificationParams.isReservedKey(string)) continue;
            bundle.remove(string);
        }
        return bundle;
    }

    public Bundle paramsForAnalyticsIntent() {
        Bundle bundle = new Bundle(((NotificationParams)this).data);
        for (String string : ((NotificationParams)this).data.keySet()) {
            if (NotificationParams.isAnalyticsKey(string)) continue;
            bundle.remove(string);
        }
        return bundle;
    }

    @Nullable
    public String getLocalizedString(Resources object, String string, String string2) {
        Object object2;
        CharSequence charSequence = object2.getLocalizationResourceForKey(string2);
        if (TextUtils.isEmpty((CharSequence)charSequence)) {
            return null;
        }
        int n = object.getIdentifier((String)charSequence, "string", string);
        if (n == 0) {
            object2 = NotificationParams.userFriendlyKey(String.valueOf(string2).concat("_loc_key"));
            object = String.valueOf(object2);
            int n2 = ((String)object).length();
            String string3 = String.valueOf(string2);
            int n3 = string3.length();
            charSequence = new StringBuilder(n2 + 49 + n3);
            ((StringBuilder)charSequence).append((String)object2);
            ((StringBuilder)charSequence).append(" resource not found: ");
            ((StringBuilder)charSequence).append(string2);
            ((StringBuilder)charSequence).append(" Default value will be used.");
            Log.w((String)"NotificationParams", (String)((StringBuilder)charSequence).toString());
            return null;
        }
        if ((object2 = object2.getLocalizationArgsForKey(string2)) == null) {
            return object.getString(n);
        }
        try {
            object = object.getString(n, object2);
            return object;
        }
        catch (MissingFormatArgumentException missingFormatArgumentException) {
            String string4 = NotificationParams.userFriendlyKey(string2);
            object2 = Arrays.toString(object2);
            string2 = String.valueOf(string4);
            int n4 = string2.length();
            charSequence = String.valueOf(object2);
            int n5 = ((String)charSequence).length();
            StringBuilder stringBuilder = new StringBuilder(n4 + 58 + n5);
            stringBuilder.append("Missing format argument for ");
            stringBuilder.append(string4);
            stringBuilder.append(": ");
            stringBuilder.append((String)object2);
            stringBuilder.append(" Default value will be used.");
            Log.w((String)"NotificationParams", (String)stringBuilder.toString(), (Throwable)missingFormatArgumentException);
            return null;
        }
    }

    public String getPossiblyLocalizedString(Resources resources, String string, String string2) {
        String string3 = this.getString(string2);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            return string3;
        }
        return this.getLocalizedString(resources, string, string2);
    }

    public boolean hasImage() {
        return !TextUtils.isEmpty((CharSequence)this.getString("gcm.n.image"));
    }

    public String getNotificationChannelId() {
        return this.getString("gcm.n.android_channel_id");
    }

    private static boolean isAnalyticsKey(String string) {
        return string.startsWith("google.c.a.") || string.equals("from");
    }

    private static boolean isReservedKey(String string) {
        return string.startsWith("google.c.") || string.startsWith("gcm.n.") || string.startsWith("gcm.notification.");
    }

    private static int getLightColor(String string) {
        int n = Color.parseColor((String)string);
        if (n == -16777216) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Transparent color is invalid");
            throw illegalArgumentException;
        }
        return n;
    }

    public boolean isNotification() {
        return this.getBoolean("gcm.n.e");
    }

    public static boolean isNotification(Bundle bundle) {
        return "1".equals(bundle.getString("gcm.n.e")) || "1".equals(bundle.getString(NotificationParams.keyWithOldPrefix("gcm.n.e")));
    }

    private static String keyWithOldPrefix(String string) {
        if (!string.startsWith("gcm.n.")) {
            return string;
        }
        return string.replace("gcm.n.", "gcm.notification.");
    }
}

