/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.TargetApi;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.app.NotificationCompat;
import androidx.core.content.ContextCompat;
import com.google.firebase.messaging.NotificationParams;
import java.util.concurrent.atomic.AtomicInteger;

public final class CommonNotificationBuilder {
    @NonNull
    public static final String METADATA_DEFAULT_COLOR = "com.google.firebase.messaging.default_notification_color";
    @NonNull
    public static final String METADATA_DEFAULT_ICON = "com.google.firebase.messaging.default_notification_icon";
    @NonNull
    public static final String METADATA_DEFAULT_CHANNEL_ID = "com.google.firebase.messaging.default_notification_channel_id";
    @NonNull
    public static final String FCM_FALLBACK_NOTIFICATION_CHANNEL = "fcm_fallback_notification_channel";
    @NonNull
    public static final String FCM_FALLBACK_NOTIFICATION_CHANNEL_LABEL = "fcm_fallback_notification_channel_label";
    private static final AtomicInteger requestCodeProvider;

    private CommonNotificationBuilder() {
    }

    static DisplayNotificationInfo createNotificationInfo(Context context, NotificationParams notificationParams) {
        Bundle bundle = CommonNotificationBuilder.getManifestMetadata(context.getPackageManager(), context.getPackageName());
        return CommonNotificationBuilder.createNotificationInfo(context, context.getPackageName(), notificationParams, CommonNotificationBuilder.getOrCreateChannel(context, notificationParams.getNotificationChannelId(), bundle), context.getResources(), context.getPackageManager(), bundle);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static DisplayNotificationInfo createNotificationInfo(@NonNull Context context, @NonNull String pkgName, @NonNull NotificationParams params, @NonNull String channelId, @NonNull Resources appResources, @NonNull PackageManager appPackageManager, @NonNull Bundle manifestMetadata) {
        void var6_6;
        void var5_5;
        PendingIntent pendingIntent;
        void var4_4;
        void var2_2;
        String string;
        Object object;
        NotificationCompat.Builder builder = new NotificationCompat.Builder(object, string);
        string = var2_2.getPossiblyLocalizedString((Resources)var4_4, (String)pendingIntent, "gcm.n.title");
        if (!TextUtils.isEmpty((CharSequence)string)) {
            builder.setContentTitle((CharSequence)string);
        }
        if (!TextUtils.isEmpty((CharSequence)(string = var2_2.getPossiblyLocalizedString((Resources)var4_4, (String)pendingIntent, "gcm.n.body")))) {
            builder.setContentText((CharSequence)string);
            NotificationCompat.BigTextStyle bigTextStyle = new NotificationCompat.BigTextStyle();
            builder.setStyle((NotificationCompat.Style)bigTextStyle.bigText((CharSequence)string));
        }
        builder.setSmallIcon(CommonNotificationBuilder.getSmallIcon((PackageManager)var5_5, (Resources)var4_4, (String)pendingIntent, var2_2.getString("gcm.n.icon"), (Bundle)var6_6));
        string = CommonNotificationBuilder.getSound((String)pendingIntent, (NotificationParams)var2_2, (Resources)var4_4);
        if (string != null) {
            builder.setSound((Uri)string);
        }
        builder.setContentIntent(CommonNotificationBuilder.createContentIntent(object, (NotificationParams)var2_2, (String)pendingIntent, (PackageManager)var5_5));
        pendingIntent = CommonNotificationBuilder.createDeleteIntent(object, (NotificationParams)var2_2);
        if (pendingIntent != null) {
            builder.setDeleteIntent(pendingIntent);
        }
        if ((object = CommonNotificationBuilder.getColor(object, var2_2.getString("gcm.n.color"), (Bundle)var6_6)) != null) {
            builder.setColor(object.intValue());
        }
        builder.setAutoCancel(var2_2.getBoolean("gcm.n.sticky") ^ true);
        builder.setLocalOnly(var2_2.getBoolean("gcm.n.local_only"));
        object = var2_2.getString("gcm.n.ticker");
        if (object != null) {
            builder.setTicker((CharSequence)object);
        }
        if ((object = var2_2.getNotificationPriority()) != null) {
            builder.setPriority(object.intValue());
        }
        if ((object = var2_2.getVisibility()) != null) {
            builder.setVisibility(object.intValue());
        }
        if ((object = var2_2.getNotificationCount()) != null) {
            builder.setNumber(object.intValue());
        }
        if ((object = var2_2.getLong("gcm.n.event_time")) != null) {
            builder.setShowWhen(true);
            builder.setWhen(object.longValue());
        }
        if ((object = (Object)var2_2.getVibrateTimings()) != null) {
            builder.setVibrate((long[])object);
        }
        if ((object = (Object)var2_2.getLightSettings()) != null) {
            builder.setLights((int)object[0], (int)object[1], (int)object[2]);
        }
        builder.setDefaults(CommonNotificationBuilder.getConsolidatedDefaults((NotificationParams)var2_2));
        object = new DisplayNotificationInfo(builder, CommonNotificationBuilder.getTag((NotificationParams)var2_2), 0);
        return object;
    }

    private static int getConsolidatedDefaults(NotificationParams notificationParams) {
        int n;
        int n2 = notificationParams.getBoolean("gcm.n.default_sound");
        if (notificationParams.getBoolean("gcm.n.default_vibrate_timings")) {
            n = n2 | 2;
        }
        if (notificationParams.getBoolean("gcm.n.default_light_settings")) {
            return n | 4;
        }
        return n;
    }

    @TargetApi(value=26)
    private static boolean isValidIcon(Resources object, int n) {
        block4: {
            if (Build.VERSION.SDK_INT != 26) {
                return true;
            }
            try {
                boolean bl = object.getDrawable(n, null) instanceof AdaptiveIconDrawable;
                if (!bl) break block4;
            }
            catch (Resources.NotFoundException notFoundException) {
                object = new StringBuilder(66);
                ((StringBuilder)object).append("Couldn't find resource ");
                ((StringBuilder)object).append(n);
                ((StringBuilder)object).append(", treating it as an invalid icon");
                Log.e((String)"FirebaseMessaging", (String)((StringBuilder)object).toString());
                return false;
            }
            StringBuilder stringBuilder = new StringBuilder(77);
            stringBuilder.append("Adaptive icons cannot be used in notifications. Ignoring icon id: ");
            stringBuilder.append(n);
            Log.e((String)"FirebaseMessaging", (String)stringBuilder.toString());
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static int getSmallIcon(PackageManager var0, Resources var1_4, String var2_5, String var3_7, Bundle var4_9) {
        block8: {
            block9: {
                block7: {
                    if (TextUtils.isEmpty((CharSequence)var3_7)) break block7;
                    var5_10 = var1_4.getIdentifier(var3_7, "drawable", var2_5);
                    if (var5_10 != 0 && CommonNotificationBuilder.isValidIcon(var1_4, var5_10)) break block8;
                    var5_10 = var1_4.getIdentifier(var3_7, "mipmap", var2_5);
                    if (var5_10 != 0 && CommonNotificationBuilder.isValidIcon(var1_4, var5_10)) break block9;
                    var5_11 = String.valueOf(var3_7);
                    var5_12 = var5_11.length();
                    var6_13 = new StringBuilder(var5_12 + 61);
                    var6_13.append("Icon resource ");
                    var6_13.append(var3_7);
                    var6_13.append(" not found. Notification will use default icon.");
                    Log.w((String)"FirebaseMessaging", (String)var6_13.toString());
                }
                if ((var3_8 = var4_9.getInt("com.google.firebase.messaging.default_notification_icon", 0)) == 0 || !CommonNotificationBuilder.isValidIcon(var1_4, var3_8)) {
                    var0_1 = var0.getApplicationInfo((String)var2_5, (int)0).icon;
lbl21:
                    // 3 sources

                    while (true) {
                        if (var0_1 != 0) {
                            if (!CommonNotificationBuilder.isValidIcon(var1_4, var0_1)) {
                                return 17301651;
                            }
lbl25:
                            // 3 sources

                            return var0_1;
                        }
                        var0_1 = 17301651;
                        ** continue;
                        break;
                    }
                }
                var0_1 = var3_8;
                ** GOTO lbl21
            }
            return var5_10;
        }
        return var5_10;
        catch (PackageManager.NameNotFoundException var0_2) {
            var0_3 = String.valueOf((Object)var0_2);
            var2_5 = String.valueOf(var0_3);
            var2_6 = var2_5.length();
            var4_9 = new StringBuilder(var2_6 + 35);
            var4_9.append("Couldn't get own application info: ");
            var4_9.append(var0_3);
            Log.w((String)"FirebaseMessaging", (String)var4_9.toString());
            var0_1 = var3_8;
            ** continue;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Integer getColor(Context object, String string, Bundle bundle) {
        void var2_4;
        int n;
        void var1_2;
        if (Build.VERSION.SDK_INT < 21) {
            return null;
        }
        if (!TextUtils.isEmpty((CharSequence)var1_2)) {
            try {
                return Color.parseColor((String)var1_2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string2 = String.valueOf(var1_2);
                int n2 = string2.length();
                StringBuilder stringBuilder = new StringBuilder(n2 + 56);
                stringBuilder.append("Color is invalid: ");
                stringBuilder.append((String)var1_2);
                stringBuilder.append(". Notification will use default color.");
                Log.w((String)"FirebaseMessaging", (String)stringBuilder.toString());
            }
        }
        if ((n = var2_4.getInt(METADATA_DEFAULT_COLOR, 0)) == 0) return null;
        try {
            return ContextCompat.getColor((Context)object, (int)n);
        }
        catch (Resources.NotFoundException notFoundException) {
            Log.w((String)"FirebaseMessaging", (String)"Cannot find the color resource referenced in AndroidManifest.");
            return null;
        }
    }

    private static Uri getSound(String string, NotificationParams object, Resources object2) {
        if (TextUtils.isEmpty((CharSequence)(object = ((NotificationParams)object).getSoundResourceName()))) {
            return null;
        }
        if (!"default".equals(object) && object2.getIdentifier((String)object, "raw", string) != 0) {
            object2 = String.valueOf(string);
            int n = ((String)object2).length();
            String string2 = String.valueOf(object);
            int n2 = string2.length();
            StringBuilder stringBuilder = new StringBuilder(n + 24 + n2);
            stringBuilder.append("android.resource://");
            stringBuilder.append(string);
            stringBuilder.append("/raw/");
            stringBuilder.append((String)object);
            return Uri.parse((String)stringBuilder.toString());
        }
        return RingtoneManager.getDefaultUri((int)2);
    }

    @Nullable
    private static PendingIntent createContentIntent(Context context, NotificationParams notificationParams, String string, PackageManager packageManager) {
        if ((string = CommonNotificationBuilder.createTargetIntent(string, notificationParams, packageManager)) == null) {
            return null;
        }
        string.addFlags(0x4000000);
        string.putExtras(notificationParams.paramsWithReservedKeysRemoved());
        if (CommonNotificationBuilder.shouldUploadMetrics(notificationParams)) {
            string.putExtra("gcm.n.analytics_data", notificationParams.paramsForAnalyticsIntent());
        }
        return PendingIntent.getActivity((Context)context, (int)CommonNotificationBuilder.generatePendingIntentRequestCode(), (Intent)string, (int)CommonNotificationBuilder.getPendingIntentFlags(0x40000000));
    }

    private static Intent createTargetIntent(String string, NotificationParams notificationParams, PackageManager packageManager) {
        String string2 = notificationParams.getString("gcm.n.click_action");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            notificationParams = new Intent(string2);
            notificationParams.setPackage(string);
            notificationParams.setFlags(0x10000000);
            return notificationParams;
        }
        if ((notificationParams = notificationParams.getLink()) != null) {
            packageManager = new Intent("android.intent.action.VIEW");
            packageManager.setPackage(string);
            packageManager.setData((Uri)notificationParams);
            return packageManager;
        }
        if ((string = packageManager.getLaunchIntentForPackage(string)) == null) {
            Log.w((String)"FirebaseMessaging", (String)"No activity found to launch app");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Bundle getManifestMetadata(PackageManager packageManager, String string) {
        try {
            packageManager = packageManager.getApplicationInfo(string, 128);
            if (packageManager == null) return Bundle.EMPTY;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string2 = String.valueOf((Object)nameNotFoundException);
            string = String.valueOf(string2);
            int n = string.length();
            StringBuilder stringBuilder = new StringBuilder(n + 35);
            stringBuilder.append("Couldn't get own application info: ");
            stringBuilder.append(string2);
            Log.w((String)"FirebaseMessaging", (String)stringBuilder.toString());
            return Bundle.EMPTY;
        }
        string = packageManager.metaData;
        if (string == null) return Bundle.EMPTY;
        return packageManager.metaData;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=26)
    @VisibleForTesting
    @NonNull
    public static String getOrCreateChannel(@NonNull Context context, @NonNull String msgChannel, @NonNull Bundle manifestMetadata) {
        block11: {
            void var2_7;
            String string;
            Context context2;
            if (Build.VERSION.SDK_INT < 26) {
                return null;
            }
            try {
                int n = context2.getPackageManager().getApplicationInfo((String)context2.getPackageName(), (int)0).targetSdkVersion;
                if (n < 26) break block11;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return null;
            }
            NotificationManager notificationManager = (NotificationManager)context2.getSystemService(NotificationManager.class);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                if (notificationManager.getNotificationChannel(string) != null) {
                    return string;
                }
                String string2 = String.valueOf(string);
                int n = string2.length();
                StringBuilder stringBuilder = new StringBuilder(n + 122);
                stringBuilder.append("Notification Channel requested (");
                stringBuilder.append(string);
                stringBuilder.append(") has not been created by the app. Manifest configuration, or default, value will be used.");
                Log.w((String)"FirebaseMessaging", (String)stringBuilder.toString());
            }
            if (!TextUtils.isEmpty((CharSequence)(string = var2_7.getString(METADATA_DEFAULT_CHANNEL_ID)))) {
                if (notificationManager.getNotificationChannel(string) != null) {
                    return string;
                }
                Log.w((String)"FirebaseMessaging", (String)"Notification Channel set in AndroidManifest.xml has not been created by the app. Default value will be used.");
            } else {
                Log.w((String)"FirebaseMessaging", (String)"Missing Default Notification Channel metadata in AndroidManifest. Default value will be used.");
            }
            if (notificationManager.getNotificationChannel(FCM_FALLBACK_NOTIFICATION_CHANNEL) == null) {
                void var0_2;
                int n = context2.getResources().getIdentifier(FCM_FALLBACK_NOTIFICATION_CHANNEL_LABEL, "string", context2.getPackageName());
                if (n == 0) {
                    Log.e((String)"FirebaseMessaging", (String)"String resource \"fcm_fallback_notification_channel_label\" is not found. Using default string channel name.");
                    String string3 = "Misc";
                } else {
                    String string4 = context2.getString(n);
                }
                NotificationChannel notificationChannel = new NotificationChannel(FCM_FALLBACK_NOTIFICATION_CHANNEL, (CharSequence)var0_2, 3);
                notificationManager.createNotificationChannel(notificationChannel);
            }
            return FCM_FALLBACK_NOTIFICATION_CHANNEL;
        }
        return null;
    }

    private static int generatePendingIntentRequestCode() {
        return requestCodeProvider.incrementAndGet();
    }

    private static int getPendingIntentFlags(int n) {
        if (Build.VERSION.SDK_INT >= 23) {
            return 0x44000000;
        }
        return 0x40000000;
    }

    @Nullable
    private static PendingIntent createDeleteIntent(Context context, NotificationParams notificationParams) {
        if (!CommonNotificationBuilder.shouldUploadMetrics(notificationParams)) {
            return null;
        }
        Intent intent = new Intent("com.google.firebase.messaging.NOTIFICATION_DISMISS");
        return CommonNotificationBuilder.createMessagingPendingIntent(context, intent.putExtras(notificationParams.paramsForAnalyticsIntent()));
    }

    private static PendingIntent createMessagingPendingIntent(Context context, Intent intent) {
        int n = CommonNotificationBuilder.generatePendingIntentRequestCode();
        Intent intent2 = new Intent("com.google.firebase.MESSAGING_EVENT");
        ComponentName componentName = new ComponentName(context, "com.google.firebase.iid.FirebaseInstanceIdReceiver");
        return PendingIntent.getBroadcast((Context)context, (int)n, (Intent)intent2.setComponent(componentName).putExtra("wrapped_intent", (Parcelable)intent), (int)CommonNotificationBuilder.getPendingIntentFlags(0x40000000));
    }

    static boolean shouldUploadMetrics(@NonNull NotificationParams notificationParams) {
        return notificationParams.getBoolean("google.c.a.e");
    }

    private static String getTag(NotificationParams object) {
        if (!TextUtils.isEmpty((CharSequence)(object = ((NotificationParams)object).getString("gcm.n.tag")))) {
            return object;
        }
        long l = SystemClock.uptimeMillis();
        object = new StringBuilder(37);
        ((StringBuilder)object).append("FCM-Notification:");
        ((StringBuilder)object).append(l);
        return ((StringBuilder)object).toString();
    }

    static {
        AtomicInteger atomicInteger;
        requestCodeProvider = atomicInteger = new AtomicInteger((int)SystemClock.elapsedRealtime());
    }

    public static class DisplayNotificationInfo {
        @NonNull
        public final NotificationCompat.Builder notificationBuilder;
        @NonNull
        public final String tag;
        public final int id;

        DisplayNotificationInfo(NotificationCompat.Builder builder, String string, int n) {
            this.notificationBuilder = builder;
            this.tag = string;
            this.id = 0;
        }
    }
}

