/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.datatransport.Encoding;
import com.google.android.datatransport.Event;
import com.google.android.datatransport.Transformer;
import com.google.android.datatransport.TransportFactory;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.installations.FirebaseInstallations;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.MessagingAnalytics$$ExternalSyntheticLambda0;
import com.google.firebase.messaging.NotificationParams;
import com.google.firebase.messaging.reporting.MessagingClientEvent;
import com.google.firebase.messaging.reporting.MessagingClientEventExtension;
import java.util.concurrent.ExecutionException;

public class MessagingAnalytics {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    static int getTtl(Bundle object) {
        Object object2 = object.get("google.ttl");
        if (object2 instanceof Integer) {
            return (Integer)object2;
        }
        if (!(object2 instanceof String)) return 0;
        try {
            return Integer.parseInt((String)object2);
        }
        catch (NumberFormatException numberFormatException) {
            String string = String.valueOf(object2);
            String.valueOf(string).length();
            Log.w((String)"FirebaseMessaging", (String)"Invalid TTL: ".concat(String.valueOf(string)));
            return 0;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    static long getProjectNumber(Bundle object) {
        String string;
        if (object.containsKey("google.c.sender.id")) {
            try {
                return Long.parseLong(object.getString("google.c.sender.id"));
            }
            catch (NumberFormatException numberFormatException) {
                Log.w((String)"FirebaseMessaging", (String)"error parsing project number", (Throwable)numberFormatException);
            }
        }
        if ((string = (object = FirebaseApp.getInstance()).getOptions().getGcmSenderId()) != null) {
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                Log.w((String)"FirebaseMessaging", (String)"error parsing sender ID", (Throwable)numberFormatException);
            }
        }
        if (!((String)(object = object.getOptions().getApplicationId())).startsWith("1:")) {
            return Long.parseLong((String)object);
        }
        if (((Object)(object = ((String)object).split(":"))).length < 2) {
            return 0L;
        }
        if (((String)(object = object[1])).isEmpty()) {
            return 0L;
        }
        try {
            return Long.parseLong((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            Log.w((String)"FirebaseMessaging", (String)"error parsing app ID", (Throwable)numberFormatException);
            return 0L;
        }
        catch (NumberFormatException numberFormatException) {
            Log.w((String)"FirebaseMessaging", (String)"error parsing app ID", (Throwable)numberFormatException);
            return 0L;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    static MessagingClientEvent.MessageType getMessageTypeForFirelog(Bundle object) {
        void var0_2;
        if (object != null && NotificationParams.isNotification(object)) {
            MessagingClientEvent.MessageType messageType = MessagingClientEvent.MessageType.DISPLAY_NOTIFICATION;
            return var0_2;
        }
        MessagingClientEvent.MessageType messageType = MessagingClientEvent.MessageType.DATA_MESSAGE;
        return var0_2;
    }

    static MessagingClientEvent eventToProto(MessagingClientEvent.Event object, Intent intent) {
        long l;
        if (intent == null) {
            return null;
        }
        if ((intent = intent.getExtras()) == null) {
            intent = Bundle.EMPTY;
        }
        MessagingClientEvent.Builder builder = MessagingClientEvent.newBuilder();
        builder.setTtl(MessagingAnalytics.getTtl((Bundle)intent));
        builder.setEvent((MessagingClientEvent.Event)object);
        builder.setInstanceId(MessagingAnalytics.getInstanceId((Bundle)intent));
        builder.setPackageName(MessagingAnalytics.getPackageName());
        builder.setSdkPlatform(MessagingClientEvent.SDKPlatform.ANDROID);
        builder.setMessageType(MessagingAnalytics.getMessageTypeForFirelog((Bundle)intent));
        object = MessagingAnalytics.getMessageId((Bundle)intent);
        if (object != null) {
            builder.setMessageId((String)object);
        }
        if ((object = MessagingAnalytics.getTopic((Bundle)intent)) != null) {
            builder.setTopic((String)object);
        }
        if ((object = MessagingAnalytics.getCollapseKey((Bundle)intent)) != null) {
            builder.setCollapseKey((String)object);
        }
        if ((object = MessagingAnalytics.getMessageLabel((Bundle)intent)) != null) {
            builder.setAnalyticsLabel((String)object);
        }
        if ((object = MessagingAnalytics.getComposerLabel((Bundle)intent)) != null) {
            builder.setComposerLabel((String)object);
        }
        if ((l = MessagingAnalytics.getProjectNumber((Bundle)intent)) > 0L) {
            builder.setProjectNumber(l);
        }
        return builder.build();
    }

    @Nullable
    static String getCollapseKey(Bundle bundle) {
        return bundle.getString("collapse_key");
    }

    @Nullable
    static String getComposerId(Bundle bundle) {
        return bundle.getString("google.c.a.c_id");
    }

    @Nullable
    static String getComposerLabel(Bundle bundle) {
        return bundle.getString("google.c.a.c_l");
    }

    @NonNull
    static String getInstanceId(Bundle object) {
        if (!TextUtils.isEmpty((CharSequence)(object = object.getString("google.to")))) {
            return object;
        }
        try {
            object = (String)Tasks.await((Task)FirebaseInstallations.getInstance((FirebaseApp)FirebaseApp.getInstance()).getId());
        }
        catch (InterruptedException | ExecutionException exception) {
            RuntimeException runtimeException = new RuntimeException(exception);
            throw runtimeException;
        }
        return object;
    }

    @Nullable
    static String getMessageChannel(Bundle bundle) {
        return bundle.getString("google.c.a.m_c");
    }

    @Nullable
    static String getMessageId(Bundle bundle) {
        String string = bundle.getString("google.message_id");
        if (string == null) {
            return bundle.getString("message_id");
        }
        return string;
    }

    @Nullable
    static String getMessageLabel(Bundle bundle) {
        return bundle.getString("google.c.a.m_l");
    }

    @Nullable
    static String getMessageTime(Bundle bundle) {
        return bundle.getString("google.c.a.ts");
    }

    @NonNull
    static String getMessageTypeForScion(Bundle bundle) {
        if (!NotificationParams.isNotification(bundle)) {
            return "data";
        }
        return "display";
    }

    @NonNull
    static String getPackageName() {
        return FirebaseApp.getInstance().getApplicationContext().getPackageName();
    }

    @Nullable
    static String getTopic(Bundle object) {
        if ((object = object.getString("from")) != null && ((String)object).startsWith("/topics/")) {
            return object;
        }
        return null;
    }

    @Nullable
    static String getUseDeviceTime(Bundle bundle) {
        if (bundle.containsKey("google.c.a.udt")) {
            return bundle.getString("google.c.a.udt");
        }
        return null;
    }

    public static void logNotificationDismiss(@NonNull Intent intent) {
        Intent intent2;
        MessagingAnalytics.logToScion("_nd", intent2.getExtras());
    }

    public static void logNotificationForeground(@NonNull Intent intent) {
        Intent intent2;
        MessagingAnalytics.logToScion("_nf", intent2.getExtras());
    }

    public static void logNotificationOpen(@NonNull Bundle extras) {
        Bundle bundle;
        MessagingAnalytics.setUserPropertyIfRequired(extras);
        MessagingAnalytics.logToScion("_no", bundle);
    }

    public static void logNotificationReceived(@NonNull Intent intent) {
        Intent intent2;
        if (MessagingAnalytics.shouldUploadScionMetrics(intent)) {
            MessagingAnalytics.logToScion("_nr", intent2.getExtras());
        }
        if (MessagingAnalytics.shouldUploadFirelogAnalytics(intent2)) {
            MessagingAnalytics.logToFirelog(MessagingClientEvent.Event.MESSAGE_DELIVERED, intent2, FirebaseMessaging.getTransportFactory());
            return;
        }
    }

    private static void logToFirelog(MessagingClientEvent.Event object, Intent intent, @Nullable TransportFactory object2) {
        if (object2 == null) {
            Log.e((String)"FirebaseMessaging", (String)"TransportFactory is null. Skip exporting message delivery metrics to Big Query");
            return;
        }
        if ((object = MessagingAnalytics.eventToProto((MessagingClientEvent.Event)object, intent)) == null) {
            return;
        }
        try {
            intent = object2.getTransport("FCM_CLIENT_EVENT_LOGGING", MessagingClientEventExtension.class, Encoding.of((String)"proto"), (Transformer)MessagingAnalytics$$ExternalSyntheticLambda0.INSTANCE);
            object2 = MessagingClientEventExtension.newBuilder();
            ((MessagingClientEventExtension.Builder)object2).setMessagingClientEvent((MessagingClientEvent)object);
            intent.send(Event.ofTelemetry((Object)((MessagingClientEventExtension.Builder)object2).build()));
            return;
        }
        catch (RuntimeException runtimeException) {
            Log.w((String)"FirebaseMessaging", (String)"Failed to send big query analytics payload.", (Throwable)runtimeException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    static void logToScion(String string, Bundle object) {
        CharSequence charSequence;
        Bundle bundle;
        block16: {
            block15: {
                try {
                    FirebaseApp.getInstance();
                    if (object != null) break block15;
                }
                catch (IllegalStateException illegalStateException) {
                    Log.e((String)"FirebaseMessaging", (String)"Default FirebaseApp has not been initialized. Skip logging event to GA.");
                    return;
                }
                object = new Bundle();
            }
            bundle = new Bundle();
            charSequence = MessagingAnalytics.getComposerId((Bundle)object);
            if (charSequence != null) {
                bundle.putString("_nmid", (String)charSequence);
            }
            if ((charSequence = MessagingAnalytics.getComposerLabel((Bundle)object)) != null) {
                bundle.putString("_nmn", (String)charSequence);
            }
            if (!TextUtils.isEmpty((CharSequence)(charSequence = MessagingAnalytics.getMessageLabel((Bundle)object)))) {
                bundle.putString("label", (String)charSequence);
            }
            if (!TextUtils.isEmpty((CharSequence)(charSequence = MessagingAnalytics.getMessageChannel((Bundle)object)))) {
                bundle.putString("message_channel", (String)charSequence);
            }
            if ((charSequence = MessagingAnalytics.getTopic((Bundle)object)) != null) {
                bundle.putString("_nt", (String)charSequence);
            }
            if ((charSequence = MessagingAnalytics.getMessageTime((Bundle)object)) == null) break block16;
            try {
                bundle.putInt("_nmt", Integer.parseInt((String)charSequence));
            }
            catch (NumberFormatException numberFormatException) {
                Log.w((String)"FirebaseMessaging", (String)"Error while parsing timestamp in GCM event", (Throwable)numberFormatException);
            }
        }
        if ((charSequence = MessagingAnalytics.getUseDeviceTime((Bundle)object)) != null) {
            try {
                bundle.putInt("_ndt", Integer.parseInt((String)charSequence));
            }
            catch (NumberFormatException numberFormatException) {
                Log.w((String)"FirebaseMessaging", (String)"Error while parsing use_device_time in GCM event", (Throwable)numberFormatException);
            }
        }
        object = MessagingAnalytics.getMessageTypeForScion((Bundle)object);
        if ("_nr".equals(string) || "_nf".equals(string)) {
            bundle.putString("_nmc", (String)object);
        }
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            object = bundle.toString();
            charSequence = new StringBuilder(string.length() + 37 + ((String)object).length());
            ((StringBuilder)charSequence).append("Logging to scion event=");
            ((StringBuilder)charSequence).append(string);
            ((StringBuilder)charSequence).append(" scionPayload=");
            ((StringBuilder)charSequence).append((String)object);
            Log.d((String)"FirebaseMessaging", (String)((StringBuilder)charSequence).toString());
        }
        if ((object = (AnalyticsConnector)FirebaseApp.getInstance().get(AnalyticsConnector.class)) != null) {
            object.logEvent("fcm", string, bundle);
            return;
        }
        Log.w((String)"FirebaseMessaging", (String)"Unable to log event: analytics library is missing");
    }

    static void setDeliveryMetricsExportToBigQuery(boolean bl) {
        FirebaseApp.getInstance().getApplicationContext().getSharedPreferences("com.google.firebase.messaging", 0).edit().putBoolean("export_to_big_query", bl).apply();
    }

    private static void setUserPropertyIfRequired(Bundle object) {
        if (object == null) {
            return;
        }
        if ("1".equals(object.getString("google.c.a.tc"))) {
            AnalyticsConnector analyticsConnector = (AnalyticsConnector)FirebaseApp.getInstance().get(AnalyticsConnector.class);
            if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
                Log.d((String)"FirebaseMessaging", (String)"Received event with track-conversion=true. Setting user property and reengagement event");
            }
            if (analyticsConnector != null) {
                object = object.getString("google.c.a.c_id");
                analyticsConnector.setUserProperty("fcm", "_ln", object);
                Bundle bundle = new Bundle();
                bundle.putString("source", "Firebase");
                bundle.putString("medium", "notification");
                bundle.putString("campaign", (String)object);
                analyticsConnector.logEvent("fcm", "_cmp", bundle);
                return;
            }
            Log.w((String)"FirebaseMessaging", (String)"Unable to set user property for conversion tracking:  analytics library is missing");
            return;
        }
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            Log.d((String)"FirebaseMessaging", (String)"Received event with track-conversion=false. Do not set user property");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean deliveryMetricsExportToBigQueryEnabled() {
        try {
            FirebaseApp.getInstance();
        }
        catch (IllegalStateException illegalStateException) {
            Log.i((String)"FirebaseMessaging", (String)"FirebaseApp has not being initialized. Device might be in direct boot mode. Skip exporting delivery metrics to Big Query");
            return false;
        }
        Context context = FirebaseApp.getInstance().getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.firebase.messaging", 0);
        if (sharedPreferences.contains("export_to_big_query")) {
            return sharedPreferences.getBoolean("export_to_big_query", false);
        }
        try {}
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
        sharedPreferences = context.getPackageManager();
        if (sharedPreferences == null) return false;
        if ((context = sharedPreferences.getApplicationInfo(context.getPackageName(), 128)) == null) return false;
        sharedPreferences = context.metaData;
        if (sharedPreferences == null) return false;
        boolean bl = context.metaData.containsKey("delivery_metrics_exported_to_big_query_enabled");
        if (!bl) return false;
        return context.metaData.getBoolean("delivery_metrics_exported_to_big_query_enabled", false);
    }

    private static boolean isDirectBootMessage(Intent intent) {
        return "com.google.firebase.messaging.RECEIVE_DIRECT_BOOT".equals(intent.getAction());
    }

    public static boolean shouldUploadFirelogAnalytics(@NonNull Intent intent) {
        Intent intent2;
        if (intent == null || MessagingAnalytics.isDirectBootMessage(intent2)) {
            return false;
        }
        return MessagingAnalytics.deliveryMetricsExportToBigQueryEnabled();
    }

    public static boolean shouldUploadScionMetrics(@NonNull Intent intent) {
        Intent intent2;
        if (intent == null || MessagingAnalytics.isDirectBootMessage(intent2)) {
            return false;
        }
        return MessagingAnalytics.shouldUploadScionMetrics(intent2.getExtras());
    }

    public static boolean shouldUploadScionMetrics(@NonNull Bundle extras) {
        Bundle bundle;
        if (extras == null) {
            return false;
        }
        return "1".equals(bundle.getString("google.c.a.e"));
    }
}

