/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_ml;

import com.google.android.gms.internal.firebase_ml.zzil;
import com.google.android.gms.internal.firebase_ml.zzir;
import com.google.android.gms.internal.firebase_ml.zzis;
import com.google.android.gms.internal.firebase_ml.zziw;
import com.google.android.gms.internal.firebase_ml.zziy;
import com.google.android.gms.internal.firebase_ml.zziz;
import com.google.android.gms.internal.firebase_ml.zzjo;
import com.google.android.gms.internal.firebase_ml.zzmf;
import com.google.android.gms.internal.firebase_ml.zzmn;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public final class zzit {
    private static final Boolean zzaef = new Boolean(true);
    private static final String zzaeg = new String();
    private static final Character zzaeh = new Character('\u0000');
    private static final Byte zzaei = new Byte(0);
    private static final Short zzaej = new Short(0);
    private static final Integer zzaek = new Integer(0);
    private static final Float zzael = new Float(0.0f);
    private static final Long zzaem = new Long(0L);
    private static final Double zzaen = new Double(0.0);
    private static final BigInteger zzaeo = new BigInteger("0");
    private static final BigDecimal zzaep = new BigDecimal("0");
    private static final zziw zzaeq = new zziw(0L);
    private static final ConcurrentHashMap<Class<?>, Object> zzaer = new ConcurrentHashMap<Class<Boolean>, Boolean>();

    public static <T> T zzd(Class<?> clazz) {
        Object object = zzaer.get(clazz);
        if (object == null) {
            Object object2;
            Class<?> clazz2 = clazz;
            if (clazz2.isArray()) {
                int n = 0;
                Class<?> clazz3 = clazz2;
                do {
                    clazz3 = clazz3.getComponentType();
                    ++n;
                } while (clazz3.isArray());
                object2 = Array.newInstance(clazz3, new int[n]);
            } else if (clazz2.isEnum()) {
                zziz zziz2 = zzir.zzc(clazz2).zzan(null);
                Object[] objectArray = new Object[]{clazz2};
                String string = "enum missing constant with @NullValue annotation: %s";
                Object[] objectArray2 = objectArray;
                String string2 = "enum missing constant with @NullValue annotation: %s";
                if (zziz2 == null) {
                    throw new NullPointerException(zzmn.zzb(string2, objectArray2));
                }
                object2 = zziz2.zzib();
            } else {
                object2 = zzjo.zzf(clazz2);
            }
            Object obj = object2;
            object = zzaer.putIfAbsent(clazz, obj);
            if (object == null) {
                object = obj;
            }
        }
        return (T)object;
    }

    public static boolean isNull(Object object) {
        return object != null && object == zzaer.get(object.getClass());
    }

    public static Map<String, Object> zzf(Object object) {
        if (object == null || zzit.isNull(object)) {
            return Collections.emptyMap();
        }
        if (object instanceof Map) {
            return (Map)object;
        }
        return new zzis(object, false);
    }

    public static <T> T clone(T t) {
        Object object;
        if (t == null || zzit.zza(t.getClass())) {
            return t;
        }
        if (t instanceof zziy) {
            return (T)((zziy)((zziy)t).clone());
        }
        Class<?> clazz = t.getClass();
        if (clazz.isArray()) {
            object = Array.newInstance(clazz.getComponentType(), Array.getLength(t));
        } else if (t instanceof zzil) {
            object = (zzil)((zzil)t).clone();
        } else {
            if ("java.util.Arrays$ArrayList".equals(clazz.getName())) {
                Object[] objectArray = ((List)t).toArray();
                zzit.zza(objectArray, objectArray);
                return (T)Arrays.asList(objectArray);
            }
            object = zzjo.zzf(clazz);
        }
        zzit.zza(t, object);
        return (T)object;
    }

    public static void zza(Object object, Object object2) {
        Class<?> clazz = object.getClass();
        zzmf.checkArgument(clazz == object2.getClass());
        if (clazz.isArray()) {
            zzmf.checkArgument(Array.getLength(object) == Array.getLength(object2));
            int n = 0;
            for (Object t : zzjo.zzi(object)) {
                Array.set(object2, n++, zzit.clone(t));
            }
            return;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            Collection collection = (Collection)object;
            if (ArrayList.class.isAssignableFrom(clazz)) {
                ((ArrayList)object2).ensureCapacity(collection.size());
            }
            Collection collection2 = (Collection)object2;
            for (Object e : collection) {
                collection2.add(zzit.clone(e));
            }
            return;
        }
        boolean bl = zziy.class.isAssignableFrom(clazz);
        if (bl || !Map.class.isAssignableFrom(clazz)) {
            zzir zzir2 = bl ? ((zziy)object).zzzm : zzir.zzc(clazz);
            for (String string : zzir2.zzaee) {
                Object object3;
                zziz zziz2 = zzir2.zzan(string);
                if (zziz2.zzia() || bl && zziz2.isPrimitive() || (object3 = zziz2.zzh(object)) == null) continue;
                zziz2.zzb(object2, zzit.clone(object3));
            }
            return;
        }
        if (zzil.class.isAssignableFrom(clazz)) {
            zzil zzil2 = (zzil)object2;
            zzil zzil3 = (zzil)object;
            int n = zzil3.size();
            for (int i = 0; i < n; ++i) {
                Object v = zzil3.zzaj(i);
                zzil2.set(i, zzit.clone(v));
            }
            return;
        }
        Map map = (Map)object2;
        for (Map.Entry entry : ((Map)object).entrySet()) {
            map.put((String)entry.getKey(), zzit.clone(entry.getValue()));
        }
    }

    public static boolean zza(Type type) {
        if (type instanceof WildcardType) {
            type = zzjo.zza((WildcardType)type);
        }
        if (!(type instanceof Class)) {
            return false;
        }
        Class clazz = (Class)type;
        return clazz.isPrimitive() || clazz == Character.class || clazz == String.class || clazz == Integer.class || clazz == Long.class || clazz == Short.class || clazz == Byte.class || clazz == Float.class || clazz == Double.class || clazz == BigInteger.class || clazz == BigDecimal.class || clazz == zziw.class || clazz == Boolean.class;
    }

    public static boolean zzg(Object object) {
        return object == null || zzit.zza(object.getClass());
    }

    public static Object zza(Type type, String string) {
        Class clazz;
        Class clazz2 = clazz = type instanceof Class ? (Class)type : null;
        if (type == null || clazz != null) {
            if (clazz == Void.class) {
                return null;
            }
            if (string == null || clazz == null || clazz.isAssignableFrom(String.class)) {
                return string;
            }
            if (clazz == Character.class || clazz == Character.TYPE) {
                if (string.length() != 1) {
                    String string2 = String.valueOf(clazz);
                    throw new IllegalArgumentException(new StringBuilder(37 + String.valueOf(string2).length()).append("expected type Character/char but got ").append(string2).toString());
                }
                return Character.valueOf(string.charAt(0));
            }
            if (clazz == Boolean.class || clazz == Boolean.TYPE) {
                return Boolean.valueOf(string);
            }
            if (clazz == Byte.class || clazz == Byte.TYPE) {
                return Byte.valueOf(string);
            }
            if (clazz == Short.class || clazz == Short.TYPE) {
                return Short.valueOf(string);
            }
            if (clazz == Integer.class || clazz == Integer.TYPE) {
                return Integer.valueOf(string);
            }
            if (clazz == Long.class || clazz == Long.TYPE) {
                return Long.valueOf(string);
            }
            if (clazz == Float.class || clazz == Float.TYPE) {
                return Float.valueOf(string);
            }
            if (clazz == Double.class || clazz == Double.TYPE) {
                return Double.valueOf(string);
            }
            if (clazz == zziw.class) {
                return zziw.zzao(string);
            }
            if (clazz == BigInteger.class) {
                return new BigInteger(string);
            }
            if (clazz == BigDecimal.class) {
                return new BigDecimal(string);
            }
            if (clazz.isEnum()) {
                if (!zzir.zzc(clazz).zzaee.contains(string)) {
                    throw new IllegalArgumentException(String.format("given enum name %s not part of enumeration", string));
                }
                return zzir.zzc(clazz).zzan(string).zzib();
            }
        }
        String string3 = String.valueOf(type);
        throw new IllegalArgumentException(new StringBuilder(35 + String.valueOf(string3).length()).append("expected primitive class, but got: ").append(string3).toString());
    }

    public static Collection<Object> zzb(Type type) {
        Class clazz;
        if (type instanceof WildcardType) {
            type = zzjo.zza((WildcardType)type);
        }
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getRawType();
        }
        Class clazz2 = clazz = type instanceof Class ? (Class)type : null;
        if (type == null || type instanceof GenericArrayType || clazz != null && (clazz.isArray() || clazz.isAssignableFrom(ArrayList.class))) {
            return new ArrayList<Object>();
        }
        if (clazz == null) {
            String string = String.valueOf(type);
            throw new IllegalArgumentException(new StringBuilder(39 + String.valueOf(string).length()).append("unable to create new instance of type: ").append(string).toString());
        }
        if (clazz.isAssignableFrom(HashSet.class)) {
            return new HashSet<Object>();
        }
        if (clazz.isAssignableFrom(TreeSet.class)) {
            return new TreeSet<Object>();
        }
        return (Collection)zzjo.zzf(clazz);
    }

    public static Map<String, Object> zze(Class<?> clazz) {
        if (clazz == null || clazz.isAssignableFrom(zzil.class)) {
            return new zzil<String, Object>();
        }
        if (clazz.isAssignableFrom(TreeMap.class)) {
            return new TreeMap<String, Object>();
        }
        return (Map)zzjo.zzf(clazz);
    }

    public static Type zza(List<Type> list, Type type) {
        if (type instanceof WildcardType) {
            type = zzjo.zza((WildcardType)type);
        }
        while (type instanceof TypeVariable) {
            Type type2 = zzjo.zza(list, (TypeVariable)type);
            if (type2 != null) {
                type = type2;
            }
            if (!(type instanceof TypeVariable)) continue;
            type = ((TypeVariable)type).getBounds()[0];
        }
        return type;
    }

    static {
        zzaer.put(Boolean.class, zzaef);
        zzaer.put(String.class, zzaeg);
        zzaer.put(Character.class, zzaeh);
        zzaer.put(Byte.class, zzaei);
        zzaer.put(Short.class, zzaej);
        zzaer.put(Integer.class, zzaek);
        zzaer.put(Float.class, zzael);
        zzaer.put(Long.class, zzaem);
        zzaer.put(Double.class, zzaen);
        zzaer.put(BigInteger.class, zzaeo);
        zzaer.put(BigDecimal.class, zzaep);
        zzaer.put(zziw.class, zzaeq);
    }
}

