/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_ml;

import com.google.android.gms.internal.firebase_ml.zzmf;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class zzjb
extends ByteArrayOutputStream {
    private int zzafp;
    private final int zzafq;
    private boolean closed;
    private final Level zzafr;
    private final Logger logger;

    public zzjb(Logger logger, Level level, int n) {
        this.logger = zzmf.checkNotNull(logger);
        this.zzafr = zzmf.checkNotNull(level);
        zzmf.checkArgument(n >= 0);
        this.zzafq = n;
    }

    @Override
    public final synchronized void write(int n) {
        zzmf.checkArgument(!this.closed);
        ++this.zzafp;
        if (this.count < this.zzafq) {
            super.write(n);
        }
    }

    @Override
    public final synchronized void write(byte[] byArray, int n, int n2) {
        zzmf.checkArgument(!this.closed);
        this.zzafp += n2;
        if (this.count < this.zzafq) {
            int n3 = this.count + n2;
            if (n3 > this.zzafq) {
                n2 += this.zzafq - n3;
            }
            super.write(byArray, n, n2);
        }
    }

    @Override
    public final synchronized void close() throws IOException {
        if (!this.closed) {
            if (this.zzafp != 0) {
                StringBuilder stringBuilder = new StringBuilder("Total: ");
                zzjb.zza(stringBuilder, this.zzafp);
                if (this.count != 0 && this.count < this.zzafp) {
                    stringBuilder.append(" (logging first ");
                    zzjb.zza(stringBuilder, this.count);
                    stringBuilder.append(")");
                }
                this.logger.logp(Level.CONFIG, "com.google.api.client.util.LoggingByteArrayOutputStream", "close", stringBuilder.toString());
                if (this.count != 0) {
                    this.logger.logp(this.zzafr, "com.google.api.client.util.LoggingByteArrayOutputStream", "close", this.toString("UTF-8").replaceAll("[\\x00-\\x09\\x0B\\x0C\\x0E-\\x1F\\x7F]", " "));
                }
            }
            this.closed = true;
        }
    }

    private static void zza(StringBuilder stringBuilder, int n) {
        if (n == 1) {
            stringBuilder.append("1 byte");
            return;
        }
        stringBuilder.append(NumberFormat.getInstance().format(n)).append(" bytes");
    }
}

