/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_ml;

import com.google.android.gms.internal.firebase_ml.zzuk;
import com.google.android.gms.internal.firebase_ml.zzvy;
import com.google.android.gms.internal.firebase_ml.zzwh;
import com.google.android.gms.internal.firebase_ml.zzxs;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzvi
extends zzuk<Double>
implements zzwh<Double>,
zzxs,
RandomAccess {
    private static final zzvi zzbzx = new zzvi(new double[0], 0);
    private double[] zzbzy;
    private int size;

    zzvi() {
        this(new double[10], 0);
    }

    private zzvi(double[] dArray, int n) {
        this.zzbzy = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzsq();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzbzy, n2, this.zzbzy, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzvi)) {
            return super.equals(object);
        }
        zzvi zzvi2 = (zzvi)object;
        if (this.size != zzvi2.size) {
            return false;
        }
        double[] dArray = zzvi2.zzbzy;
        for (int i = 0; i < this.size; ++i) {
            if (Double.doubleToLongBits(this.zzbzy[i]) == Double.doubleToLongBits(dArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzbzy[i]);
            n = n * 31 + zzvy.zzaf(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zze(double d) {
        this.zzsq();
        if (this.size == this.zzbzy.length) {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzbzy, 0, dArray, 0, this.size);
            this.zzbzy = dArray;
        }
        this.zzbzy[this.size++] = d;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzsq();
        zzvy.checkNotNull(collection);
        if (!(collection instanceof zzvi)) {
            return super.addAll(collection);
        }
        zzvi zzvi2 = (zzvi)collection;
        if (zzvi2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzvi2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzvi2.size;
        if (n > this.zzbzy.length) {
            this.zzbzy = Arrays.copyOf(this.zzbzy, n);
        }
        System.arraycopy(zzvi2.zzbzy, 0, this.zzbzy, this.size, zzvi2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzsq();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzbzy[i])) continue;
            System.arraycopy(this.zzbzy, i + 1, this.zzbzy, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzcp(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzcq(n));
        }
    }

    private final String zzcq(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzvi zzvi2 = this;
        zzvi2.zzsq();
        zzvi2.zzcp(n);
        double d3 = zzvi2.zzbzy[n];
        zzvi2.zzbzy[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzvi zzvi2 = this;
        zzvi2.zzsq();
        zzvi2.zzcp(n);
        double d = zzvi2.zzbzy[n];
        if (n < zzvi2.size - 1) {
            System.arraycopy(zzvi2.zzbzy, n + 1, zzvi2.zzbzy, n, zzvi2.size - n - 1);
        }
        --zzvi2.size;
        ++zzvi2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzvi zzvi2 = this;
        zzvi2.zzsq();
        if (n < 0 || n > zzvi2.size) {
            throw new IndexOutOfBoundsException(zzvi2.zzcq(n));
        }
        if (zzvi2.size < zzvi2.zzbzy.length) {
            System.arraycopy(zzvi2.zzbzy, n, zzvi2.zzbzy, n + 1, zzvi2.size - n);
        } else {
            double[] dArray = new double[zzvi2.size * 3 / 2 + 1];
            System.arraycopy(zzvi2.zzbzy, 0, dArray, 0, n);
            System.arraycopy(zzvi2.zzbzy, n, dArray, n + 1, zzvi2.size - n);
            zzvi2.zzbzy = dArray;
        }
        zzvi2.zzbzy[n] = d2;
        ++zzvi2.size;
        ++zzvi2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Double d = (Double)object;
        this.zze(d);
        return true;
    }

    @Override
    public final /* synthetic */ zzwh zzcr(int n) {
        int n2 = n;
        zzvi zzvi2 = this;
        if (n2 < zzvi2.size) {
            throw new IllegalArgumentException();
        }
        return new zzvi(Arrays.copyOf(zzvi2.zzbzy, n2), zzvi2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzvi zzvi2 = this;
        zzvi2.zzcp(n);
        return zzvi2.zzbzy[n];
    }

    static {
        zzbzx.zzsp();
    }
}

