/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.ml.common.internal.modeldownload;

import android.os.ParcelFileDescriptor;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.GmsLogger;
import com.google.android.gms.internal.firebase_ml.zzng;
import com.google.android.gms.internal.firebase_ml.zznq;
import com.google.android.gms.internal.firebase_ml.zzpn;
import com.google.android.gms.internal.firebase_ml.zzqc;
import com.google.firebase.ml.common.FirebaseMLException;
import com.google.firebase.ml.common.internal.modeldownload.zzaf;
import com.google.firebase.ml.common.internal.modeldownload.zzg;
import com.google.firebase.ml.common.internal.modeldownload.zzi;
import com.google.firebase.ml.common.internal.modeldownload.zzn;
import com.google.firebase.ml.common.internal.modeldownload.zzp;
import com.google.firebase.ml.common.internal.modeldownload.zzv;
import com.google.firebase.ml.common.internal.modeldownload.zzw;
import com.google.firebase.ml.common.internal.modeldownload.zzz;
import com.google.firebase.ml.common.modeldownload.FirebaseRemoteModel;
import java.io.File;
import java.nio.MappedByteBuffer;
import java.util.HashMap;
import java.util.Map;

public final class zzag {
    private static final GmsLogger zzbbo = new GmsLogger("RemoteModelLoader", "");
    @GuardedBy(value="RemoteModelLoader.class")
    private static final Map<String, zzag> zzbew = new HashMap<String, zzag>();
    private final zzpn zzbdc;
    private final FirebaseRemoteModel zzbfa;
    private final zzv zzbfo;
    private final zzz zzbfp;
    private final zzw zzbfb;
    private final zzaf zzbfq;
    private final zzn zzbfi;
    private boolean zzbfr;

    private zzag(@NonNull zzpn zzpn2, @NonNull FirebaseRemoteModel firebaseRemoteModel, @NonNull zzp zzp2, @NonNull zzaf zzaf2, @NonNull zzn zzn2) {
        this.zzbfp = new zzz(zzpn2, firebaseRemoteModel, zzp2, zzn2, new zzi(zzpn2));
        this.zzbfr = true;
        this.zzbfb = new zzw(zzpn2, firebaseRemoteModel);
        this.zzbfo = zzv.zza(zzpn2, firebaseRemoteModel, new zzg(zzpn2), this.zzbfb);
        this.zzbfq = zzaf2;
        this.zzbdc = zzpn2;
        this.zzbfa = firebaseRemoteModel;
        this.zzbfi = zzn2;
    }

    public static synchronized zzag zza(@NonNull zzpn zzpn2, @NonNull FirebaseRemoteModel firebaseRemoteModel, @NonNull zzp zzp2, zzaf zzaf2, zzn zzn2) {
        String string = firebaseRemoteModel.getUniqueModelNameForPersist();
        if (!zzbew.containsKey(string)) {
            zzag zzag2 = new zzag(zzpn2, firebaseRemoteModel, zzp2, zzaf2, zzn2);
            zzbew.put(string, zzag2);
        }
        return zzbew.get(string);
    }

    @Nullable
    @WorkerThread
    public final synchronized MappedByteBuffer load() throws FirebaseMLException {
        zzbbo.d("RemoteModelLoader", "Try to load newly downloaded model file.");
        MappedByteBuffer mappedByteBuffer = this.zzat(this.zzbfr);
        if (mappedByteBuffer == null) {
            zzbbo.d("RemoteModelLoader", "Loading existing model file.");
            mappedByteBuffer = this.zzox();
        }
        return mappedByteBuffer;
    }

    public final FirebaseRemoteModel zzow() {
        return this.zzbfa;
    }

    @Nullable
    @WorkerThread
    private final MappedByteBuffer zzat(boolean bl) throws FirebaseMLException {
        Long l = this.zzbfo.zzoi();
        String string = this.zzbfo.zzoj();
        if (l == null || string == null) {
            zzbbo.d("RemoteModelLoader", "No new model is downloading.");
            this.zzbfo.zzok();
            return null;
        }
        Integer n = this.zzbfo.zzol();
        if (n == null) {
            this.zzbfo.zzok();
            return null;
        }
        String string2 = String.valueOf(n);
        zzbbo.d("RemoteModelLoader", new StringBuilder(22 + String.valueOf(string2).length()).append("Download Status code: ").append(string2).toString());
        if (n == 8) {
            File file;
            zzbbo.d("RemoteModelLoader", "Model downloaded successfully");
            this.zzbfb.zza(zznq.zzamr, true, this.zzbfi, zzng.zzag.zzb.zzauu);
            string2 = this.zzbfo.zzom();
            if (string2 == null) {
                this.zzbfo.zzok();
                return null;
            }
            zzbbo.d("RemoteModelLoader", "moving downloaded model from external storage to private folder.");
            try {
                file = this.zzbfp.zza((ParcelFileDescriptor)string2, string, this.zzbfb);
            }
            finally {
                this.zzbfo.zzok();
            }
            if (file == null) {
                return null;
            }
            MappedByteBuffer mappedByteBuffer = this.zzg(file);
            String string3 = String.valueOf(file.getParent());
            zzbbo.d("RemoteModelLoader", string3.length() != 0 ? "Moved the downloaded model to private folder successfully: ".concat(string3) : new String("Moved the downloaded model to private folder successfully: "));
            this.zzbfo.zze(string, this.zzbfi);
            if (bl && this.zzbfp.zzd(file)) {
                zzbbo.d("RemoteModelLoader", "All old models are deleted.");
                file = this.zzbfp.zzf(file);
                mappedByteBuffer = this.zzg(file);
            }
            return mappedByteBuffer;
        }
        if (n == 16) {
            this.zzbfb.zza(false, this.zzbfi, this.zzbfo.zza(l));
            this.zzbfo.zzok();
        }
        return null;
    }

    private final MappedByteBuffer zzg(File file) throws FirebaseMLException {
        try {
            return this.zzbz(file.getAbsolutePath());
        }
        catch (Exception exception) {
            this.zzbfp.zze(file);
            throw new FirebaseMLException("Failed to load newly downloaded model.", 14, exception);
        }
    }

    @Nullable
    @WorkerThread
    private final MappedByteBuffer zzox() throws FirebaseMLException {
        MappedByteBuffer mappedByteBuffer;
        String string = this.zzbfp.zzot();
        if (string == null) {
            zzbbo.d("RemoteModelLoader", "No existing model file");
            return null;
        }
        try {
            mappedByteBuffer = this.zzbz(string);
        }
        catch (Exception exception) {
            this.zzbfp.zze(new File(string));
            zzqc.zzb(this.zzbdc).zzi(this.zzbfa);
            throw new FirebaseMLException("Failed to load an already downloaded model.", 14, exception);
        }
        return mappedByteBuffer;
    }

    @WorkerThread
    @NonNull
    private final MappedByteBuffer zzbz(@NonNull String string) throws FirebaseMLException {
        return this.zzbfq.zzby(string);
    }
}

