/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.ml.common.internal.modeldownload;

import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.GmsLogger;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase_ml.zzpn;
import com.google.firebase.ml.common.FirebaseMLException;
import com.google.firebase.ml.common.internal.modeldownload.zza;
import com.google.firebase.ml.common.internal.modeldownload.zzn;
import java.io.File;

public final class zzi {
    private static final GmsLogger zzbbo = new GmsLogger("ModelFileHelper", "");
    @VisibleForTesting
    private static final String zzbdx = String.format("com.google.firebase.ml.%s.models", "custom");
    @VisibleForTesting
    private static final String zzbdy = String.format("com.google.firebase.ml.%s.models", "automl");
    @VisibleForTesting
    private static final String zzbdz = String.format("com.google.firebase.ml.%s.models", "base");
    @VisibleForTesting
    private static final String zzbea = String.format("com.google.firebase.ml.%s.models", "translate");
    private final zzpn zzbdc;

    public zzi(zzpn zzpn2) {
        this.zzbdc = zzpn2;
    }

    public final void zza(String string, zzn zzn2) throws FirebaseMLException {
        if (zzn2 != zzn.zzbeh) {
            return;
        }
        File file = zza.zza(this.zzbdc, string).getParentFile();
        if (!this.zzc(file)) {
            String string2 = String.valueOf(file != null ? file.getAbsolutePath() : null);
            zzbbo.e("ModelFileHelper", string2.length() != 0 ? "Failed to delete the temp labels file directory: ".concat(string2) : new String("Failed to delete the temp labels file directory: "));
        }
    }

    public final boolean zzb(String string, zzn zzn2) throws FirebaseMLException {
        String string2;
        if (zzn2 == zzn.zzbef) {
            return false;
        }
        zzn zzn3 = zzn2;
        String string3 = string;
        zzn zzn4 = zzn3;
        String string4 = string3;
        File file = this.zza(string3, zzn4, false);
        int n = zzi.zzb(file);
        if (n == -1) {
            string2 = null;
        } else {
            String string5 = file.getAbsolutePath();
            string2 = new StringBuilder(12 + String.valueOf(string5).length()).append(string5).append("/").append(n).toString();
        }
        return string2 != null;
    }

    @WorkerThread
    final File zzc(@NonNull String string, zzn zzn2) throws FirebaseMLException {
        return this.zza(string, zzn2, false);
    }

    @WorkerThread
    private final File zza(@NonNull String string, @NonNull zzn zzn2, boolean bl) throws FirebaseMLException {
        File file = this.zzb(string, zzn2, bl);
        if (!file.exists()) {
            String string2 = String.valueOf(file.getAbsolutePath());
            zzbbo.d("ModelFileHelper", string2.length() != 0 ? "model folder does not exist, creating one: ".concat(string2) : new String("model folder does not exist, creating one: "));
            if (!file.mkdirs()) {
                String string3 = String.valueOf(file);
                throw new FirebaseMLException(new StringBuilder(31 + String.valueOf(string3).length()).append("Failed to create model folder: ").append(string3).toString(), 13);
            }
        } else if (!file.isDirectory()) {
            String string4 = String.valueOf(file);
            throw new FirebaseMLException(new StringBuilder(71 + String.valueOf(string4).length()).append("Can not create model folder, since an existing file has the same name: ").append(string4).toString(), 6);
        }
        return file;
    }

    public final File zzb(@NonNull String string, @NonNull zzn zzn2, boolean bl) {
        String string2;
        switch (zzn2) {
            case zzbei: {
                string2 = zzbdx;
                break;
            }
            case zzbeg: {
                string2 = zzbdz;
                break;
            }
            case zzbeh: {
                string2 = zzbdy;
                break;
            }
            case zzbej: {
                string2 = zzbea;
                break;
            }
            default: {
                String string3 = zzn2.name();
                throw new IllegalArgumentException(new StringBuilder(69 + String.valueOf(string3).length()).append("Unknown model type ").append(string3).append(". Cannot find a dir to store the downloaded model.").toString());
            }
        }
        File file = Build.VERSION.SDK_INT >= 21 ? new File(this.zzbdc.getApplicationContext().getNoBackupFilesDir(), string2) : this.zzbdc.getApplicationContext().getDir(string2, 0);
        if (bl) {
            file = new File(file, "temp");
        }
        File file2 = new File(file, this.zzbdc.getPersistenceKey());
        return new File(file2, string);
    }

    @WorkerThread
    public final synchronized void zza(zzn zzn2, String string) {
        File file = this.zzb(string, zzn2, false);
        this.zzc(file);
        file = this.zzb(string, zzn2, true);
        this.zzc(file);
    }

    @WorkerThread
    final File zzd(@NonNull String string, @NonNull zzn zzn2) throws FirebaseMLException {
        return this.zza(string, zzn2, true);
    }

    @WorkerThread
    static int zzb(@NonNull File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return -1;
        }
        int n = -1;
        File[] fileArray2 = fileArray;
        int n2 = fileArray.length;
        for (int i = 0; i < n2; ++i) {
            File file2 = fileArray2[i];
            try {
                n = Math.max(n, Integer.parseInt(file2.getName()));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                String string = String.valueOf(file2.getName());
                zzbbo.d("ModelFileHelper", string.length() != 0 ? "Contains non-integer file name ".concat(string) : new String("Contains non-integer file name "));
            }
        }
        return n;
    }

    final boolean zzc(@Nullable File file) {
        if (file == null) {
            return false;
        }
        boolean bl = true;
        if (file.isDirectory()) {
            for (File file2 : (File[])Preconditions.checkNotNull((Object)file.listFiles())) {
                bl = bl && this.zzc(file2);
            }
        }
        return bl && file.delete();
    }
}

