/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.ml.common.internal.modeldownload;

import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.GmsLogger;
import com.google.android.gms.common.util.IOUtils;
import com.google.android.gms.internal.firebase_ml.zzng;
import com.google.android.gms.internal.firebase_ml.zznq;
import com.google.android.gms.internal.firebase_ml.zzpn;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.ml.common.FirebaseMLException;
import com.google.firebase.ml.common.internal.modeldownload.zza;
import com.google.firebase.ml.common.internal.modeldownload.zzaa;
import com.google.firebase.ml.common.internal.modeldownload.zzad;
import com.google.firebase.ml.common.internal.modeldownload.zzn;
import com.google.firebase.ml.common.internal.modeldownload.zzw;
import com.google.firebase.ml.common.modeldownload.FirebaseRemoteModel;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@WorkerThread
final class zzu {
    private static final GmsLogger zzbbo = new GmsLogger("ModelInfoRetriever", "");

    @Nullable
    static zzaa zza(@NonNull zzpn zzpn2, @NonNull FirebaseApp firebaseApp, @NonNull FirebaseRemoteModel firebaseRemoteModel, @NonNull zzw zzw2) throws FirebaseMLException {
        HttpsURLConnection httpsURLConnection = zzad.zza(zzu.zza(firebaseApp, firebaseRemoteModel.getModelNameForBackend(), zzw2), zzw2);
        if (httpsURLConnection == null) {
            return null;
        }
        String string = httpsURLConnection.getHeaderField("Content-Location");
        String string2 = httpsURLConnection.getHeaderField("ETag");
        String string3 = String.valueOf(string);
        zzbbo.d("ModelInfoRetriever", string3.length() != 0 ? "Received download URL: ".concat(string3) : new String("Received download URL: "));
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            zzw2.zza(zznq.zzang, false, zzn.zzbef, zzng.zzag.zzb.zzaur);
            throw new FirebaseMLException("No hash value for the custom model", 13);
        }
        firebaseRemoteModel.setModelHash(string2);
        try {
            InputStream inputStream = httpsURLConnection.getInputStream();
            Object object = new String(IOUtils.readInputStreamFully((InputStream)inputStream));
            object = TextUtils.isEmpty((CharSequence)object) ? "{}" : object;
            JSONObject jSONObject = new JSONObject((String)object);
            zzn zzn2 = jSONObject.has("inferenceInfo") ? zzn.zzbeh : zzn.zzbei;
            if (zzn2.equals((Object)zzn.zzbeh)) {
                JSONObject jSONObject2;
                JSONObject jSONObject3 = jSONObject2 = jSONObject.getJSONObject("inferenceInfo");
                FirebaseRemoteModel firebaseRemoteModel2 = firebaseRemoteModel;
                object = zzpn2;
                if (jSONObject3 != null) {
                    JSONArray jSONArray = jSONObject3.getJSONArray("labels");
                    if (jSONArray == null || jSONArray.length() == 0) {
                        throw new FirebaseMLException("Cannot parse AutoML model's labels from model downloading backend.", 13);
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (int i = 0; i < jSONArray.length(); ++i) {
                        arrayList.add(jSONArray.getString(i));
                    }
                    zza.zza((zzpn)object, firebaseRemoteModel2.getUniqueModelNameForPersist(), arrayList);
                }
            }
            return new zzaa(firebaseRemoteModel.getUniqueModelNameForPersist(), Uri.parse((String)string), string2, zzn2);
        }
        catch (IOException | JSONException throwable) {
            throw new FirebaseMLException("Failed to parse the model backend response message", 13, throwable);
        }
    }

    @VisibleForTesting
    @Nullable
    private static String zza(FirebaseApp firebaseApp, String string, @NonNull zzw zzw2) throws FirebaseMLException {
        String string2;
        String string3 = firebaseApp.getOptions().getGcmSenderId();
        if (string3 == null) {
            throw new FirebaseMLException("GCM sender id cannot be null in FirebaseOptions. Please configure FirebaseApp properly.", 9);
        }
        FirebaseInstanceId firebaseInstanceId = FirebaseInstanceId.getInstance((FirebaseApp)firebaseApp);
        if (firebaseInstanceId == null) {
            zzbbo.w("ModelInfoRetriever", "Cannot get a valid instance of FirebaseInstanceId. Cannot retrieve model info.");
            return null;
        }
        String string4 = firebaseInstanceId.getId();
        if (string4 == null) {
            zzbbo.w("ModelInfoRetriever", "Firebase instance id is null. Cannot retrieve model info.");
            return null;
        }
        try {
            string2 = firebaseInstanceId.getToken(string3, "*");
        }
        catch (IOException iOException) {
            zznq zznq2 = zznq.zzanh;
            String string5 = "Failed to get model URL";
            if (iOException instanceof UnknownHostException) {
                zznq2 = zznq.zzanc;
                string5 = "Failed to retrieve model info due to no internet connection.";
            }
            zzw2.zza(zznq2, false, zzn.zzbef, zzng.zzag.zzb.zzaur);
            throw new FirebaseMLException(string5, 13, iOException);
        }
        if (string2 == null) {
            zzbbo.w("ModelInfoRetriever", "Firebase instance token is null. Cannot retrieve model info.");
            return null;
        }
        return String.format("https://mlkit.googleapis.com/v1beta1/projects/%s/models/%s/versions/active?key=%s&app_instance_id=%s&app_instance_token=%s", firebaseApp.getOptions().getProjectId(), string, firebaseApp.getOptions().getApiKey(), string4, string2);
    }
}

