/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_ml;

import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase_ml.zzkd;
import com.google.android.gms.internal.firebase_ml.zzkq;
import com.google.android.gms.internal.firebase_ml.zzkr;
import com.google.android.gms.internal.firebase_ml.zzpc;
import com.google.android.gms.internal.firebase_ml.zzpg;
import com.google.android.gms.internal.firebase_ml.zzpj;
import com.google.android.gms.internal.firebase_ml.zzpn;
import com.google.android.gms.internal.firebase_ml.zzqx;
import com.google.android.gms.internal.firebase_ml.zzqy;
import com.google.android.gms.internal.firebase_ml.zzqz;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.ml.common.FirebaseMLException;
import com.google.firebase.ml.vision.cloud.FirebaseVisionCloudDetectorOptions;
import com.google.firebase.ml.vision.common.FirebaseVisionImage;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public abstract class zzra<ResultType>
implements Closeable {
    private final zzqz zzbki;
    private final zzkq zzbkj;
    private final zzpj zzbgn;
    private final zzkr imageContext;
    protected final zzpn zzbdc;

    protected zzra(@NonNull zzpn zzpn2, @NonNull String string, @NonNull FirebaseVisionCloudDetectorOptions firebaseVisionCloudDetectorOptions) {
        this(zzpn2, new zzkq().zza(firebaseVisionCloudDetectorOptions.getMaxResults()).zzax(string).zzaw(zzqy.zzbt(firebaseVisionCloudDetectorOptions.getModelType())), null, firebaseVisionCloudDetectorOptions.isEnforceCertFingerprintMatch());
    }

    protected zzra(@NonNull zzpn zzpn2, @NonNull String string, @NonNull zzkr zzkr2, boolean bl) {
        this(zzpn2, new zzkq().zzax(string).zzaw(zzqy.zzbt(1)), (zzkr)Preconditions.checkNotNull((Object)zzkr2, (Object)"ImageContext must not be null"), bl);
    }

    private zzra(@NonNull zzpn zzpn2, @NonNull zzkq zzkq2, @Nullable zzkr zzkr2, boolean bl) {
        Preconditions.checkNotNull((Object)zzpn2, (Object)"MlKitContext must not be null");
        Preconditions.checkNotNull((Object)zzpn2.getPersistenceKey(), (Object)"Firebase app name must not be null");
        this.zzbkj = (zzkq)Preconditions.checkNotNull((Object)zzkq2);
        this.zzbgn = zzpj.zza((zzpn)zzpn2);
        this.zzbki = new zzqz(this, zzpn2.zznq(), bl);
        this.zzbdc = zzpn2;
        this.imageContext = zzkr2;
    }

    protected abstract ResultType zza(@NonNull zzkd var1, float var2);

    protected abstract int zzpt();

    protected abstract int zzpu();

    public final Task<ResultType> zza(@NonNull FirebaseVisionImage firebaseVisionImage) {
        Preconditions.checkNotNull((Object)firebaseVisionImage, (Object)"Input image can not be null");
        Pair<byte[], Float> pair = firebaseVisionImage.zze(this.zzpt(), this.zzpu());
        if (pair.first == null) {
            return Tasks.forException((Exception)new FirebaseMLException("Can not convert the image format", 3));
        }
        List<zzkq> list = Collections.singletonList(this.zzbkj);
        return this.zzbgn.zza((zzpc)this.zzbki, (zzpg)new zzqx((byte[])pair.first, ((Float)pair.second).floatValue(), list, this.imageContext));
    }

    @Override
    public void close() throws IOException {
    }
}

