/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_ml;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.media.Image;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.internal.firebase_ml.zzmz;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class zzrh {
    private static final zzrh zzblh = new zzrh();

    private zzrh() {
    }

    public static zzrh zzpx() {
        return zzblh;
    }

    public static byte[] zza(@NonNull ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray, 0, byArray.length);
        return byArray;
    }

    public static byte[] zza(@NonNull byte[] byArray, int n, int n2) {
        YuvImage yuvImage = new YuvImage(byArray, 17, n, n2, null);
        byte[] byArray2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                yuvImage.compressToJpeg(new Rect(0, 0, n, n2), 100, (OutputStream)byteArrayOutputStream);
                byArray2 = byteArrayOutputStream.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Throwable throwable2) {
                    zzmz.zza((Throwable)throwable, (Throwable)throwable2);
                }
                throw throwable;
            }
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            Log.w((String)"ImageConvertUtils", (String)"Error closing ByteArrayOutputStream");
        }
        return byArray2;
    }

    public static byte[] zza(@NonNull Bitmap bitmap) {
        byte[] byArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)byteArrayOutputStream);
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Throwable throwable2) {
                    zzmz.zza((Throwable)throwable, (Throwable)throwable2);
                }
                throw throwable;
            }
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            Log.w((String)"ImageConvertUtils", (String)"Error closing ByteArrayOutputStream");
        }
        return byArray;
    }

    @TargetApi(value=19)
    public static ByteBuffer zza(Image.Plane[] planeArray, int n, int n2) {
        int n3 = n * n2;
        byte[] byArray = new byte[n3 + 2 * (n3 / 4)];
        int n4 = n2;
        int n5 = n;
        Image.Plane[] planeArray2 = planeArray;
        int n6 = n5 * n4;
        ByteBuffer byteBuffer = planeArray2[1].getBuffer();
        ByteBuffer byteBuffer2 = planeArray2[2].getBuffer();
        int n7 = byteBuffer2.position();
        int n8 = byteBuffer.limit();
        byteBuffer2.position(n7 + 1);
        byteBuffer.limit(n8 - 1);
        boolean bl = byteBuffer2.remaining() == 2 * n6 / 4 - 2 && byteBuffer2.compareTo(byteBuffer) == 0;
        byteBuffer2.position(n7);
        byteBuffer.limit(n8);
        if (bl) {
            planeArray[0].getBuffer().get(byArray, 0, n3);
            ByteBuffer byteBuffer3 = planeArray[1].getBuffer();
            planeArray[2].getBuffer().get(byArray, n3, 1);
            byteBuffer3.get(byArray, n3 + 1, 2 * n3 / 4 - 1);
        } else {
            zzrh.zza(planeArray[0], n, n2, byArray, 0, 1);
            zzrh.zza(planeArray[1], n, n2, byArray, n3 + 1, 2);
            zzrh.zza(planeArray[2], n, n2, byArray, n3, 2);
        }
        return ByteBuffer.wrap(byArray);
    }

    @TargetApi(value=19)
    private static void zza(Image.Plane plane, int n, int n2, byte[] byArray, int n3, int n4) {
        ByteBuffer byteBuffer = plane.getBuffer();
        int n5 = byteBuffer.position();
        int n6 = (byteBuffer.remaining() + plane.getRowStride() - 1) / plane.getRowStride();
        int n7 = n2 / n6;
        int n8 = n / n7;
        int n9 = n3;
        int n10 = 0;
        for (int i = 0; i < n6; ++i) {
            int n11 = n10;
            for (int j = 0; j < n8; ++j) {
                byArray[n9] = byteBuffer.get(n11);
                n9 += n4;
                n11 += plane.getPixelStride();
            }
            n10 += plane.getRowStride();
        }
        byteBuffer.position(n5);
    }

    public static byte[] zzf(byte[] byArray) {
        int n = byArray.length;
        int n2 = n / 6;
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n2 << 2);
        int n3 = n2 << 2;
        for (int i = 0; i < n2 << 1; ++i) {
            byArray2[n3 + i] = byArray[n3 + i % 2 * n2 + i / 2];
        }
        return byArray2;
    }
}

