/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_ml;

import android.content.Context;
import android.graphics.Rect;
import android.os.SystemClock;
import android.util.SparseArray;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.firebase_ml.zzng;
import com.google.android.gms.internal.firebase_ml.zznq;
import com.google.android.gms.internal.firebase_ml.zznu;
import com.google.android.gms.internal.firebase_ml.zzpc;
import com.google.android.gms.internal.firebase_ml.zzpn;
import com.google.android.gms.internal.firebase_ml.zzpo;
import com.google.android.gms.internal.firebase_ml.zzpu;
import com.google.android.gms.internal.firebase_ml.zzpw;
import com.google.android.gms.internal.firebase_ml.zzpx;
import com.google.android.gms.internal.firebase_ml.zzrf;
import com.google.android.gms.internal.firebase_ml.zzrg;
import com.google.android.gms.internal.firebase_ml.zzrl;
import com.google.android.gms.internal.firebase_ml.zzrn;
import com.google.android.gms.internal.firebase_ml.zzrp;
import com.google.android.gms.internal.firebase_ml.zzvx;
import com.google.android.gms.vision.face.Face;
import com.google.android.gms.vision.face.FaceDetector;
import com.google.firebase.ml.common.FirebaseMLException;
import com.google.firebase.ml.vision.face.FirebaseVisionFace;
import com.google.firebase.ml.vision.face.FirebaseVisionFaceDetectorOptions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public final class zzro
implements zzpc<List<FirebaseVisionFace>, zzrl>,
zzpx {
    private static volatile Boolean zzbmj = null;
    private final Context zzbdu;
    private final FirebaseVisionFaceDetectorOptions zzbmk;
    private final zzpo zzbfe;
    @VisibleForTesting
    private static AtomicBoolean zzbhb = new AtomicBoolean(true);
    @GuardedBy(value="this")
    private FaceDetector zzbml;
    @GuardedBy(value="this")
    private FaceDetector zzbmm;
    private final zzrg zzbjt = new zzrg();

    public zzro(@NonNull zzpn zzpn2, @NonNull FirebaseVisionFaceDetectorOptions firebaseVisionFaceDetectorOptions) {
        Preconditions.checkNotNull((Object)zzpn2, (Object)"MlKitContext can not be null");
        Preconditions.checkNotNull((Object)firebaseVisionFaceDetectorOptions, (Object)"FirebaseVisionFaceDetectorOptions can not be null");
        this.zzbdu = zzpn2.getApplicationContext();
        this.zzbmk = firebaseVisionFaceDetectorOptions;
        this.zzbfe = zzpo.zza((zzpn)zzpn2, (int)1);
    }

    @WorkerThread
    public final synchronized void zznu() {
        if (this.zzbmk.getContourMode() == 2) {
            if (this.zzbmm == null) {
                this.zzbmm = new FaceDetector.Builder(this.zzbdu).setLandmarkType(2).setMode(2).setTrackingEnabled(false).setProminentFaceOnly(true).build();
            }
            if ((this.zzbmk.getLandmarkMode() == 2 || this.zzbmk.getClassificationMode() == 2 || this.zzbmk.getPerformanceMode() == 2) && this.zzbml == null) {
                this.zzbml = new FaceDetector.Builder(this.zzbdu).setLandmarkType(zzrf.zzbu(this.zzbmk.getLandmarkMode())).setClassificationType(zzrf.zzbw(this.zzbmk.getClassificationMode())).setMode(zzrf.zzbv(this.zzbmk.getPerformanceMode())).setMinFaceSize(this.zzbmk.getMinFaceSize()).setTrackingEnabled(this.zzbmk.isTrackingEnabled()).build();
                return;
            }
        } else if (this.zzbml == null) {
            this.zzbml = new FaceDetector.Builder(this.zzbdu).setLandmarkType(zzrf.zzbu(this.zzbmk.getLandmarkMode())).setClassificationType(zzrf.zzbw(this.zzbmk.getClassificationMode())).setMode(zzrf.zzbv(this.zzbmk.getPerformanceMode())).setMinFaceSize(this.zzbmk.getMinFaceSize()).setTrackingEnabled(this.zzbmk.isTrackingEnabled()).build();
        }
    }

    @WorkerThread
    public final synchronized void release() {
        if (this.zzbml != null) {
            this.zzbml.release();
            this.zzbml = null;
        }
        if (this.zzbmm != null) {
            this.zzbmm.release();
            this.zzbmm = null;
        }
        zzbhb.set(true);
    }

    @WorkerThread
    @VisibleForTesting
    private final synchronized List<FirebaseVisionFace> zza(@NonNull FaceDetector faceDetector, @NonNull zzrl zzrl2, long l) throws FirebaseMLException {
        if (this.zzbmm != null) {
            if (zzbmj == null) {
                zzbmj = DynamiteModule.getLocalVersion((Context)this.zzbdu, (String)"com.google.android.gms.vision.dynamite.face") > 0;
            }
            if (!zzbmj.booleanValue()) {
                throw new FirebaseMLException("No Face Contour model is bundled. Please check your app setup to include firebase-ml-vision-face-model dependency.", 14);
            }
        }
        if (!faceDetector.isOperational()) {
            this.zza(zznq.zzana, l, zzrl2, 0, 0);
            throw new FirebaseMLException("Waiting for the face detection model to be downloaded. Please wait.", 14);
        }
        SparseArray sparseArray = faceDetector.detect(zzrl2.zzbkx);
        ArrayList<FirebaseVisionFace> arrayList = new ArrayList<FirebaseVisionFace>();
        for (int i = 0; i < sparseArray.size(); ++i) {
            int n = sparseArray.keyAt(i);
            arrayList.add(new FirebaseVisionFace((Face)sparseArray.get(n)));
        }
        return arrayList;
    }

    @WorkerThread
    private final synchronized List<FirebaseVisionFace> zza(@NonNull zzrl zzrl2) throws FirebaseMLException {
        ArrayList<FirebaseVisionFace> arrayList;
        List<FirebaseVisionFace> list = null;
        ArrayList<FirebaseVisionFace> arrayList2 = null;
        long l = SystemClock.elapsedRealtime();
        if (this.zzbml == null && this.zzbmm == null) {
            this.zza(zznq.zzanr, l, zzrl2, 0, 0);
            throw new FirebaseMLException("Face detector wasn't initialized correctly. This is most likely caused by invalid face detector options.", 13);
        }
        this.zzbjt.zzc(zzrl2);
        if (this.zzbml != null) {
            list = this.zza(this.zzbml, zzrl2, l);
            if (!this.zzbmk.isTrackingEnabled()) {
                zzro.zzh(list);
            }
        }
        if (this.zzbmm != null) {
            arrayList2 = this.zza(this.zzbmm, zzrl2, l);
            zzro.zzh(arrayList2);
        }
        ArrayList<FirebaseVisionFace> arrayList3 = arrayList2;
        List<FirebaseVisionFace> list2 = list;
        if (list2 == null && arrayList3 == null) {
            throw new FirebaseMLException("No detector is enabled", 13);
        }
        if (list2 == null) {
            arrayList = arrayList3;
        } else if (arrayList3 == null) {
            arrayList = list2;
        } else {
            HashSet<FirebaseVisionFace> hashSet = new HashSet<FirebaseVisionFace>();
            for (FirebaseVisionFace firebaseVisionFace : arrayList3) {
                boolean bl = false;
                Iterator<FirebaseVisionFace> iterator = list2.iterator();
                while (iterator.hasNext()) {
                    double d;
                    double d2;
                    double d3;
                    Rect rect;
                    Rect rect2;
                    FirebaseVisionFace firebaseVisionFace2;
                    FirebaseVisionFace firebaseVisionFace3 = firebaseVisionFace2 = iterator.next();
                    FirebaseVisionFace firebaseVisionFace4 = firebaseVisionFace;
                    if (firebaseVisionFace4.getBoundingBox() == null || firebaseVisionFace3.getBoundingBox() == null ? false : (rect2 = firebaseVisionFace4.getBoundingBox()).intersect(rect = firebaseVisionFace3.getBoundingBox()) && (d3 = (double)((Math.min(rect2.right, rect.right) - Math.max(rect2.left, rect.left)) * (Math.min(rect2.bottom, rect.bottom) - Math.max(rect2.top, rect.top)))) / ((d2 = (double)((rect2.right - rect2.left) * (rect2.bottom - rect2.top))) + (d = (double)((rect.right - rect.left) * (rect.bottom - rect.top))) - d3) > 0.6) {
                        bl = true;
                        firebaseVisionFace2.zza(firebaseVisionFace.zzqa());
                    }
                    hashSet.add(firebaseVisionFace2);
                }
                if (bl) continue;
                hashSet.add(firebaseVisionFace);
            }
            arrayList = new ArrayList<FirebaseVisionFace>(hashSet);
        }
        ArrayList<FirebaseVisionFace> arrayList4 = arrayList;
        this.zza(zznq.zzamr, l, zzrl2, arrayList2 == null ? 0 : arrayList2.size(), list == null ? 0 : list.size());
        zzbhb.set(false);
        return arrayList4;
    }

    private static void zzh(@NonNull List<FirebaseVisionFace> list) {
        Iterator<FirebaseVisionFace> iterator = list.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzbh(-1);
        }
    }

    public final zzpx zznl() {
        return this;
    }

    @WorkerThread
    private final synchronized void zza(zznq zznq2, long l, zzrl zzrl2, int n, int n2) {
        long l2 = SystemClock.elapsedRealtime() - l;
        zzrn zzrn2 = new zzrn(this, l2, zznq2, n, n2, zzrl2);
        this.zzbfe.zza((zzpw)zzrn2, zznu.zzanu);
        zzng.zzd.zza zza2 = (zzng.zzd.zza)((zzvx)zzng.zzd.zza.zzjx().zze(zznq2).zzq(zzbhb.get()).zzd(zzrf.zzb(zzrl2)).zzar(n).zzas(n2).zzb(this.zzbmk.zzqb()).zztx());
        zzpu zzpu2 = zzrp.zzbhp;
        this.zzbfe.zza((Object)zza2, l2, zznu.zzaqv, zzpu2);
    }

    final /* synthetic */ zzng.zzab.zza zza(long l, zznq zznq2, int n, int n2, zzrl zzrl2) {
        zzng.zzal zzal2 = (zzng.zzal)((zzvx)zzng.zzal.zzmi().zzd(zzng.zzad.zzlr().zzj(l).zzk(zznq2).zzae(zzbhb.get()).zzaf(true).zzag(true)).zzc(this.zzbmk.zzqb()).zzbm(n).zzbn(n2).zzj(zzrf.zzb(zzrl2)).zztx());
        return zzng.zzab.zzln().zzb(zzal2);
    }
}

