/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_ml;

import android.graphics.Rect;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.GmsLogger;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase_ml.zzki;
import com.google.android.gms.internal.firebase_ml.zzkl;
import com.google.android.gms.internal.firebase_ml.zzkx;
import com.google.android.gms.internal.firebase_ml.zzla;
import com.google.android.gms.internal.firebase_ml.zzld;
import com.google.android.gms.internal.firebase_ml.zzlf;
import com.google.android.gms.internal.firebase_ml.zzlg;
import com.google.android.gms.internal.firebase_ml.zzlj;
import com.google.android.gms.internal.firebase_ml.zzms;
import com.google.android.gms.internal.firebase_ml.zzqy;
import com.google.firebase.ml.vision.text.FirebaseVisionText;
import com.google.firebase.ml.vision.text.RecognizedLanguage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class zzsd {
    private static final GmsLogger zzbbo = new GmsLogger("TextAnnotationConverter", "");

    static FirebaseVisionText zzb(@Nullable zzlg zzlg2, float f) {
        if (zzlg2 == null) {
            return FirebaseVisionText.zzbnv;
        }
        if (zzlg2.getPages().size() <= 0) {
            zzbbo.d("TextAnnotationConverter", "Text Annotation is null, return empty Vision Text");
            return FirebaseVisionText.zzbnv;
        }
        if (zzlg2.getPages().size() > 1) {
            zzbbo.d("TextAnnotationConverter", "Text Annotation has more than one page, which should not happen");
        }
        ArrayList<FirebaseVisionText.TextBlock> arrayList = new ArrayList<FirebaseVisionText.TextBlock>();
        Iterator<zzkx> iterator = zzlg2.getPages().iterator();
        while (iterator.hasNext()) {
            Iterator<zzki> iterator2 = iterator.next().getBlocks().iterator();
            while (iterator2.hasNext()) {
                FirebaseVisionText.TextBlock textBlock;
                FirebaseVisionText.TextBlock textBlock2;
                float f2 = f;
                zzki zzki2 = iterator2.next();
                Preconditions.checkNotNull((Object)zzki2, (Object)"Input block can not be null");
                ArrayList<FirebaseVisionText.Line> arrayList2 = new ArrayList<FirebaseVisionText.Line>();
                if (zzki2.getParagraphs() == null) {
                    textBlock2 = null;
                } else {
                    for (zzla zzla2 : zzki2.getParagraphs()) {
                        if (zzla2 == null) continue;
                        float f3 = f2;
                        zzla zzla3 = zzla2;
                        Preconditions.checkNotNull((Object)zzla3, (Object)"Input Paragraph can not be null");
                        ArrayList<FirebaseVisionText.Line> arrayList3 = new ArrayList<FirebaseVisionText.Line>();
                        ArrayList<FirebaseVisionText.Element> arrayList4 = new ArrayList<FirebaseVisionText.Element>();
                        HashSet hashSet = new HashSet();
                        StringBuilder stringBuilder = new StringBuilder();
                        float f4 = 0.0f;
                        for (int i = 0; i < zzla3.getWords().size(); ++i) {
                            FirebaseVisionText.Element element;
                            String string;
                            String string2;
                            zzlj zzlj2 = zzla3.getWords().get(i);
                            if (zzlj2 == null) continue;
                            float f5 = f3;
                            Cloneable cloneable = zzlj2;
                            Preconditions.checkNotNull((Object)cloneable, (Object)"Input Word can not be null");
                            Object object = zzqy.zza(((zzlj)cloneable).zzik(), f5);
                            Object object2 = zzsd.zze(((zzlj)cloneable).zzil());
                            zzlj zzlj3 = cloneable;
                            Preconditions.checkNotNull((Object)zzlj3, (Object)"Input Word can not be null");
                            if (zzlj3.getSymbols() == null) {
                                string2 = "";
                            } else {
                                StringBuilder stringBuilder2 = new StringBuilder();
                                for (zzld zzld2 : zzlj3.getSymbols()) {
                                    stringBuilder2.append(zzld2.getText());
                                }
                                string2 = string = stringBuilder2.toString();
                            }
                            if ((element = string2.isEmpty() ? null : new FirebaseVisionText.Element(string, (Rect)object, (List<RecognizedLanguage>)object2, ((zzlj)cloneable).getConfidence())) == null) continue;
                            arrayList4.add(element);
                            f4 += zzqy.zza(element.getConfidence());
                            hashSet.addAll(element.getRecognizedLanguages());
                            StringBuilder stringBuilder3 = stringBuilder.append(element.getText());
                            cloneable = zzlj2;
                            Preconditions.checkNotNull((Object)cloneable, (Object)"Input word can not be null");
                            Object object3 = zzsd.zza((zzlj)cloneable);
                            object = "";
                            if (object3 != null) {
                                if (((String)object3).equals("SPACE") || ((String)object3).equals("SURE_SPACE")) {
                                    object = " ";
                                } else if (((String)object3).equals("HYPHEN")) {
                                    object = "-";
                                }
                            }
                            stringBuilder3.append((String)object);
                            cloneable = zzlj2;
                            Preconditions.checkNotNull((Object)cloneable, (Object)"Input word can not be null");
                            object3 = zzsd.zza((zzlj)cloneable);
                            if (!(object3 != null && (((String)object3).equals("EOL_SURE_SPACE") || ((String)object3).equals("LINE_BREAK") || ((String)object3).equals("HYPHEN"))) && i != zzla3.getWords().size() - 1) continue;
                            cloneable = arrayList4;
                            Preconditions.checkNotNull(cloneable, (Object)"Input elements can not be null");
                            object3 = null;
                            ArrayList arrayList5 = (ArrayList)cloneable;
                            int n = arrayList5.size();
                            int n2 = 0;
                            object = null;
                            while (n2 < n) {
                                Object e = arrayList5.get(n2);
                                ++n2;
                                object2 = (FirebaseVisionText.Element)e;
                                if (((FirebaseVisionText.Element)object2).getBoundingBox() == null) continue;
                                if (object3 == null) {
                                    object3 = new Rect();
                                }
                                object3.union(((FirebaseVisionText.Element)object2).getBoundingBox());
                            }
                            String string3 = object3;
                            String string4 = stringBuilder.toString();
                            cloneable = hashSet;
                            object3 = new ArrayList();
                            object = cloneable.iterator();
                            while (object.hasNext()) {
                                object2 = (RecognizedLanguage)object.next();
                                if (object2 == null || ((RecognizedLanguage)object2).getLanguageCode() == null || ((RecognizedLanguage)object2).getLanguageCode().isEmpty()) continue;
                                object3.add(object2);
                            }
                            arrayList3.add(new FirebaseVisionText.Line(string4, (Rect)string3, (List<RecognizedLanguage>)object3, arrayList4, Float.compare(f4, 0.0f) > 0 ? Float.valueOf(f4 / (float)arrayList4.size()) : null));
                            arrayList4 = new ArrayList();
                            hashSet.clear();
                            stringBuilder = new StringBuilder();
                            f4 = 0.0f;
                        }
                        arrayList2.addAll(arrayList3);
                    }
                    if (arrayList2.isEmpty()) {
                        textBlock2 = null;
                    } else {
                        StringBuilder stringBuilder = new StringBuilder();
                        ArrayList<FirebaseVisionText.Line> arrayList6 = arrayList2;
                        int n = arrayList6.size();
                        for (int i = 0; i < n; ++i) {
                            Object e = arrayList6.get(i);
                            FirebaseVisionText.Line line = (FirebaseVisionText.Line)e;
                            stringBuilder.append(line.getText()).append("\n");
                        }
                        List<RecognizedLanguage> list = zzsd.zze(zzki2.zzil());
                        textBlock2 = textBlock = new FirebaseVisionText.TextBlock(stringBuilder.toString(), zzqy.zza(zzki2.zzik(), f2), list, arrayList2, zzki2.getConfidence());
                    }
                }
                if (textBlock2 == null) continue;
                arrayList.add(textBlock);
            }
        }
        return new FirebaseVisionText(zzlg2.getText(), arrayList);
    }

    public static List<RecognizedLanguage> zze(@Nullable zzlf zzlf2) {
        ArrayList<RecognizedLanguage> arrayList = new ArrayList<RecognizedLanguage>();
        if (zzlf2 != null && zzlf2.zzit() != null) {
            Iterator<zzkl> iterator = zzlf2.zzit().iterator();
            while (iterator.hasNext()) {
                RecognizedLanguage recognizedLanguage = RecognizedLanguage.zza(iterator.next());
                if (recognizedLanguage == null) continue;
                arrayList.add(recognizedLanguage);
            }
        }
        return arrayList;
    }

    @Nullable
    @VisibleForTesting
    private static String zza(@NonNull zzlj zzlj2) {
        zzld zzld2;
        Preconditions.checkNotNull((Object)zzlj2, (Object)"Input Word can not be null");
        if (zzlj2.getSymbols() != null && !zzlj2.getSymbols().isEmpty() && (zzld2 = (zzld)zzms.zzc(zzlj2.getSymbols())).zzil() != null && zzld2.zzil().zzis() != null) {
            return ((zzld)zzms.zzc(zzlj2.getSymbols())).zzil().zzis().getType();
        }
        return null;
    }
}

