/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.ml.vision;

import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase_ml.zzpn;
import com.google.android.gms.internal.firebase_ml.zzqc;
import com.google.firebase.FirebaseApp;
import com.google.firebase.ml.common.FirebaseMLException;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcodeDetector;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcodeDetectorOptions;
import com.google.firebase.ml.vision.cloud.FirebaseVisionCloudDetectorOptions;
import com.google.firebase.ml.vision.cloud.landmark.FirebaseVisionCloudLandmarkDetector;
import com.google.firebase.ml.vision.document.FirebaseVisionCloudDocumentRecognizerOptions;
import com.google.firebase.ml.vision.document.FirebaseVisionDocumentTextRecognizer;
import com.google.firebase.ml.vision.face.FirebaseVisionFaceDetector;
import com.google.firebase.ml.vision.face.FirebaseVisionFaceDetectorOptions;
import com.google.firebase.ml.vision.label.FirebaseVisionCloudImageLabelerOptions;
import com.google.firebase.ml.vision.label.FirebaseVisionImageLabeler;
import com.google.firebase.ml.vision.label.FirebaseVisionOnDeviceAutoMLImageLabelerOptions;
import com.google.firebase.ml.vision.label.FirebaseVisionOnDeviceImageLabelerOptions;
import com.google.firebase.ml.vision.objects.FirebaseVisionObjectDetector;
import com.google.firebase.ml.vision.objects.FirebaseVisionObjectDetectorOptions;
import com.google.firebase.ml.vision.text.FirebaseVisionCloudTextRecognizerOptions;
import com.google.firebase.ml.vision.text.FirebaseVisionTextRecognizer;

public class FirebaseVision {
    private static final FirebaseVisionCloudDetectorOptions zzbhq = new FirebaseVisionCloudDetectorOptions.Builder().build();
    private static final FirebaseVisionFaceDetectorOptions zzbhr = new FirebaseVisionFaceDetectorOptions.Builder().build();
    private static final FirebaseVisionBarcodeDetectorOptions zzbhs = new FirebaseVisionBarcodeDetectorOptions.Builder().build();
    private static final FirebaseVisionCloudTextRecognizerOptions zzbht = new FirebaseVisionCloudTextRecognizerOptions.Builder().build();
    private static final FirebaseVisionCloudDocumentRecognizerOptions zzbhu = new FirebaseVisionCloudDocumentRecognizerOptions.Builder().build();
    private static final FirebaseVisionOnDeviceImageLabelerOptions zzbhv = new FirebaseVisionOnDeviceImageLabelerOptions.Builder().build();
    private static final FirebaseVisionCloudImageLabelerOptions zzbhw = new FirebaseVisionCloudImageLabelerOptions.Builder().build();
    private static final FirebaseVisionObjectDetectorOptions zzbhx = new FirebaseVisionObjectDetectorOptions.Builder().build();
    private final zzpn zzbdc;
    private final zzqc zzbcm;

    @NonNull
    public static FirebaseVision getInstance() {
        return FirebaseVision.getInstance(FirebaseApp.getInstance());
    }

    @NonNull
    public static FirebaseVision getInstance(@NonNull FirebaseApp firebaseApp) {
        Preconditions.checkNotNull((Object)firebaseApp, (Object)"MlKitContext can not be null");
        return (FirebaseVision)firebaseApp.get(FirebaseVision.class);
    }

    public void setStatsCollectionEnabled(boolean bl) {
        this.zzbcm.zzar(bl);
    }

    public boolean isStatsCollectionEnabled() {
        return this.zzbcm.zzny();
    }

    @NonNull
    public FirebaseVisionFaceDetector getVisionFaceDetector(@NonNull FirebaseVisionFaceDetectorOptions firebaseVisionFaceDetectorOptions) {
        Preconditions.checkNotNull((Object)firebaseVisionFaceDetectorOptions, (Object)"Please provide a valid FirebaseVisionFaceDetectorOptions");
        return FirebaseVisionFaceDetector.zza(this.zzbdc, firebaseVisionFaceDetectorOptions);
    }

    @NonNull
    public FirebaseVisionFaceDetector getVisionFaceDetector() {
        return FirebaseVisionFaceDetector.zza(this.zzbdc, zzbhr);
    }

    @NonNull
    public FirebaseVisionTextRecognizer getOnDeviceTextRecognizer() {
        return FirebaseVisionTextRecognizer.zza(this.zzbdc, null, true);
    }

    @NonNull
    public FirebaseVisionTextRecognizer getCloudTextRecognizer() {
        return FirebaseVisionTextRecognizer.zza(this.zzbdc, zzbht, false);
    }

    @NonNull
    public FirebaseVisionTextRecognizer getCloudTextRecognizer(@NonNull FirebaseVisionCloudTextRecognizerOptions firebaseVisionCloudTextRecognizerOptions) {
        return FirebaseVisionTextRecognizer.zza(this.zzbdc, firebaseVisionCloudTextRecognizerOptions, false);
    }

    @NonNull
    public FirebaseVisionBarcodeDetector getVisionBarcodeDetector(@NonNull FirebaseVisionBarcodeDetectorOptions firebaseVisionBarcodeDetectorOptions) {
        return FirebaseVisionBarcodeDetector.zza(this.zzbdc, (FirebaseVisionBarcodeDetectorOptions)Preconditions.checkNotNull((Object)firebaseVisionBarcodeDetectorOptions, (Object)"Please provide a valid FirebaseVisionBarcodeDetectorOptions"));
    }

    @NonNull
    public FirebaseVisionBarcodeDetector getVisionBarcodeDetector() {
        return FirebaseVisionBarcodeDetector.zza(this.zzbdc, zzbhs);
    }

    @NonNull
    public FirebaseVisionImageLabeler getOnDeviceImageLabeler(@NonNull FirebaseVisionOnDeviceImageLabelerOptions firebaseVisionOnDeviceImageLabelerOptions) {
        return FirebaseVisionImageLabeler.zza(this.zzbdc, (FirebaseVisionOnDeviceImageLabelerOptions)Preconditions.checkNotNull((Object)firebaseVisionOnDeviceImageLabelerOptions, (Object)"Please provide a valid FirebaseVisionOnDeviceImageLabelerOptions"));
    }

    @NonNull
    public FirebaseVisionImageLabeler getOnDeviceImageLabeler() {
        return FirebaseVisionImageLabeler.zza(this.zzbdc, zzbhv);
    }

    @NonNull
    public FirebaseVisionImageLabeler getOnDeviceAutoMLImageLabeler(@NonNull FirebaseVisionOnDeviceAutoMLImageLabelerOptions firebaseVisionOnDeviceAutoMLImageLabelerOptions) throws FirebaseMLException {
        return FirebaseVisionImageLabeler.zza(this.zzbdc, (FirebaseVisionOnDeviceAutoMLImageLabelerOptions)Preconditions.checkNotNull((Object)firebaseVisionOnDeviceAutoMLImageLabelerOptions, (Object)"Please provide a valid FirebaseVisionOnDeviceAutoMLImageLabelerOptions"));
    }

    @NonNull
    public FirebaseVisionImageLabeler getCloudImageLabeler(@NonNull FirebaseVisionCloudImageLabelerOptions firebaseVisionCloudImageLabelerOptions) {
        return FirebaseVisionImageLabeler.zza(this.zzbdc, firebaseVisionCloudImageLabelerOptions);
    }

    @NonNull
    public FirebaseVisionImageLabeler getCloudImageLabeler() {
        return FirebaseVisionImageLabeler.zza(this.zzbdc, zzbhw);
    }

    @NonNull
    public FirebaseVisionDocumentTextRecognizer getCloudDocumentTextRecognizer(@NonNull FirebaseVisionCloudDocumentRecognizerOptions firebaseVisionCloudDocumentRecognizerOptions) {
        return FirebaseVisionDocumentTextRecognizer.zza(this.zzbdc, firebaseVisionCloudDocumentRecognizerOptions);
    }

    @NonNull
    public FirebaseVisionDocumentTextRecognizer getCloudDocumentTextRecognizer() {
        return FirebaseVisionDocumentTextRecognizer.zza(this.zzbdc, zzbhu);
    }

    @NonNull
    public FirebaseVisionCloudLandmarkDetector getVisionCloudLandmarkDetector(@NonNull FirebaseVisionCloudDetectorOptions firebaseVisionCloudDetectorOptions) {
        return FirebaseVisionCloudLandmarkDetector.zza(this.zzbdc, firebaseVisionCloudDetectorOptions);
    }

    @NonNull
    public FirebaseVisionCloudLandmarkDetector getVisionCloudLandmarkDetector() {
        return FirebaseVisionCloudLandmarkDetector.zza(this.zzbdc, zzbhq);
    }

    @NonNull
    public FirebaseVisionObjectDetector getOnDeviceObjectDetector(@NonNull FirebaseVisionObjectDetectorOptions firebaseVisionObjectDetectorOptions) {
        return FirebaseVisionObjectDetector.zza(this.zzbdc, firebaseVisionObjectDetectorOptions);
    }

    @NonNull
    public FirebaseVisionObjectDetector getOnDeviceObjectDetector() {
        return FirebaseVisionObjectDetector.zza(this.zzbdc, zzbhx);
    }

    FirebaseVision(zzpn zzpn2) {
        this.zzbdc = zzpn2;
        this.zzbcm = zzqc.zzb((zzpn)zzpn2);
    }
}

