/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.ml.vision.barcode;

import android.graphics.Point;
import android.graphics.Rect;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase_ml.zzng;
import com.google.firebase.ml.vision.barcode.internal.zzf;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.List;

public class FirebaseVisionBarcode {
    public static final int FORMAT_UNKNOWN = -1;
    public static final int FORMAT_ALL_FORMATS = 0;
    public static final int FORMAT_CODE_128 = 1;
    public static final int FORMAT_CODE_39 = 2;
    public static final int FORMAT_CODE_93 = 4;
    public static final int FORMAT_CODABAR = 8;
    public static final int FORMAT_DATA_MATRIX = 16;
    public static final int FORMAT_EAN_13 = 32;
    public static final int FORMAT_EAN_8 = 64;
    public static final int FORMAT_ITF = 128;
    public static final int FORMAT_QR_CODE = 256;
    public static final int FORMAT_UPC_A = 512;
    public static final int FORMAT_UPC_E = 1024;
    public static final int FORMAT_PDF417 = 2048;
    public static final int FORMAT_AZTEC = 4096;
    private static final SparseArray<zzng.zzak.zza> zzbje = new SparseArray();
    private static final SparseArray<zzng.zzak.zzb> zzbjf = new SparseArray();
    private final zzf zzbjg;
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_CONTACT_INFO = 1;
    public static final int TYPE_EMAIL = 2;
    public static final int TYPE_ISBN = 3;
    public static final int TYPE_PHONE = 4;
    public static final int TYPE_PRODUCT = 5;
    public static final int TYPE_SMS = 6;
    public static final int TYPE_TEXT = 7;
    public static final int TYPE_URL = 8;
    public static final int TYPE_WIFI = 9;
    public static final int TYPE_GEO = 10;
    public static final int TYPE_CALENDAR_EVENT = 11;
    public static final int TYPE_DRIVER_LICENSE = 12;

    public FirebaseVisionBarcode(@NonNull zzf zzf2) {
        this.zzbjg = (zzf)Preconditions.checkNotNull((Object)zzf2);
    }

    @Nullable
    public Rect getBoundingBox() {
        return this.zzbjg.getBoundingBox();
    }

    @Nullable
    public Point[] getCornerPoints() {
        return this.zzbjg.getCornerPoints();
    }

    @Nullable
    public String getRawValue() {
        return this.zzbjg.getRawValue();
    }

    @Nullable
    public byte[] getRawBytes() {
        byte[] byArray = this.zzbjg.getRawBytes();
        if (byArray != null) {
            return Arrays.copyOf(byArray, byArray.length);
        }
        return null;
    }

    @Nullable
    public String getDisplayValue() {
        return this.zzbjg.getDisplayValue();
    }

    @BarcodeFormat
    public int getFormat() {
        int n = this.zzbjg.getFormat();
        if (n > 4096 || n == 0) {
            n = -1;
        }
        return n;
    }

    @BarcodeValueType
    public int getValueType() {
        return this.zzbjg.getValueType();
    }

    @Nullable
    public Email getEmail() {
        return this.zzbjg.getEmail();
    }

    @Nullable
    public Phone getPhone() {
        return this.zzbjg.getPhone();
    }

    @Nullable
    public Sms getSms() {
        return this.zzbjg.getSms();
    }

    @Nullable
    public WiFi getWifi() {
        return this.zzbjg.getWifi();
    }

    @Nullable
    public UrlBookmark getUrl() {
        return this.zzbjg.getUrl();
    }

    @Nullable
    public GeoPoint getGeoPoint() {
        return this.zzbjg.getGeoPoint();
    }

    @Nullable
    public CalendarEvent getCalendarEvent() {
        return this.zzbjg.getCalendarEvent();
    }

    @Nullable
    public ContactInfo getContactInfo() {
        return this.zzbjg.getContactInfo();
    }

    @Nullable
    public DriverLicense getDriverLicense() {
        return this.zzbjg.getDriverLicense();
    }

    public final zzng.zzak.zza zzpo() {
        zzng.zzak.zza zza2 = (zzng.zzak.zza)zzbje.get(this.getFormat());
        if (zza2 == null) {
            return zzng.zzak.zza.zzawo;
        }
        return zza2;
    }

    public final zzng.zzak.zzb zzpp() {
        zzng.zzak.zzb zzb2 = (zzng.zzak.zzb)zzbjf.get(this.getValueType());
        if (zzb2 == null) {
            return zzng.zzak.zzb.zzaxd;
        }
        return zzb2;
    }

    static {
        zzbje.put(-1, (Object)zzng.zzak.zza.zzawo);
        zzbje.put(1, (Object)zzng.zzak.zza.zzawp);
        zzbje.put(2, (Object)zzng.zzak.zza.zzawq);
        zzbje.put(4, (Object)zzng.zzak.zza.zzawr);
        zzbje.put(8, (Object)zzng.zzak.zza.zzaws);
        zzbje.put(16, (Object)zzng.zzak.zza.zzawt);
        zzbje.put(32, (Object)zzng.zzak.zza.zzawu);
        zzbje.put(64, (Object)zzng.zzak.zza.zzawv);
        zzbje.put(128, (Object)zzng.zzak.zza.zzaww);
        zzbje.put(256, (Object)zzng.zzak.zza.zzawx);
        zzbje.put(512, (Object)zzng.zzak.zza.zzawy);
        zzbje.put(1024, (Object)zzng.zzak.zza.zzawz);
        zzbje.put(2048, (Object)zzng.zzak.zza.zzaxa);
        zzbje.put(4096, (Object)zzng.zzak.zza.zzaxb);
        zzbjf.put(0, (Object)zzng.zzak.zzb.zzaxd);
        zzbjf.put(1, (Object)zzng.zzak.zzb.zzaxe);
        zzbjf.put(2, (Object)zzng.zzak.zzb.zzaxf);
        zzbjf.put(3, (Object)zzng.zzak.zzb.zzaxg);
        zzbjf.put(4, (Object)zzng.zzak.zzb.zzaxh);
        zzbjf.put(5, (Object)zzng.zzak.zzb.zzaxi);
        zzbjf.put(6, (Object)zzng.zzak.zzb.zzaxj);
        zzbjf.put(7, (Object)zzng.zzak.zzb.zzaxk);
        zzbjf.put(8, (Object)zzng.zzak.zzb.zzaxl);
        zzbjf.put(9, (Object)zzng.zzak.zzb.zzaxm);
        zzbjf.put(10, (Object)zzng.zzak.zzb.zzaxn);
        zzbjf.put(11, (Object)zzng.zzak.zzb.zzaxo);
        zzbjf.put(12, (Object)zzng.zzak.zzb.zzaxp);
    }

    public static class WiFi {
        public static final int TYPE_OPEN = 1;
        public static final int TYPE_WPA = 2;
        public static final int TYPE_WEP = 3;
        @Nullable
        private final String ssid;
        @Nullable
        private final String password;
        private final int encryptionType;

        public WiFi(@Nullable String string, @Nullable String string2, int n) {
            this.ssid = string;
            this.password = string2;
            this.encryptionType = n;
        }

        @Nullable
        public String getSsid() {
            return this.ssid;
        }

        @Nullable
        public String getPassword() {
            return this.password;
        }

        @EncryptionType
        public int getEncryptionType() {
            return this.encryptionType;
        }

        @Retention(value=RetentionPolicy.CLASS)
        public static @interface EncryptionType {
        }
    }

    public static class UrlBookmark {
        @Nullable
        private final String title;
        @Nullable
        private final String url;

        public UrlBookmark(@Nullable String string, @Nullable String string2) {
            this.title = string;
            this.url = string2;
        }

        @Nullable
        public String getTitle() {
            return this.title;
        }

        @Nullable
        public String getUrl() {
            return this.url;
        }
    }

    public static class Sms {
        @Nullable
        private final String message;
        @Nullable
        private final String phoneNumber;

        public Sms(@Nullable String string, @Nullable String string2) {
            this.message = string;
            this.phoneNumber = string2;
        }

        @Nullable
        public String getMessage() {
            return this.message;
        }

        @Nullable
        public String getPhoneNumber() {
            return this.phoneNumber;
        }
    }

    public static class GeoPoint {
        private final double lat;
        private final double lng;

        public GeoPoint(double d, double d2) {
            this.lat = d;
            this.lng = d2;
        }

        public double getLat() {
            return this.lat;
        }

        public double getLng() {
            return this.lng;
        }
    }

    public static class ContactInfo {
        @Nullable
        private final PersonName zzbjh;
        @Nullable
        private final String organization;
        @Nullable
        private final String title;
        private final List<Phone> zzbji;
        private final List<Email> zzbjj;
        @Nullable
        private final String[] urls;
        private final List<Address> zzbjk;

        public ContactInfo(@Nullable PersonName personName, @Nullable String string, @Nullable String string2, @NonNull List<Phone> list, @NonNull List<Email> list2, @Nullable String[] stringArray, @NonNull List<Address> list3) {
            this.zzbjh = personName;
            this.organization = string;
            this.title = string2;
            this.zzbji = list;
            this.zzbjj = list2;
            this.urls = stringArray;
            this.zzbjk = list3;
        }

        @Nullable
        public PersonName getName() {
            return this.zzbjh;
        }

        @Nullable
        public String getOrganization() {
            return this.organization;
        }

        @Nullable
        public String getTitle() {
            return this.title;
        }

        @NonNull
        public List<Phone> getPhones() {
            return this.zzbji;
        }

        @NonNull
        public List<Email> getEmails() {
            return this.zzbjj;
        }

        @Nullable
        public String[] getUrls() {
            return this.urls;
        }

        @NonNull
        public List<Address> getAddresses() {
            return this.zzbjk;
        }
    }

    public static class Email {
        public static final int TYPE_UNKNOWN = 0;
        public static final int TYPE_WORK = 1;
        public static final int TYPE_HOME = 2;
        private final int type;
        @Nullable
        private final String address;
        @Nullable
        private final String subject;
        @Nullable
        private final String body;

        public Email(int n, @Nullable String string, @Nullable String string2, @Nullable String string3) {
            this.type = n;
            this.address = string;
            this.subject = string2;
            this.body = string3;
        }

        @FormatType
        public int getType() {
            return this.type;
        }

        @Nullable
        public String getAddress() {
            return this.address;
        }

        @Nullable
        public String getSubject() {
            return this.subject;
        }

        @Nullable
        public String getBody() {
            return this.body;
        }

        @Retention(value=RetentionPolicy.CLASS)
        public static @interface FormatType {
        }
    }

    public static class Phone {
        public static final int TYPE_UNKNOWN = 0;
        public static final int TYPE_WORK = 1;
        public static final int TYPE_HOME = 2;
        public static final int TYPE_FAX = 3;
        public static final int TYPE_MOBILE = 4;
        @Nullable
        private final String number;
        private final int type;

        public Phone(@Nullable String string, int n) {
            this.number = string;
            this.type = n;
        }

        @Nullable
        public String getNumber() {
            return this.number;
        }

        @FormatType
        public int getType() {
            return this.type;
        }

        @Retention(value=RetentionPolicy.CLASS)
        public static @interface FormatType {
        }
    }

    public static class PersonName {
        @Nullable
        private final String formattedName;
        @Nullable
        private final String pronunciation;
        @Nullable
        private final String prefix;
        @Nullable
        private final String first;
        @Nullable
        private final String middle;
        @Nullable
        private final String last;
        @Nullable
        private final String suffix;

        public PersonName(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable String string7) {
            this.formattedName = string;
            this.pronunciation = string2;
            this.prefix = string3;
            this.first = string4;
            this.middle = string5;
            this.last = string6;
            this.suffix = string7;
        }

        @Nullable
        public String getFormattedName() {
            return this.formattedName;
        }

        @Nullable
        public String getPronunciation() {
            return this.pronunciation;
        }

        @Nullable
        public String getPrefix() {
            return this.prefix;
        }

        @Nullable
        public String getFirst() {
            return this.first;
        }

        @Nullable
        public String getMiddle() {
            return this.middle;
        }

        @Nullable
        public String getLast() {
            return this.last;
        }

        @Nullable
        public String getSuffix() {
            return this.suffix;
        }
    }

    public static class DriverLicense {
        @Nullable
        private final String documentType;
        @Nullable
        private final String firstName;
        @Nullable
        private final String middleName;
        @Nullable
        private final String lastName;
        @Nullable
        private final String gender;
        @Nullable
        private final String addressStreet;
        @Nullable
        private final String addressCity;
        @Nullable
        private final String addressState;
        @Nullable
        private final String addressZip;
        @Nullable
        private final String licenseNumber;
        @Nullable
        private final String issueDate;
        @Nullable
        private final String expiryDate;
        @Nullable
        private final String birthDate;
        @Nullable
        private final String issuingCountry;

        public DriverLicense(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable String string7, @Nullable String string8, @Nullable String string9, @Nullable String string10, @Nullable String string11, @Nullable String string12, @Nullable String string13, @Nullable String string14) {
            this.documentType = string;
            this.firstName = string2;
            this.middleName = string3;
            this.lastName = string4;
            this.gender = string5;
            this.addressStreet = string6;
            this.addressCity = string7;
            this.addressState = string8;
            this.addressZip = string9;
            this.licenseNumber = string10;
            this.issueDate = string11;
            this.expiryDate = string12;
            this.birthDate = string13;
            this.issuingCountry = string14;
        }

        @Nullable
        public String getDocumentType() {
            return this.documentType;
        }

        @Nullable
        public String getFirstName() {
            return this.firstName;
        }

        @Nullable
        public String getMiddleName() {
            return this.middleName;
        }

        @Nullable
        public String getLastName() {
            return this.lastName;
        }

        @Nullable
        public String getGender() {
            return this.gender;
        }

        @Nullable
        public String getAddressStreet() {
            return this.addressStreet;
        }

        @Nullable
        public String getAddressCity() {
            return this.addressCity;
        }

        @Nullable
        public String getAddressState() {
            return this.addressState;
        }

        @Nullable
        public String getAddressZip() {
            return this.addressZip;
        }

        @Nullable
        public String getLicenseNumber() {
            return this.licenseNumber;
        }

        @Nullable
        public String getIssueDate() {
            return this.issueDate;
        }

        @Nullable
        public String getExpiryDate() {
            return this.expiryDate;
        }

        @Nullable
        public String getBirthDate() {
            return this.birthDate;
        }

        @Nullable
        public String getIssuingCountry() {
            return this.issuingCountry;
        }
    }

    public static class CalendarEvent {
        @Nullable
        private final String summary;
        @Nullable
        private final String description;
        @Nullable
        private final String location;
        @Nullable
        private final String organizer;
        @Nullable
        private final String status;
        @Nullable
        private final CalendarDateTime zzbjl;
        @Nullable
        private final CalendarDateTime zzbjm;

        public CalendarEvent(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable CalendarDateTime calendarDateTime, @Nullable CalendarDateTime calendarDateTime2) {
            this.summary = string;
            this.description = string2;
            this.location = string3;
            this.organizer = string4;
            this.status = string5;
            this.zzbjl = calendarDateTime;
            this.zzbjm = calendarDateTime2;
        }

        @Nullable
        public String getSummary() {
            return this.summary;
        }

        @Nullable
        public String getDescription() {
            return this.description;
        }

        @Nullable
        public String getLocation() {
            return this.location;
        }

        @Nullable
        public String getOrganizer() {
            return this.organizer;
        }

        @Nullable
        public String getStatus() {
            return this.status;
        }

        @Nullable
        public CalendarDateTime getStart() {
            return this.zzbjl;
        }

        @Nullable
        public CalendarDateTime getEnd() {
            return this.zzbjm;
        }
    }

    public static class CalendarDateTime {
        private final int year;
        private final int month;
        private final int day;
        private final int hours;
        private final int minutes;
        private final int seconds;
        private final boolean isUtc;
        @Nullable
        private final String rawValue;

        public CalendarDateTime(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, @Nullable String string) {
            this.year = n;
            this.month = n2;
            this.day = n3;
            this.hours = n4;
            this.minutes = n5;
            this.seconds = n6;
            this.isUtc = bl;
            this.rawValue = string;
        }

        public int getYear() {
            return this.year;
        }

        public int getMonth() {
            return this.month;
        }

        public int getDay() {
            return this.day;
        }

        public int getHours() {
            return this.hours;
        }

        public int getMinutes() {
            return this.minutes;
        }

        public int getSeconds() {
            return this.seconds;
        }

        public boolean isUtc() {
            return this.isUtc;
        }

        @Nullable
        public String getRawValue() {
            return this.rawValue;
        }
    }

    public static class Address {
        public static final int TYPE_UNKNOWN = 0;
        public static final int TYPE_WORK = 1;
        public static final int TYPE_HOME = 2;
        private final int type;
        private final String[] addressLines;

        public Address(int n, String[] stringArray) {
            this.type = n;
            this.addressLines = stringArray;
        }

        @AddressType
        public int getType() {
            return this.type;
        }

        @NonNull
        public String[] getAddressLines() {
            return this.addressLines;
        }

        @Retention(value=RetentionPolicy.CLASS)
        public static @interface AddressType {
        }
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface BarcodeValueType {
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface BarcodeFormat {
    }
}

