/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.ml.vision.document;

import android.graphics.Rect;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.internal.firebase_ml.zzki;
import com.google.android.gms.internal.firebase_ml.zzkl;
import com.google.android.gms.internal.firebase_ml.zzkx;
import com.google.android.gms.internal.firebase_ml.zzla;
import com.google.android.gms.internal.firebase_ml.zzld;
import com.google.android.gms.internal.firebase_ml.zzlf;
import com.google.android.gms.internal.firebase_ml.zzlg;
import com.google.android.gms.internal.firebase_ml.zzlj;
import com.google.android.gms.internal.firebase_ml.zzmn;
import com.google.android.gms.internal.firebase_ml.zzmr;
import com.google.android.gms.internal.firebase_ml.zzqy;
import com.google.android.gms.internal.firebase_ml.zzsd;
import com.google.firebase.ml.vision.document.zzb;
import com.google.firebase.ml.vision.text.RecognizedLanguage;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FirebaseVisionDocumentText {
    private static final FirebaseVisionDocumentText zzbln = new FirebaseVisionDocumentText("", new ArrayList<Block>());
    private final String text;
    private final List<Block> blocks;

    @NonNull
    public List<Block> getBlocks() {
        return this.blocks;
    }

    @NonNull
    public String getText() {
        return zzmn.zzba((String)this.text);
    }

    private FirebaseVisionDocumentText(@NonNull String string, @NonNull List<Block> list) {
        this.text = string;
        this.blocks = list;
    }

    static FirebaseVisionDocumentText zza(@Nullable zzlg zzlg2, float f) {
        if (zzlg2 == null) {
            return zzbln;
        }
        String string = zzqy.zzcc(zzlg2.getText());
        ArrayList<Block> arrayList = new ArrayList<Block>();
        if (zzlg2.getPages() != null) {
            for (zzkx zzkx2 : zzlg2.getPages()) {
                if (zzkx2 == null) continue;
                for (zzki zzki2 : zzkx2.getBlocks()) {
                    if (zzki2 == null) continue;
                    Block block = Block.zza(zzki2, f);
                    arrayList.add(block);
                }
            }
        }
        return new FirebaseVisionDocumentText(string, arrayList);
    }

    private static List<RecognizedLanguage> zza(@Nullable zzlf zzlf2) {
        if (zzlf2 == null) {
            return zzmr.zzji();
        }
        ArrayList<RecognizedLanguage> arrayList = new ArrayList<RecognizedLanguage>();
        if (zzlf2.zzit() != null) {
            Iterator<zzkl> iterator = zzlf2.zzit().iterator();
            while (iterator.hasNext()) {
                RecognizedLanguage recognizedLanguage = RecognizedLanguage.zza(iterator.next());
                if (recognizedLanguage == null) continue;
                arrayList.add(recognizedLanguage);
            }
        }
        return arrayList;
    }

    private static String zza(@Nullable RecognizedBreak recognizedBreak) {
        if (recognizedBreak == null) {
            return "";
        }
        int n = recognizedBreak.getDetectedBreakType();
        String string = "";
        switch (n) {
            case 1: 
            case 2: {
                string = " ";
                break;
            }
            case 3: 
            case 5: {
                string = "\n";
                break;
            }
            case 4: {
                string = "-\n";
            }
        }
        return string;
    }

    static class DocumentTextBase {
        private final List<RecognizedLanguage> zzblo;
        private final RecognizedBreak zzblp;
        private final Rect zzbks;
        private final String text;
        private final Float confidence;

        DocumentTextBase(@NonNull List<RecognizedLanguage> list, @Nullable RecognizedBreak recognizedBreak, @Nullable Rect rect, @NonNull String string, @Nullable Float f) {
            this.text = string;
            this.zzblo = list;
            this.zzblp = recognizedBreak;
            this.zzbks = rect;
            this.confidence = f;
        }

        public String getText() {
            return this.text;
        }

        @Nullable
        public Rect getBoundingBox() {
            return this.zzbks;
        }

        public List<RecognizedLanguage> getRecognizedLanguages() {
            return this.zzblo;
        }

        @Nullable
        public RecognizedBreak getRecognizedBreak() {
            return this.zzblp;
        }

        @Nullable
        public Float getConfidence() {
            return this.confidence;
        }
    }

    public static class Symbol
    extends DocumentTextBase {
        private Symbol(@NonNull List<RecognizedLanguage> list, @Nullable RecognizedBreak recognizedBreak, @Nullable Rect rect, @NonNull String string, Float f) {
            super(list, recognizedBreak, rect, string, f);
        }

        private static Symbol zza(@NonNull zzld zzld2, float f) {
            return new Symbol(FirebaseVisionDocumentText.zza(zzld2.zzil()), RecognizedBreak.zzc(zzld2.zzil()), zzqy.zza(zzld2.zzik(), f), zzqy.zzcc(zzld2.getText()), zzld2.getConfidence());
        }
    }

    public static class Word
    extends DocumentTextBase {
        private final List<Symbol> symbols;

        @NonNull
        public List<Symbol> getSymbols() {
            return this.symbols;
        }

        private Word(@NonNull List<RecognizedLanguage> list, @Nullable RecognizedBreak recognizedBreak, @Nullable Rect rect, @NonNull List<Symbol> list2, @NonNull String string, @Nullable Float f) {
            super(list, recognizedBreak, rect, string, f);
            this.symbols = list2;
        }

        private static Word zza(@NonNull zzlj zzlj2, float f) {
            ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
            StringBuilder stringBuilder = new StringBuilder();
            List<RecognizedLanguage> list = zzsd.zze(zzlj2.zzil());
            RecognizedBreak recognizedBreak = null;
            if (zzlj2.getSymbols() != null) {
                for (zzld zzld2 : zzlj2.getSymbols()) {
                    if (zzld2 == null) continue;
                    Symbol symbol = Symbol.zza(zzld2, f);
                    recognizedBreak = ((DocumentTextBase)symbol).getRecognizedBreak();
                    stringBuilder.append(((DocumentTextBase)symbol).getText());
                    arrayList.add(Symbol.zza(zzld2, f));
                }
            }
            return new Word(list, recognizedBreak, zzqy.zza(zzlj2.zzik(), f), arrayList, stringBuilder.toString(), zzlj2.getConfidence());
        }
    }

    public static class Paragraph
    extends DocumentTextBase {
        private final List<Word> words;

        @NonNull
        public List<Word> getWords() {
            return this.words;
        }

        private Paragraph(@NonNull List<RecognizedLanguage> list, @Nullable RecognizedBreak recognizedBreak, @Nullable Rect rect, @NonNull List<Word> list2, @NonNull String string, @Nullable Float f) {
            super(list, recognizedBreak, rect, string, f);
            this.words = list2;
        }

        private static Paragraph zza(@NonNull zzla zzla2, float f) {
            ArrayList<Word> arrayList = new ArrayList<Word>();
            StringBuilder stringBuilder = new StringBuilder();
            List<RecognizedLanguage> list = zzsd.zze(zzla2.zzil());
            if (zzla2.getWords() != null) {
                for (zzlj zzlj2 : zzla2.getWords()) {
                    if (zzlj2 == null) continue;
                    Word word = Word.zza(zzlj2, f);
                    stringBuilder.append(((DocumentTextBase)word).getText()).append(FirebaseVisionDocumentText.zza(((DocumentTextBase)word).getRecognizedBreak()));
                    arrayList.add(word);
                }
            }
            return new Paragraph(list, new RecognizedBreak(5, false, null), zzqy.zza(zzla2.zzik(), f), arrayList, stringBuilder.toString(), zzla2.getConfidence());
        }
    }

    public static class Block
    extends DocumentTextBase {
        private final List<Paragraph> paragraphs;

        @NonNull
        public List<Paragraph> getParagraphs() {
            return this.paragraphs;
        }

        private Block(@NonNull List<RecognizedLanguage> list, @Nullable RecognizedBreak recognizedBreak, @Nullable Rect rect, @NonNull List<Paragraph> list2, @NonNull String string, Float f) {
            super(list, recognizedBreak, rect, string, f);
            this.paragraphs = list2;
        }

        private static Block zza(@NonNull zzki zzki2, float f) {
            ArrayList<Paragraph> arrayList = new ArrayList<Paragraph>();
            StringBuilder stringBuilder = new StringBuilder();
            List<RecognizedLanguage> list = zzsd.zze(zzki2.zzil());
            if (zzki2.getParagraphs() != null) {
                for (zzla zzla2 : zzki2.getParagraphs()) {
                    if (zzla2 == null) continue;
                    Paragraph paragraph = Paragraph.zza(zzla2, f);
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append(((DocumentTextBase)paragraph).getText());
                    arrayList.add(paragraph);
                }
            }
            return new Block(list, new RecognizedBreak(5, false, null), zzqy.zza(zzki2.zzik(), f), arrayList, stringBuilder.toString(), zzki2.getConfidence());
        }
    }

    public static class RecognizedBreak {
        public static final int UNKNOWN = 0;
        public static final int SPACE = 1;
        public static final int SURE_SPACE = 2;
        public static final int EOL_SURE_SPACE = 3;
        public static final int HYPHEN = 4;
        public static final int LINE_BREAK = 5;
        @BreakType
        private final int type;
        private final boolean zzblq;

        @BreakType
        public int getDetectedBreakType() {
            return this.type;
        }

        public boolean getIsPrefix() {
            return this.zzblq;
        }

        private RecognizedBreak(@BreakType int n, boolean bl) {
            this.type = n;
            this.zzblq = bl;
        }

        @Nullable
        private static RecognizedBreak zzc(@Nullable zzlf zzlf2) {
            if (zzlf2 == null || zzlf2.zzis() == null) {
                return null;
            }
            int n = 0;
            if (zzlf2.zzis().getType() != null) {
                switch (zzlf2.zzis().getType()) {
                    case "SPACE": {
                        n = 1;
                        break;
                    }
                    case "SURE_SPACE": {
                        n = 2;
                        break;
                    }
                    case "EOL_SURE_SPACE": {
                        n = 3;
                        break;
                    }
                    case "HYPHEN": {
                        n = 4;
                        break;
                    }
                    case "LINE_BREAK": {
                        n = 5;
                    }
                }
            }
            boolean bl = false;
            if (zzlf2.zzis().zzim() != null) {
                bl = zzlf2.zzis().zzim();
            }
            return new RecognizedBreak(n, bl);
        }

        /* synthetic */ RecognizedBreak(int n, boolean bl, zzb zzb2) {
            this(5, false);
        }

        @Retention(value=RetentionPolicy.CLASS)
        public static @interface BreakType {
        }
    }
}

