/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.ml.vision.face;

import android.graphics.PointF;
import android.graphics.Rect;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.internal.firebase_ml.zzlw;
import com.google.android.gms.internal.firebase_ml.zzly;
import com.google.android.gms.vision.face.Contour;
import com.google.android.gms.vision.face.Face;
import com.google.firebase.ml.vision.common.FirebaseVisionPoint;
import com.google.firebase.ml.vision.face.FirebaseVisionFaceContour;
import com.google.firebase.ml.vision.face.FirebaseVisionFaceLandmark;
import java.util.ArrayList;
import javax.annotation.concurrent.Immutable;

@Immutable
public class FirebaseVisionFace {
    public static final float UNCOMPUTED_PROBABILITY = -1.0f;
    public static final int INVALID_ID = -1;
    private final Rect zzbks;
    private int zzblr;
    private float zzbls;
    private float zzblt;
    private float zzblu;
    private final float zzblv;
    private final float zzblw;
    private final SparseArray<FirebaseVisionFaceLandmark> zzblx = new SparseArray();
    private final SparseArray<FirebaseVisionFaceContour> zzbly = new SparseArray();

    @NonNull
    public Rect getBoundingBox() {
        return this.zzbks;
    }

    public int getTrackingId() {
        return this.zzblr;
    }

    private static boolean zzbx(@FirebaseVisionFaceLandmark.LandmarkType int n) {
        return n == 0 || n == 1 || n == 7 || n == 3 || n == 9 || n == 4 || n == 10 || n == 5 || n == 11 || n == 6;
    }

    public FirebaseVisionFace(@NonNull Face face) {
        PointF pointF = face.getPosition();
        this.zzbks = new Rect((int)pointF.x, (int)pointF.y, (int)(pointF.x + face.getWidth()), (int)(pointF.y + face.getHeight()));
        this.zzblr = face.getId();
        for (Object object : face.getLandmarks()) {
            if (!FirebaseVisionFace.zzbx(object.getType()) || object.getPosition() == null) continue;
            this.zzblx.put(object.getType(), (Object)new FirebaseVisionFaceLandmark(object.getType(), new FirebaseVisionPoint(Float.valueOf(object.getPosition().x), Float.valueOf(object.getPosition().y), null)));
        }
        ArrayList arrayList = new ArrayList();
        for (Contour contour : face.getContours()) {
            int n;
            switch (contour.getType()) {
                case 1: {
                    n = 2;
                    break;
                }
                case 2: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 4;
                    break;
                }
                case 4: {
                    n = 5;
                    break;
                }
                case 5: {
                    n = 6;
                    break;
                }
                case 6: {
                    n = 7;
                    break;
                }
                case 7: {
                    n = 8;
                    break;
                }
                case 8: {
                    n = 9;
                    break;
                }
                case 9: {
                    n = 10;
                    break;
                }
                case 10: {
                    n = 11;
                    break;
                }
                case 11: {
                    n = 12;
                    break;
                }
                case 12: {
                    n = 13;
                    break;
                }
                case 13: {
                    n = 14;
                    break;
                }
                default: {
                    n = -1;
                }
            }
            int n2 = n;
            int n3 = n;
            if (!(n <= 14 && n3 > 0)) continue;
            PointF[] pointFArray = contour.getPositions();
            ArrayList<FirebaseVisionPoint> arrayList2 = new ArrayList<FirebaseVisionPoint>();
            if (pointFArray == null) continue;
            PointF[] pointFArray2 = pointFArray;
            int n4 = pointFArray.length;
            for (int i = 0; i < n4; ++i) {
                PointF pointF2 = pointFArray2[i];
                arrayList2.add(new FirebaseVisionPoint(Float.valueOf(pointF2.x), Float.valueOf(pointF2.y), null));
            }
            this.zzbly.put(n2, (Object)new FirebaseVisionFaceContour(n2, arrayList2));
            arrayList.addAll(arrayList2);
        }
        this.zzbly.put(1, (Object)new FirebaseVisionFaceContour(1, arrayList));
        this.zzblv = face.getEulerY();
        this.zzblw = face.getEulerZ();
        this.zzblu = face.getIsSmilingProbability();
        this.zzblt = face.getIsLeftEyeOpenProbability();
        this.zzbls = face.getIsRightEyeOpenProbability();
    }

    public float getHeadEulerAngleY() {
        return this.zzblv;
    }

    public float getHeadEulerAngleZ() {
        return this.zzblw;
    }

    @Nullable
    public FirebaseVisionFaceLandmark getLandmark(@FirebaseVisionFaceLandmark.LandmarkType int n) {
        return (FirebaseVisionFaceLandmark)this.zzblx.get(n);
    }

    @NonNull
    public FirebaseVisionFaceContour getContour(@FirebaseVisionFaceContour.ContourType int n) {
        FirebaseVisionFaceContour firebaseVisionFaceContour = (FirebaseVisionFaceContour)this.zzbly.get(n);
        if (firebaseVisionFaceContour != null) {
            return firebaseVisionFaceContour;
        }
        return new FirebaseVisionFaceContour(n, new ArrayList<FirebaseVisionPoint>());
    }

    public final SparseArray<FirebaseVisionFaceContour> zzqa() {
        return this.zzbly;
    }

    public final void zza(SparseArray<FirebaseVisionFaceContour> sparseArray) {
        this.zzbly.clear();
        for (int i = 0; i < sparseArray.size(); ++i) {
            this.zzbly.put(sparseArray.keyAt(i), (Object)((FirebaseVisionFaceContour)sparseArray.valueAt(i)));
        }
    }

    public final void zzbh(int n) {
        this.zzblr = -1;
    }

    public float getSmilingProbability() {
        return this.zzblu;
    }

    public float getLeftEyeOpenProbability() {
        return this.zzblt;
    }

    public float getRightEyeOpenProbability() {
        return this.zzbls;
    }

    public String toString() {
        int n;
        zzly zzly2 = zzlw.zzay((String)"FirebaseVisionFace").zzh("boundingBox", (Object)this.zzbks).zzb("trackingId", this.zzblr).zza("rightEyeOpenProbability", this.zzbls).zza("leftEyeOpenProbability", this.zzblt).zza("smileProbability", this.zzblu).zza("eulerY", this.zzblv).zza("eulerZ", this.zzblw);
        zzly zzly3 = zzlw.zzay((String)"Landmarks");
        for (int i = 0; i <= 11; ++i) {
            if (!FirebaseVisionFace.zzbx(i)) continue;
            n = i;
            zzly3.zzh(new StringBuilder(20).append("landmark_").append(n).toString(), (Object)this.getLandmark(i));
        }
        zzly2.zzh("landmarks", (Object)zzly3.toString());
        zzly zzly4 = zzlw.zzay((String)"Contours");
        for (n = 1; n <= 14; ++n) {
            int n2 = n;
            zzly4.zzh(new StringBuilder(19).append("Contour_").append(n2).toString(), (Object)this.getContour(n));
        }
        zzly2.zzh("contours", (Object)zzly4.toString());
        return zzly2.toString();
    }
}

