/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.ml.vision.face;

import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.internal.firebase_ml.zzlw;
import com.google.android.gms.internal.firebase_ml.zzng;
import com.google.android.gms.internal.firebase_ml.zzvx;
import com.google.firebase.ml.vision.face.zza;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class FirebaseVisionFaceDetectorOptions {
    @LandmarkMode
    private final int zzbma;
    @ContourMode
    private final int zzbmb;
    @ClassificationMode
    private final int zzbmc;
    @PerformanceMode
    private final int zzbmd;
    private final boolean trackingEnabled;
    private final float zzbme;
    public static final int NO_LANDMARKS = 1;
    public static final int ALL_LANDMARKS = 2;
    public static final int NO_CONTOURS = 1;
    public static final int ALL_CONTOURS = 2;
    public static final int NO_CLASSIFICATIONS = 1;
    public static final int ALL_CLASSIFICATIONS = 2;
    public static final int FAST = 1;
    public static final int ACCURATE = 2;

    @LandmarkMode
    public int getLandmarkMode() {
        return this.zzbma;
    }

    @ContourMode
    public int getContourMode() {
        return this.zzbmb;
    }

    @ClassificationMode
    public int getClassificationMode() {
        return this.zzbmc;
    }

    @PerformanceMode
    public int getPerformanceMode() {
        return this.zzbmd;
    }

    public boolean isTrackingEnabled() {
        return this.trackingEnabled;
    }

    public float getMinFaceSize() {
        return this.zzbme;
    }

    private FirebaseVisionFaceDetectorOptions(@LandmarkMode int n, @ContourMode int n2, @ClassificationMode int n3, @PerformanceMode int n4, boolean bl, float f) {
        this.zzbma = n;
        this.zzbmb = n2;
        this.zzbmc = n3;
        this.zzbmd = n4;
        this.trackingEnabled = bl;
        this.zzbme = f;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FirebaseVisionFaceDetectorOptions)) {
            return false;
        }
        FirebaseVisionFaceDetectorOptions firebaseVisionFaceDetectorOptions = (FirebaseVisionFaceDetectorOptions)object;
        return Float.floatToIntBits(this.zzbme) == Float.floatToIntBits(firebaseVisionFaceDetectorOptions.zzbme) && this.zzbma == firebaseVisionFaceDetectorOptions.zzbma && this.zzbmb == firebaseVisionFaceDetectorOptions.zzbmb && this.zzbmd == firebaseVisionFaceDetectorOptions.zzbmd && this.trackingEnabled == firebaseVisionFaceDetectorOptions.trackingEnabled && this.zzbmc == firebaseVisionFaceDetectorOptions.zzbmc;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Float.floatToIntBits(this.zzbme), this.zzbma, this.zzbmb, this.zzbmd, this.trackingEnabled, this.zzbmc});
    }

    public String toString() {
        return zzlw.zzay((String)"FaceDetectorOptions").zzb("landmarkMode", this.zzbma).zzb("contourMode", this.zzbmb).zzb("classificationMode", this.zzbmc).zzb("performanceMode", this.zzbmd).zza("trackingEnabled", this.trackingEnabled).zza("minFaceSize", this.zzbme).toString();
    }

    public final zzng.zzaa zzqb() {
        zzng.zzaa.zzc zzc2;
        zzng.zzaa.zze zze2;
        zzng.zzaa.zza zza2;
        zzng.zzaa.zzd zzd2;
        zzng.zzaa.zzb zzb2 = zzng.zzaa.zzlk();
        switch (this.zzbma) {
            case 1: {
                zzd2 = zzng.zzaa.zzd.zzarq;
                break;
            }
            case 2: {
                zzd2 = zzng.zzaa.zzd.zzarr;
                break;
            }
            default: {
                zzd2 = zzng.zzaa.zzd.zzarp;
            }
        }
        zzng.zzaa.zzb zzb3 = zzb2.zzb(zzd2);
        switch (this.zzbmc) {
            case 1: {
                zza2 = zzng.zzaa.zza.zzari;
                break;
            }
            case 2: {
                zza2 = zzng.zzaa.zza.zzarj;
                break;
            }
            default: {
                zza2 = zzng.zzaa.zza.zzarh;
            }
        }
        zzng.zzaa.zzb zzb4 = zzb3.zzb(zza2);
        switch (this.zzbmd) {
            case 1: {
                zze2 = zzng.zzaa.zze.zzaru;
                break;
            }
            case 2: {
                zze2 = zzng.zzaa.zze.zzarv;
                break;
            }
            default: {
                zze2 = zzng.zzaa.zze.zzart;
            }
        }
        zzng.zzaa.zzb zzb5 = zzb4.zzb(zze2);
        switch (this.zzbmb) {
            case 1: {
                zzc2 = zzng.zzaa.zzc.zzarm;
                break;
            }
            case 2: {
                zzc2 = zzng.zzaa.zzc.zzarn;
                break;
            }
            default: {
                zzc2 = zzng.zzaa.zzc.zzarl;
            }
        }
        return (zzng.zzaa)((zzvx)zzb5.zzb(zzc2).zzab(this.isTrackingEnabled()).zzl(this.zzbme).zztx());
    }

    /* synthetic */ FirebaseVisionFaceDetectorOptions(int n, int n2, int n3, int n4, boolean bl, float f, zza zza2) {
        this(n, n2, n3, n4, bl, f);
    }

    public static class Builder {
        @LandmarkMode
        private int zzbma = 1;
        @ContourMode
        private int zzbmb = 1;
        @ClassificationMode
        private int zzbmc = 1;
        @PerformanceMode
        private int zzbmd = 1;
        private boolean trackingEnabled = false;
        private float zzbme = 0.1f;

        @NonNull
        public Builder setLandmarkMode(@LandmarkMode int n) {
            this.zzbma = n;
            return this;
        }

        @NonNull
        public Builder setContourMode(@ContourMode int n) {
            this.zzbmb = n;
            return this;
        }

        @NonNull
        public Builder setClassificationMode(@ClassificationMode int n) {
            this.zzbmc = n;
            return this;
        }

        @NonNull
        public Builder enableTracking() {
            this.trackingEnabled = true;
            return this;
        }

        @NonNull
        public Builder setPerformanceMode(@PerformanceMode int n) {
            this.zzbmd = n;
            return this;
        }

        @NonNull
        public Builder setMinFaceSize(float f) {
            this.zzbme = f;
            return this;
        }

        @NonNull
        public FirebaseVisionFaceDetectorOptions build() {
            return new FirebaseVisionFaceDetectorOptions(this.zzbma, this.zzbmb, this.zzbmc, this.zzbmd, this.trackingEnabled, this.zzbme, null);
        }
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface PerformanceMode {
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface ClassificationMode {
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface ContourMode {
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface LandmarkMode {
    }
}

