/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.ml.vision.label;

import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.ml.vision.label.zza;
import javax.annotation.concurrent.Immutable;

@Immutable
public class FirebaseVisionCloudImageLabelerOptions {
    private final float zzbix;
    private final boolean zzbkc;

    private FirebaseVisionCloudImageLabelerOptions(float f, boolean bl) {
        this.zzbix = f;
        this.zzbkc = bl;
    }

    public float getConfidenceThreshold() {
        return this.zzbix;
    }

    public boolean isEnforceCertFingerprintMatch() {
        return this.zzbkc;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FirebaseVisionCloudImageLabelerOptions)) {
            return false;
        }
        FirebaseVisionCloudImageLabelerOptions firebaseVisionCloudImageLabelerOptions = (FirebaseVisionCloudImageLabelerOptions)object;
        return Float.compare(this.zzbix, firebaseVisionCloudImageLabelerOptions.zzbix) == 0 && this.zzbkc == firebaseVisionCloudImageLabelerOptions.zzbkc;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Float.valueOf(this.zzbix), this.zzbkc});
    }

    /* synthetic */ FirebaseVisionCloudImageLabelerOptions(float f, boolean bl, zza zza2) {
        this(f, bl);
    }

    public static class Builder {
        private float zzbix = 0.5f;
        private boolean zzbkc = false;

        @NonNull
        public Builder setConfidenceThreshold(float f) {
            Preconditions.checkArgument((Float.compare(f, 0.0f) >= 0 && Float.compare(f, 1.0f) <= 0 ? 1 : 0) != 0, (Object)"Confidence Threshold should be in range [0.0f, 1.0f].");
            this.zzbix = f;
            return this;
        }

        @NonNull
        public Builder enforceCertFingerprintMatch() {
            this.zzbkc = true;
            return this;
        }

        @NonNull
        public FirebaseVisionCloudImageLabelerOptions build() {
            return new FirebaseVisionCloudImageLabelerOptions(this.zzbix, this.zzbkc, null);
        }
    }
}

