/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.ml.vision.label;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase_ml.zzkn;
import com.google.android.gms.internal.firebase_ml.zzmn;
import com.google.android.gms.internal.firebase_ml.zzqy;
import com.google.android.gms.vision.label.ImageLabel;
import com.google.firebase.ml.vision.automl.internal.zzj;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class FirebaseVisionImageLabel {
    private final String zzbiv;
    private final String text;
    private final float zzbiw;

    public FirebaseVisionImageLabel(@NonNull ImageLabel imageLabel) {
        this(imageLabel.getLabel(), imageLabel.getConfidence(), imageLabel.getMid());
    }

    @Nullable
    public static FirebaseVisionImageLabel zza(@Nullable zzkn zzkn2) {
        if (zzkn2 == null) {
            return null;
        }
        float f = zzqy.zza(zzkn2.zzio());
        String string = zzkn2.getDescription();
        String string2 = zzkn2.getMid();
        return new FirebaseVisionImageLabel(string, f, string2);
    }

    public static FirebaseVisionImageLabel zza(@NonNull zzj zzj2) {
        Preconditions.checkNotNull((Object)((Object)zzj2), (Object)"Returned image label parcel can not be null");
        return new FirebaseVisionImageLabel(zzj2.text, zzj2.zzbiw, zzj2.zzbiv);
    }

    @VisibleForTesting
    private FirebaseVisionImageLabel(@Nullable String string, float f, @Nullable String string2) {
        this.text = zzmn.zzba((String)string);
        this.zzbiv = string2;
        if (Float.compare(f, 0.0f) < 0) {
            f = 0.0f;
        } else if (Float.compare(f, 1.0f) > 0) {
            f = 1.0f;
        }
        this.zzbiw = f;
    }

    @Nullable
    public String getEntityId() {
        return this.zzbiv;
    }

    @NonNull
    public String getText() {
        return this.text;
    }

    public float getConfidence() {
        return this.zzbiw;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FirebaseVisionImageLabel)) {
            return false;
        }
        FirebaseVisionImageLabel firebaseVisionImageLabel = (FirebaseVisionImageLabel)object;
        return Objects.equal((Object)this.zzbiv, (Object)firebaseVisionImageLabel.getEntityId()) && Objects.equal((Object)this.text, (Object)firebaseVisionImageLabel.getText()) && Float.compare(this.zzbiw, firebaseVisionImageLabel.getConfidence()) == 0;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zzbiv, this.text, Float.valueOf(this.zzbiw)});
    }
}

