/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.ml.vision.label;

import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.ml.vision.automl.FirebaseAutoMLLocalModel;
import com.google.firebase.ml.vision.automl.FirebaseAutoMLRemoteModel;
import com.google.firebase.ml.vision.label.zzc;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class FirebaseVisionOnDeviceAutoMLImageLabelerOptions {
    private final float zzbix;
    @Nullable
    private final FirebaseAutoMLLocalModel zzbia;
    @Nullable
    private final FirebaseAutoMLRemoteModel zzbiq;

    public final float getConfidenceThreshold() {
        return this.zzbix;
    }

    public final FirebaseAutoMLLocalModel zzqc() {
        return this.zzbia;
    }

    public final FirebaseAutoMLRemoteModel zzqd() {
        return this.zzbiq;
    }

    private FirebaseVisionOnDeviceAutoMLImageLabelerOptions(float f, @Nullable FirebaseAutoMLLocalModel firebaseAutoMLLocalModel, @Nullable FirebaseAutoMLRemoteModel firebaseAutoMLRemoteModel) {
        this.zzbix = f;
        this.zzbia = firebaseAutoMLLocalModel;
        this.zzbiq = firebaseAutoMLRemoteModel;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FirebaseVisionOnDeviceAutoMLImageLabelerOptions)) {
            return false;
        }
        FirebaseVisionOnDeviceAutoMLImageLabelerOptions firebaseVisionOnDeviceAutoMLImageLabelerOptions = (FirebaseVisionOnDeviceAutoMLImageLabelerOptions)object;
        return Float.compare(this.zzbix, firebaseVisionOnDeviceAutoMLImageLabelerOptions.zzbix) == 0 && Objects.equal((Object)((Object)this.zzbia), (Object)((Object)firebaseVisionOnDeviceAutoMLImageLabelerOptions.zzbia)) && Objects.equal((Object)((Object)this.zzbiq), (Object)((Object)firebaseVisionOnDeviceAutoMLImageLabelerOptions.zzbiq));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Float.valueOf(this.zzbix), this.zzbia, this.zzbiq});
    }

    /* synthetic */ FirebaseVisionOnDeviceAutoMLImageLabelerOptions(float f, FirebaseAutoMLLocalModel firebaseAutoMLLocalModel, FirebaseAutoMLRemoteModel firebaseAutoMLRemoteModel, zzc zzc2) {
        this(f, firebaseAutoMLLocalModel, firebaseAutoMLRemoteModel);
    }

    public static class Builder {
        private float zzbix = 0.5f;
        @Nullable
        private FirebaseAutoMLLocalModel zzbia;
        @Nullable
        private FirebaseAutoMLRemoteModel zzbiq;

        public Builder(@NonNull FirebaseAutoMLLocalModel firebaseAutoMLLocalModel) {
            Preconditions.checkNotNull((Object)((Object)firebaseAutoMLLocalModel));
            this.zzbia = firebaseAutoMLLocalModel;
        }

        public Builder(@NonNull FirebaseAutoMLRemoteModel firebaseAutoMLRemoteModel) {
            Preconditions.checkNotNull((Object)((Object)firebaseAutoMLRemoteModel));
            this.zzbiq = firebaseAutoMLRemoteModel;
        }

        @Nonnull
        public Builder setConfidenceThreshold(float f) {
            Preconditions.checkArgument((Float.compare(f, 0.0f) >= 0 && Float.compare(f, 1.0f) <= 0 ? 1 : 0) != 0, (Object)"Confidence Threshold should be in range [0.0f, 1.0f].");
            this.zzbix = f;
            return this;
        }

        @Nonnull
        public FirebaseVisionOnDeviceAutoMLImageLabelerOptions build() {
            Preconditions.checkArgument((this.zzbia != null || this.zzbiq != null ? 1 : 0) != 0, (Object)"Either a local model or remote model must be set.");
            return new FirebaseVisionOnDeviceAutoMLImageLabelerOptions(this.zzbix, this.zzbia, this.zzbiq, null);
        }
    }
}

