/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.ml.vision.objects.internal;

import android.content.Context;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.firebase_ml.zzmr;
import com.google.android.gms.internal.firebase_ml.zzng;
import com.google.android.gms.internal.firebase_ml.zznq;
import com.google.android.gms.internal.firebase_ml.zznu;
import com.google.android.gms.internal.firebase_ml.zzpc;
import com.google.android.gms.internal.firebase_ml.zzpn;
import com.google.android.gms.internal.firebase_ml.zzpo;
import com.google.android.gms.internal.firebase_ml.zzpu;
import com.google.android.gms.internal.firebase_ml.zzpw;
import com.google.android.gms.internal.firebase_ml.zzpx;
import com.google.android.gms.internal.firebase_ml.zzrf;
import com.google.android.gms.internal.firebase_ml.zzrk;
import com.google.android.gms.internal.firebase_ml.zzrl;
import com.google.android.gms.internal.firebase_ml.zzvx;
import com.google.android.gms.vision.Frame;
import com.google.firebase.ml.common.FirebaseMLException;
import com.google.firebase.ml.vision.objects.FirebaseVisionObject;
import com.google.firebase.ml.vision.objects.FirebaseVisionObjectDetectorOptions;
import com.google.firebase.ml.vision.objects.internal.IObjectDetector;
import com.google.firebase.ml.vision.objects.internal.ObjectDetectorOptionsParcel;
import com.google.firebase.ml.vision.objects.internal.zza;
import com.google.firebase.ml.vision.objects.internal.zzd;
import com.google.firebase.ml.vision.objects.internal.zzf;
import com.google.firebase.ml.vision.objects.internal.zzh;
import com.google.firebase.ml.vision.objects.internal.zzi;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public final class zzg
implements zzpc<List<FirebaseVisionObject>, zzrl>,
zzpx {
    private static final AtomicBoolean zzbhb = new AtomicBoolean(true);
    private final FirebaseVisionObjectDetectorOptions zzbnp;
    private final zzpn zzbdc;
    private final zzpo zzbfe;
    private long zzbnq = -1L;
    @VisibleForTesting
    private final zzng.zzaq zzbnr;
    @GuardedBy(value="this")
    private IObjectDetector zzbns;

    public zzg(@NonNull zzpn zzpn2, @NonNull FirebaseVisionObjectDetectorOptions firebaseVisionObjectDetectorOptions) {
        zzng.zzaq.zzb zzb2;
        Preconditions.checkNotNull((Object)zzpn2, (Object)"Context can not be null");
        Preconditions.checkNotNull((Object)firebaseVisionObjectDetectorOptions, (Object)"FirebaseVisionObjectDetectorOptions can not be null");
        this.zzbnp = firebaseVisionObjectDetectorOptions;
        this.zzbdc = zzpn2;
        this.zzbfe = zzpo.zza((zzpn)zzpn2, (int)1);
        zzng.zzaq.zza zza2 = zzng.zzaq.zzmu();
        int n = firebaseVisionObjectDetectorOptions.zzqf();
        switch (n) {
            case 2: {
                zzb2 = zzng.zzaq.zzb.zzayo;
                break;
            }
            case 1: {
                zzb2 = zzng.zzaq.zzb.zzayn;
                break;
            }
            default: {
                Log.e((String)"ObjectDetectorTask", (String)new StringBuilder(37).append("Unexpected detector mode: ").append(n).toString());
                zzb2 = zzng.zzaq.zzb.zzaym;
            }
        }
        this.zzbnr = (zzng.zzaq)((zzvx)zza2.zza(zzb2).zzam(firebaseVisionObjectDetectorOptions.zzqh()).zzan(firebaseVisionObjectDetectorOptions.zzqg()).zztx());
        zzg zzg2 = this;
        zzg2.zzbfe.zza(zzng.zzab.zzln().zza(zzng.zzap.zzms().zzc(zzg2.zzbnr).zzm(zznq.zzamr)), zznu.zzaoy);
    }

    @WorkerThread
    private final synchronized List<FirebaseVisionObject> zza(zzrl zzrl2) throws FirebaseMLException {
        Preconditions.checkNotNull((Object)zzrl2, (Object)"Mobile vision input can not bu null");
        Preconditions.checkNotNull((Object)zzrl2.zzblk, (Object)"Input image can not be null");
        Preconditions.checkNotNull((Object)zzrl2.zzbkx, (Object)"Input frame can not be null");
        long l = SystemClock.elapsedRealtime();
        try {
            long l2;
            if (this.zzbns == null) {
                Log.e((String)"ObjectDetectorTask", (String)"Object detector is not initialized.");
                return zzmr.zzji();
            }
            if (this.zzbnp.zzqf() == 1 && this.zzbnq > 0L && l - (l2 = this.zzbnq) > 300L) {
                Log.w((String)"ObjectDetectorTask", (String)"Object detector pipeline is reset.");
                this.zzqj();
            }
            this.zzbnq = l;
            IObjectWrapper iObjectWrapper = ObjectWrapper.wrap((Object)zzrl2.zzbkx);
            Frame.Metadata metadata = zzrl2.zzbkx.getMetadata();
            zzh[] zzhArray = this.zzbns.zzc(iObjectWrapper, new zzrk(metadata.getWidth(), metadata.getHeight(), metadata.getId(), metadata.getTimestampMillis(), metadata.getRotation()));
            ArrayList<FirebaseVisionObject> arrayList = new ArrayList<FirebaseVisionObject>();
            zzh[] zzhArray2 = zzhArray;
            int n = zzhArray.length;
            for (int i = 0; i < n; ++i) {
                zzh zzh2 = zzhArray2[i];
                arrayList.add(new FirebaseVisionObject(zzh2));
            }
            this.zza(zznq.zzamr, zzrl2, arrayList, l);
            zzbhb.set(false);
            return arrayList;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"ObjectDetectorTask", (String)"Error calling object detector inference", (Throwable)remoteException);
            this.zza(zznq.zzanr, zzrl2, (List<FirebaseVisionObject>)zzmr.zzji(), l);
            throw new FirebaseMLException("Cannot run object detector.", 14);
        }
    }

    @NonNull
    public final zzpx zznl() {
        return this;
    }

    @WorkerThread
    public final synchronized void zznu() throws FirebaseMLException {
        try {
            if (this.zzbns == null) {
                zza zza2 = this.zzqi();
                if (zza2 == null) {
                    Log.e((String)"ObjectDetectorTask", (String)"Error when creating object detector creator");
                    this.zzp(zznq.zzanr);
                    throw new FirebaseMLException("Cannot load object detector module.", 14);
                }
                FirebaseVisionObjectDetectorOptions firebaseVisionObjectDetectorOptions = this.zzbnp;
                this.zzbns = zza2.newObjectDetector(ObjectWrapper.wrap((Object)this.zzbdc.getApplicationContext()), new ObjectDetectorOptionsParcel(firebaseVisionObjectDetectorOptions.zzqf(), firebaseVisionObjectDetectorOptions.zzqh(), firebaseVisionObjectDetectorOptions.zzqg()));
                this.zzp(zznq.zzamr);
            }
            this.zzbns.start();
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"ObjectDetectorTask", (String)"Error when creating object detector");
            this.zzp(zznq.zzanr);
            throw new FirebaseMLException("Can not create ObjectDetector", 14, (Throwable)remoteException);
        }
    }

    @VisibleForTesting
    @Nullable
    private final zza zzqi() throws FirebaseMLException {
        try {
            return zzd.asInterface(DynamiteModule.load((Context)this.zzbdc.getApplicationContext(), (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_LOCAL, (String)"com.google.firebase.ml.vision.dynamite.objects").instantiate("com.google.firebase.ml.vision.objects.ObjectDetectorCreator"));
        }
        catch (DynamiteModule.LoadingException loadingException) {
            Log.e((String)"ObjectDetectorTask", (String)"Error when loading object detector module");
            throw new FirebaseMLException("Cannot load object detector module.", 14, (Throwable)loadingException);
        }
    }

    @WorkerThread
    @VisibleForTesting
    private final synchronized void zzqj() {
        try {
            if (this.zzbns != null) {
                this.zzbns.stop();
            }
        }
        catch (RemoteException remoteException) {
            Log.e((String)"ObjectDetectorTask", (String)"Error calling object detector stop", (Throwable)remoteException);
        }
        try {
            if (this.zzbns != null) {
                this.zzbns.start();
            }
        }
        catch (RemoteException remoteException) {
            Log.e((String)"ObjectDetectorTask", (String)"Error calling object detector restart", (Throwable)remoteException);
        }
        zzbhb.set(true);
    }

    @WorkerThread
    public final synchronized void release() {
        try {
            if (this.zzbns != null) {
                this.zzbns.stop();
            }
            zzbhb.set(true);
            this.zzbfe.zza(zzng.zzab.zzln(), zznu.zzapb);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"ObjectDetectorTask", (String)"Error calling object detector stop", (Throwable)remoteException);
            return;
        }
    }

    private final void zzp(zznq zznq2) {
        this.zzbfe.zza(zzng.zzab.zzln().zza(zzng.zzas.zzmy().zze(this.zzbnr).zzn(zznq2)), zznu.zzaoz);
    }

    @WorkerThread
    private final void zza(zznq zznq2, zzrl zzrl2, List<FirebaseVisionObject> list, long l) {
        long l2 = SystemClock.elapsedRealtime() - l;
        zzf zzf2 = new zzf(this, list, l2, zznq2, zzrl2);
        this.zzbfe.zza((zzpw)zzf2, zznu.zzapa);
        zzng.zzf.zza zza2 = (zzng.zzf.zza)((zzvx)zzng.zzf.zza.zzkd().zzb(this.zzbnr).zzg(zznq2).zzu(zzbhb.get()).zzf(zzrf.zzb(zzrl2)).zzt(!list.isEmpty()).zztx());
        zzpu zzpu2 = zzi.zzbhp;
        this.zzbfe.zza((Object)zza2, l2, zznu.zzaqx, zzpu2);
    }

    final /* synthetic */ zzng.zzab.zza zza(List list, long l, zznq zznq2, zzrl zzrl2) {
        ArrayList<zzng.zzaj> arrayList = new ArrayList<zzng.zzaj>();
        for (FirebaseVisionObject firebaseVisionObject : list) {
            zzng.zzaj.zza zza2;
            zzng.zzaj.zzb zzb2 = zzng.zzaj.zzme();
            int n = firebaseVisionObject.getClassificationCategory();
            switch (n) {
                case 0: {
                    zza2 = zzng.zzaj.zza.zzawf;
                    break;
                }
                case 1: {
                    zza2 = zzng.zzaj.zza.zzawg;
                    break;
                }
                case 2: {
                    zza2 = zzng.zzaj.zza.zzawh;
                    break;
                }
                case 3: {
                    zza2 = zzng.zzaj.zza.zzawj;
                    break;
                }
                case 4: {
                    zza2 = zzng.zzaj.zza.zzawk;
                    break;
                }
                case 5: {
                    zza2 = zzng.zzaj.zza.zzawl;
                    break;
                }
                default: {
                    Log.e((String)"ObjectDetectorTask", (String)new StringBuilder(32).append("Unexpected category: ").append(n).toString());
                    zza2 = zzng.zzaj.zza.zzawf;
                }
            }
            zzng.zzaj.zzb zzb3 = zzb2.zzb(zza2);
            if (firebaseVisionObject.getClassificationConfidence() != null) {
                zzb3.zzn(firebaseVisionObject.getClassificationConfidence().floatValue());
            }
            if (firebaseVisionObject.getTrackingId() != null) {
                zzb3.zzbj(firebaseVisionObject.getTrackingId().intValue());
            }
            arrayList.add((zzng.zzaj)((zzvx)zzb3.zztx()));
        }
        return zzng.zzab.zzln().zza(zzng.zzar.zzmw().zzf(zzng.zzad.zzlr().zzj(l).zzk(zznq2).zzae(zzbhb.get()).zzaf(true).zzag(true)).zzl(zzrf.zzb(zzrl2)).zzd(this.zzbnr).zzv(arrayList));
    }
}

