/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.ml.vision.text;

import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.ml.vision.text.zza;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FirebaseVisionCloudTextRecognizerOptions {
    private final List<String> zzblm;
    private final int zzbnu;
    public static final int SPARSE_MODEL = 1;
    public static final int DENSE_MODEL = 2;
    private final boolean zzbkc;

    @NonNull
    public List<String> getHintedLanguages() {
        return this.zzblm;
    }

    public final boolean isEnforceCertFingerprintMatch() {
        return this.zzbkc;
    }

    @CloudTextModelType
    public int getModelType() {
        return this.zzbnu;
    }

    private FirebaseVisionCloudTextRecognizerOptions(@NonNull List<String> list, @CloudTextModelType int n, boolean bl) {
        Preconditions.checkNotNull(list, (Object)"Provided hinted languages can not be null");
        this.zzblm = list;
        this.zzbnu = n;
        this.zzbkc = bl;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FirebaseVisionCloudTextRecognizerOptions)) {
            return false;
        }
        FirebaseVisionCloudTextRecognizerOptions firebaseVisionCloudTextRecognizerOptions = (FirebaseVisionCloudTextRecognizerOptions)object;
        return this.zzblm.equals(firebaseVisionCloudTextRecognizerOptions.getHintedLanguages()) && this.zzbnu == firebaseVisionCloudTextRecognizerOptions.zzbnu && this.zzbkc == firebaseVisionCloudTextRecognizerOptions.zzbkc;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zzblm, this.zzbnu, this.zzbkc});
    }

    /* synthetic */ FirebaseVisionCloudTextRecognizerOptions(List list, int n, boolean bl, zza zza2) {
        this(list, n, bl);
    }

    public static class Builder {
        private List<String> zzblm = new ArrayList<String>();
        private int zzbnu = 1;
        private boolean zzbkc = false;

        @NonNull
        public Builder setLanguageHints(@NonNull List<String> list) {
            Preconditions.checkNotNull(list, (Object)"Provided hinted languages can not be null");
            this.zzblm = list;
            Collections.sort(this.zzblm);
            return this;
        }

        @NonNull
        public Builder setModelType(@CloudTextModelType int n) {
            Preconditions.checkArgument((n == 1 || n == 2 ? 1 : 0) != 0, (Object)"modelType should be either SPARSE_MODEL or DENSE_MODEL");
            this.zzbnu = n;
            return this;
        }

        @NonNull
        public Builder enforceCertFingerprintMatch() {
            this.zzbkc = true;
            return this;
        }

        @NonNull
        public FirebaseVisionCloudTextRecognizerOptions build() {
            return new FirebaseVisionCloudTextRecognizerOptions(this.zzblm, this.zzbnu, this.zzbkc, null);
        }
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface CloudTextModelType {
    }
}

