/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.ml.vision.text;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase_ml.zzpn;
import com.google.android.gms.internal.firebase_ml.zzrz;
import com.google.android.gms.internal.firebase_ml.zzsa;
import com.google.android.gms.tasks.Task;
import com.google.firebase.ml.vision.common.FirebaseVisionImage;
import com.google.firebase.ml.vision.text.FirebaseVisionCloudTextRecognizerOptions;
import com.google.firebase.ml.vision.text.FirebaseVisionText;
import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;

public class FirebaseVisionTextRecognizer
implements Closeable {
    private final zzrz zzbny;
    private final zzsa zzbnz;
    @RecognizerType
    private final int zzboa;
    public static final int ON_DEVICE = 1;
    public static final int CLOUD = 2;
    @GuardedBy(value="FirebaseVisionTextRecognizer.class")
    private static final Map<zzrz, FirebaseVisionTextRecognizer> zzbms = new HashMap<zzrz, FirebaseVisionTextRecognizer>();
    @GuardedBy(value="FirebaseVisionTextRecognizer.class")
    private static final Map<zzsa, FirebaseVisionTextRecognizer> zzbmt = new HashMap<zzsa, FirebaseVisionTextRecognizer>();

    public static synchronized FirebaseVisionTextRecognizer zza(@NonNull zzpn zzpn2, @Nullable FirebaseVisionCloudTextRecognizerOptions firebaseVisionCloudTextRecognizerOptions, boolean bl) {
        Preconditions.checkNotNull((Object)zzpn2, (Object)"MlKitContext must not be null");
        Preconditions.checkNotNull((Object)zzpn2.getPersistenceKey(), (Object)"Persistence key must not be null");
        if (!bl) {
            Preconditions.checkNotNull((Object)firebaseVisionCloudTextRecognizerOptions, (Object)"Options must not be null");
        }
        if (bl) {
            zzrz zzrz2 = zzrz.zzc(zzpn2);
            FirebaseVisionTextRecognizer firebaseVisionTextRecognizer = zzbms.get(zzrz2);
            if (firebaseVisionTextRecognizer == null) {
                firebaseVisionTextRecognizer = new FirebaseVisionTextRecognizer(zzrz2, null, 1);
                zzbms.put(zzrz2, firebaseVisionTextRecognizer);
            }
            return firebaseVisionTextRecognizer;
        }
        zzsa zzsa2 = zzsa.zza(zzpn2, firebaseVisionCloudTextRecognizerOptions);
        FirebaseVisionTextRecognizer firebaseVisionTextRecognizer = zzbmt.get(zzsa2);
        if (firebaseVisionTextRecognizer == null) {
            firebaseVisionTextRecognizer = new FirebaseVisionTextRecognizer(null, zzsa2, 2);
            zzbmt.put(zzsa2, firebaseVisionTextRecognizer);
        }
        return firebaseVisionTextRecognizer;
    }

    private FirebaseVisionTextRecognizer(@Nullable zzrz zzrz2, @Nullable zzsa zzsa2, @RecognizerType int n) {
        this.zzboa = n;
        this.zzbny = zzrz2;
        this.zzbnz = zzsa2;
    }

    @NonNull
    public Task<FirebaseVisionText> processImage(@NonNull FirebaseVisionImage firebaseVisionImage) {
        Preconditions.checkArgument((this.zzbny != null || this.zzbnz != null ? 1 : 0) != 0, (Object)"Either on-device or cloud text recognizer should be enabled.");
        if (this.zzbny != null) {
            return this.zzbny.processImage(firebaseVisionImage);
        }
        return this.zzbnz.processImage(firebaseVisionImage);
    }

    @RecognizerType
    public int getRecognizerType() {
        return this.zzboa;
    }

    @Override
    public void close() throws IOException {
        if (this.zzbny != null) {
            this.zzbny.close();
        }
        if (this.zzbnz != null) {
            this.zzbnz.close();
        }
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface RecognizerType {
    }
}

