/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.internal;

import androidx.annotation.NonNull;
import com.google.firebase.perf.internal.AppStateMonitor;
import com.google.firebase.perf.v1.ApplicationProcessState;
import java.lang.ref.WeakReference;

public abstract class AppStateUpdateHandler
implements AppStateMonitor.AppStateCallback {
    private AppStateMonitor mAppStateMonitor;
    private ApplicationProcessState mState = ApplicationProcessState.APPLICATION_PROCESS_STATE_UNKNOWN;
    private boolean mIsRegisteredForAppState = false;
    private WeakReference<AppStateMonitor.AppStateCallback> mWeakRef;

    protected AppStateUpdateHandler() {
        this(AppStateMonitor.getInstance());
    }

    protected AppStateUpdateHandler(@NonNull AppStateMonitor appStateMonitor) {
        this.mAppStateMonitor = appStateMonitor;
        this.mWeakRef = new WeakReference<AppStateUpdateHandler>(this);
    }

    protected void registerForAppState() {
        if (this.mIsRegisteredForAppState) {
            return;
        }
        this.mState = this.mAppStateMonitor.getAppState();
        this.mAppStateMonitor.registerForAppState(this.mWeakRef);
        this.mIsRegisteredForAppState = true;
    }

    protected void unregisterForAppState() {
        if (!this.mIsRegisteredForAppState) {
            return;
        }
        this.mAppStateMonitor.unregisterForAppState(this.mWeakRef);
        this.mIsRegisteredForAppState = false;
    }

    protected void incrementTsnsCount(int count) {
        this.mAppStateMonitor.incrementTsnsCount(count);
    }

    @Override
    public void onUpdateAppState(ApplicationProcessState newState) {
        if (this.mState == ApplicationProcessState.APPLICATION_PROCESS_STATE_UNKNOWN) {
            this.mState = newState;
        } else if (this.mState != newState && newState != ApplicationProcessState.APPLICATION_PROCESS_STATE_UNKNOWN) {
            this.mState = ApplicationProcessState.FOREGROUND_BACKGROUND;
        }
    }

    public ApplicationProcessState getAppState() {
        return this.mState;
    }
}

