/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.internal;

import com.google.firebase.perf.internal.PerfMetricValidator;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.v1.ApplicationInfo;

public class FirebasePerfApplicationInfoValidator
extends PerfMetricValidator {
    private static final AndroidLogger logger = AndroidLogger.getInstance();
    private final ApplicationInfo mApplicationInfo;

    FirebasePerfApplicationInfoValidator(ApplicationInfo applicationInfo) {
        this.mApplicationInfo = applicationInfo;
    }

    @Override
    public boolean isValidPerfMetric() {
        if (!this.isValidApplicationInfo()) {
            logger.warn("ApplicationInfo is invalid", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean isValidApplicationInfo() {
        if (this.mApplicationInfo == null) {
            logger.warn("ApplicationInfo is null", new Object[0]);
            return false;
        }
        if (!this.mApplicationInfo.hasGoogleAppId()) {
            logger.warn("GoogleAppId is null", new Object[0]);
            return false;
        }
        if (!this.mApplicationInfo.hasAppInstanceId()) {
            logger.warn("AppInstanceId is null", new Object[0]);
            return false;
        }
        if (!this.mApplicationInfo.hasApplicationProcessState()) {
            logger.warn("ApplicationProcessState is null", new Object[0]);
            return false;
        }
        if (this.mApplicationInfo.hasAndroidAppInfo()) {
            if (!this.mApplicationInfo.getAndroidAppInfo().hasPackageName()) {
                logger.warn("AndroidAppInfo.packageName is null", new Object[0]);
                return false;
            }
            if (!this.mApplicationInfo.getAndroidAppInfo().hasSdkVersion()) {
                logger.warn("AndroidAppInfo.sdkVersion is null", new Object[0]);
                return false;
            }
        }
        return true;
    }
}

