/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.metrics;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.provider.FirebasePerfProvider;
import com.google.firebase.perf.session.SessionManager;
import com.google.firebase.perf.transport.TransportManager;
import com.google.firebase.perf.util.Clock;
import com.google.firebase.perf.util.Constants;
import com.google.firebase.perf.util.Timer;
import com.google.firebase.perf.v1.ApplicationProcessState;
import com.google.firebase.perf.v1.TraceMetric;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class AppStartTrace
implements Application.ActivityLifecycleCallbacks {
    private static final long MAX_LATENCY_BEFORE_UI_INIT = TimeUnit.MINUTES.toMicros(1L);
    private static volatile AppStartTrace instance;
    private boolean isRegisteredForLifecycleCallbacks = false;
    private final TransportManager transportManager;
    private final Clock clock;
    private Context appContext;
    private WeakReference<Activity> launchActivity;
    private WeakReference<Activity> appStartActivity;
    private boolean isTooLateToInitUI = false;
    private Timer onCreateTime = null;
    private Timer onStartTime = null;
    private Timer onResumeTime = null;
    private boolean isStartedFromBackground = false;

    @Keep
    public static void setLauncherActivityOnCreateTime(String activity) {
    }

    @Keep
    public static void setLauncherActivityOnStartTime(String activity) {
    }

    @Keep
    public static void setLauncherActivityOnResumeTime(String activity) {
    }

    public static AppStartTrace getInstance() {
        return instance != null ? instance : AppStartTrace.getInstance(TransportManager.getInstance(), new Clock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static AppStartTrace getInstance(TransportManager transportManager, Clock clock) {
        if (instance != null) return instance;
        Class<AppStartTrace> clazz = AppStartTrace.class;
        synchronized (AppStartTrace.class) {
            if (instance != null) return instance;
            instance = new AppStartTrace(transportManager, clock);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    AppStartTrace(@NonNull TransportManager transportManager, @NonNull Clock clock) {
        this.transportManager = transportManager;
        this.clock = clock;
    }

    public synchronized void registerActivityLifecycleCallbacks(@NonNull Context context) {
        if (this.isRegisteredForLifecycleCallbacks) {
            return;
        }
        Context appContext = context.getApplicationContext();
        if (appContext instanceof Application) {
            ((Application)appContext).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.isRegisteredForLifecycleCallbacks = true;
            this.appContext = appContext;
        }
    }

    public synchronized void unregisterActivityLifecycleCallbacks() {
        if (!this.isRegisteredForLifecycleCallbacks) {
            return;
        }
        ((Application)this.appContext).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        this.isRegisteredForLifecycleCallbacks = false;
    }

    public synchronized void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        if (this.isStartedFromBackground || this.onCreateTime != null) {
            return;
        }
        this.launchActivity = new WeakReference<Activity>(activity);
        this.onCreateTime = this.clock.getTime();
        if (FirebasePerfProvider.getAppStartTime().getDurationMicros(this.onCreateTime) > MAX_LATENCY_BEFORE_UI_INIT) {
            this.isTooLateToInitUI = true;
        }
    }

    public synchronized void onActivityStarted(Activity activity) {
        if (this.isStartedFromBackground || this.onStartTime != null || this.isTooLateToInitUI) {
            return;
        }
        this.onStartTime = this.clock.getTime();
    }

    public synchronized void onActivityResumed(Activity activity) {
        if (this.isStartedFromBackground || this.onResumeTime != null || this.isTooLateToInitUI) {
            return;
        }
        this.appStartActivity = new WeakReference<Activity>(activity);
        this.onResumeTime = this.clock.getTime();
        Timer startTime = FirebasePerfProvider.getAppStartTime();
        AndroidLogger.getInstance().debug("onResume(): " + activity.getClass().getName() + ": " + startTime.getDurationMicros(this.onResumeTime) + " microseconds");
        TraceMetric.Builder metric = TraceMetric.newBuilder().setName(Constants.TraceNames.APP_START_TRACE_NAME.toString()).setClientStartTimeUs(startTime.getMicros()).setDurationUs(startTime.getDurationMicros(this.onResumeTime));
        ArrayList<TraceMetric> subtraces = new ArrayList<TraceMetric>(3);
        TraceMetric.Builder temp = TraceMetric.newBuilder().setName(Constants.TraceNames.ON_CREATE_TRACE_NAME.toString()).setClientStartTimeUs(startTime.getMicros()).setDurationUs(startTime.getDurationMicros(this.onCreateTime));
        subtraces.add((TraceMetric)temp.build());
        temp = TraceMetric.newBuilder();
        temp.setName(Constants.TraceNames.ON_START_TRACE_NAME.toString()).setClientStartTimeUs(this.onCreateTime.getMicros()).setDurationUs(this.onCreateTime.getDurationMicros(this.onStartTime));
        subtraces.add((TraceMetric)temp.build());
        temp = TraceMetric.newBuilder();
        temp.setName(Constants.TraceNames.ON_RESUME_TRACE_NAME.toString()).setClientStartTimeUs(this.onStartTime.getMicros()).setDurationUs(this.onStartTime.getDurationMicros(this.onResumeTime));
        subtraces.add((TraceMetric)temp.build());
        metric.addAllSubtraces(subtraces).addPerfSessions(SessionManager.getInstance().perfSession().build());
        this.transportManager.log((TraceMetric)metric.build(), ApplicationProcessState.FOREGROUND_BACKGROUND);
        if (this.isRegisteredForLifecycleCallbacks) {
            this.unregisterActivityLifecycleCallbacks();
        }
    }

    public void onActivityPaused(Activity activity) {
    }

    public synchronized void onActivityStopped(Activity activity) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    @VisibleForTesting
    @Nullable
    Activity getLaunchActivity() {
        return (Activity)this.launchActivity.get();
    }

    @VisibleForTesting
    @Nullable
    Activity getAppStartActivity() {
        return (Activity)this.appStartActivity.get();
    }

    @VisibleForTesting
    Timer getOnCreateTime() {
        return this.onCreateTime;
    }

    @VisibleForTesting
    Timer getOnStartTime() {
        return this.onStartTime;
    }

    @VisibleForTesting
    Timer getOnResumeTime() {
        return this.onResumeTime;
    }

    @VisibleForTesting
    void setIsStartFromBackground() {
        this.isStartedFromBackground = true;
    }

    public static class StartFromBackgroundRunnable
    implements Runnable {
        private final AppStartTrace trace;

        public StartFromBackgroundRunnable(AppStartTrace trace) {
            this.trace = trace;
        }

        @Override
        public void run() {
            if (this.trace.onCreateTime == null) {
                this.trace.isStartedFromBackground = true;
            }
        }
    }
}

