/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.datatransport.TransportFactory;
import com.google.firebase.FirebaseApp;
import com.google.firebase.inject.Provider;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.perf.FirebasePerformanceAttributable;
import com.google.firebase.perf.config.ConfigResolver;
import com.google.firebase.perf.config.RemoteConfigManager;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.logging.ConsoleUrlGenerator;
import com.google.firebase.perf.metrics.HttpMetric;
import com.google.firebase.perf.metrics.Trace;
import com.google.firebase.perf.metrics.validator.PerfMetricValidator;
import com.google.firebase.perf.session.SessionManager;
import com.google.firebase.perf.transport.TransportManager;
import com.google.firebase.perf.util.ImmutableBundle;
import com.google.firebase.perf.util.Timer;
import com.google.firebase.remoteconfig.RemoteConfigComponent;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.URL;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class FirebasePerformance
implements FirebasePerformanceAttributable {
    private static final AndroidLogger logger = AndroidLogger.getInstance();
    private static final int MAX_TRACE_CUSTOM_ATTRIBUTES = 5;
    private static final int MAX_ATTRIBUTE_KEY_LENGTH = 40;
    private static final int MAX_ATTRIBUTE_VALUE_LENGTH = 100;
    public static final int MAX_TRACE_NAME_LENGTH = 100;
    private final Map<String, String> mCustomAttributes = new ConcurrentHashMap<String, String>();
    private final ConfigResolver configResolver;
    private final ImmutableBundle mMetadataBundle;
    @Nullable
    private Boolean mPerformanceCollectionForceEnabledState = null;
    private final FirebaseApp firebaseApp;
    private final Provider<RemoteConfigComponent> firebaseRemoteConfigProvider;
    private final FirebaseInstallationsApi firebaseInstallationsApi;
    private final Provider<TransportFactory> transportFactoryProvider;

    @NonNull
    public static FirebasePerformance getInstance() {
        return (FirebasePerformance)FirebaseApp.getInstance().get(FirebasePerformance.class);
    }

    @Inject
    @VisibleForTesting
    FirebasePerformance(FirebaseApp firebaseApp, Provider<RemoteConfigComponent> firebaseRemoteConfigProvider, FirebaseInstallationsApi firebaseInstallationsApi, Provider<TransportFactory> transportFactoryProvider, RemoteConfigManager remoteConfigManager, ConfigResolver configResolver, SessionManager sessionManager) {
        this.firebaseApp = firebaseApp;
        this.firebaseRemoteConfigProvider = firebaseRemoteConfigProvider;
        this.firebaseInstallationsApi = firebaseInstallationsApi;
        this.transportFactoryProvider = transportFactoryProvider;
        if (firebaseApp == null) {
            this.mPerformanceCollectionForceEnabledState = false;
            this.configResolver = configResolver;
            this.mMetadataBundle = new ImmutableBundle(new Bundle());
            return;
        }
        TransportManager.getInstance().initialize(firebaseApp, firebaseInstallationsApi, transportFactoryProvider);
        Context appContext = firebaseApp.getApplicationContext();
        this.mMetadataBundle = FirebasePerformance.extractMetadata(appContext);
        remoteConfigManager.setFirebaseRemoteConfigProvider(firebaseRemoteConfigProvider);
        this.configResolver = configResolver;
        this.configResolver.setMetadataBundle(this.mMetadataBundle);
        this.configResolver.setApplicationContext(appContext);
        sessionManager.setApplicationContext(appContext);
        this.mPerformanceCollectionForceEnabledState = configResolver.getIsPerformanceCollectionEnabled();
        if (logger.isLogcatEnabled() && this.isPerformanceCollectionEnabled()) {
            logger.info(String.format("Firebase Performance Monitoring is successfully initialized! In a minute, visit the Firebase console to view your data: %s", ConsoleUrlGenerator.generateDashboardUrl(firebaseApp.getOptions().getProjectId(), appContext.getPackageName())));
        }
    }

    @NonNull
    public static Trace startTrace(@NonNull String traceName) {
        Trace trace = Trace.create(traceName);
        trace.start();
        return trace;
    }

    public void setPerformanceCollectionEnabled(boolean enable) {
        this.setPerformanceCollectionEnabled((Boolean)enable);
    }

    public synchronized void setPerformanceCollectionEnabled(@Nullable Boolean enable) {
        try {
            FirebaseApp.getInstance();
        }
        catch (IllegalStateException e) {
            return;
        }
        if (this.configResolver.getIsPerformanceCollectionDeactivated().booleanValue()) {
            logger.info("Firebase Performance is permanently disabled");
            return;
        }
        this.configResolver.setIsPerformanceCollectionEnabled(enable);
        this.mPerformanceCollectionForceEnabledState = enable != null ? enable : this.configResolver.getIsPerformanceCollectionEnabled();
        if (Boolean.TRUE.equals(this.mPerformanceCollectionForceEnabledState)) {
            logger.info("Firebase Performance is Enabled");
        } else if (Boolean.FALSE.equals(this.mPerformanceCollectionForceEnabledState)) {
            logger.info("Firebase Performance is Disabled");
        }
    }

    public boolean isPerformanceCollectionEnabled() {
        return this.mPerformanceCollectionForceEnabledState != null ? this.mPerformanceCollectionForceEnabledState.booleanValue() : FirebaseApp.getInstance().isDataCollectionDefaultEnabled();
    }

    @Override
    public void putAttribute(@NonNull String attribute, @NonNull String value) {
        boolean noError = true;
        try {
            attribute = attribute.trim();
            value = value.trim();
            this.checkAttribute(attribute, value);
        }
        catch (Exception e) {
            logger.error("Can not set attribute %s with value %s (%s)", attribute, value, e.getMessage());
            noError = false;
        }
        if (noError) {
            this.mCustomAttributes.put(attribute, value);
        }
    }

    private void checkAttribute(@Nullable String key, @Nullable String value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("Attribute must not have null key or value.");
        }
        if (!this.mCustomAttributes.containsKey(key) && this.mCustomAttributes.size() >= 5) {
            throw new IllegalArgumentException(String.format(Locale.US, "Exceeds max limit of number of attributes - %d", 5));
        }
        String err = PerfMetricValidator.validateAttribute(new AbstractMap.SimpleEntry<String, String>(key, value));
        if (err != null) {
            throw new IllegalArgumentException(err);
        }
    }

    @Override
    public void removeAttribute(@NonNull String attribute) {
        this.mCustomAttributes.remove(attribute);
    }

    @Override
    @Nullable
    public String getAttribute(@NonNull String attribute) {
        return this.mCustomAttributes.get(attribute);
    }

    @Override
    @NonNull
    public Map<String, String> getAttributes() {
        return new HashMap<String, String>(this.mCustomAttributes);
    }

    @NonNull
    public Trace newTrace(@NonNull String traceName) {
        return Trace.create(traceName);
    }

    @NonNull
    public HttpMetric newHttpMetric(@NonNull String url, @NonNull String httpMethod) {
        return new HttpMetric(url, httpMethod, TransportManager.getInstance(), new Timer());
    }

    @NonNull
    public HttpMetric newHttpMetric(@NonNull URL url, @NonNull String httpMethod) {
        return new HttpMetric(url, httpMethod, TransportManager.getInstance(), new Timer());
    }

    private static ImmutableBundle extractMetadata(Context appContext) {
        Bundle bundle = null;
        try {
            ApplicationInfo ai = appContext.getPackageManager().getApplicationInfo(appContext.getPackageName(), 128);
            bundle = ai.metaData;
        }
        catch (PackageManager.NameNotFoundException | NullPointerException e) {
            Log.d((String)"isEnabled", (String)("No perf enable meta data found " + e.getMessage()));
        }
        return bundle != null ? new ImmutableBundle(bundle) : new ImmutableBundle();
    }

    @VisibleForTesting
    Boolean getPerformanceCollectionForceEnabledState() {
        return this.mPerformanceCollectionForceEnabledState;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HttpMethod {
        public static final String GET = "GET";
        public static final String PUT = "PUT";
        public static final String POST = "POST";
        public static final String DELETE = "DELETE";
        public static final String HEAD = "HEAD";
        public static final String PATCH = "PATCH";
        public static final String OPTIONS = "OPTIONS";
        public static final String TRACE = "TRACE";
        public static final String CONNECT = "CONNECT";
    }
}

