/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.application;

import androidx.annotation.NonNull;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.perf.application.AppStateMonitor;
import com.google.firebase.perf.v1.ApplicationProcessState;
import java.lang.ref.WeakReference;

public abstract class AppStateUpdateHandler
implements AppStateMonitor.AppStateCallback {
    private final AppStateMonitor appStateMonitor;
    private final WeakReference<AppStateMonitor.AppStateCallback> appStateCallback;
    private boolean isRegisteredForAppState = false;
    private ApplicationProcessState currentAppState = ApplicationProcessState.APPLICATION_PROCESS_STATE_UNKNOWN;

    protected AppStateUpdateHandler() {
        this(AppStateMonitor.getInstance());
    }

    protected AppStateUpdateHandler(@NonNull AppStateMonitor appStateMonitor) {
        this.appStateMonitor = appStateMonitor;
        this.appStateCallback = new WeakReference<AppStateUpdateHandler>(this);
    }

    protected void registerForAppState() {
        if (this.isRegisteredForAppState) {
            return;
        }
        this.currentAppState = this.appStateMonitor.getAppState();
        this.appStateMonitor.registerForAppState(this.appStateCallback);
        this.isRegisteredForAppState = true;
    }

    protected void unregisterForAppState() {
        if (!this.isRegisteredForAppState) {
            return;
        }
        this.appStateMonitor.unregisterForAppState(this.appStateCallback);
        this.isRegisteredForAppState = false;
    }

    protected void incrementTsnsCount(int count) {
        this.appStateMonitor.incrementTsnsCount(count);
    }

    @Override
    public void onUpdateAppState(ApplicationProcessState newState) {
        if (this.currentAppState == ApplicationProcessState.APPLICATION_PROCESS_STATE_UNKNOWN) {
            this.currentAppState = newState;
        } else if (this.currentAppState != newState && newState != ApplicationProcessState.APPLICATION_PROCESS_STATE_UNKNOWN) {
            this.currentAppState = ApplicationProcessState.FOREGROUND_BACKGROUND;
        }
    }

    public ApplicationProcessState getAppState() {
        return this.currentAppState;
    }

    @VisibleForTesting
    public WeakReference<AppStateMonitor.AppStateCallback> getAppStateCallback() {
        return this.appStateCallback;
    }
}

