/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.util;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.annotation.RequiresApi;
import java.util.concurrent.atomic.AtomicReference;

@RequiresApi(value=16)
public class FirstDrawDoneListener
implements ViewTreeObserver.OnDrawListener {
    private final Handler mainThreadHandler = new Handler(Looper.getMainLooper());
    private final AtomicReference<View> viewReference;
    private final Runnable callback;

    public static void registerForNextDraw(View view, Runnable drawDoneCallback) {
        final FirstDrawDoneListener listener = new FirstDrawDoneListener(view, drawDoneCallback);
        if (Build.VERSION.SDK_INT < 26 && !FirstDrawDoneListener.isAliveAndAttached(view)) {
            view.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                public void onViewAttachedToWindow(View view) {
                    view.getViewTreeObserver().addOnDrawListener((ViewTreeObserver.OnDrawListener)listener);
                    view.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                }

                public void onViewDetachedFromWindow(View view) {
                    view.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                }
            });
        } else {
            view.getViewTreeObserver().addOnDrawListener((ViewTreeObserver.OnDrawListener)listener);
        }
    }

    private FirstDrawDoneListener(View view, Runnable callback) {
        this.viewReference = new AtomicReference<View>(view);
        this.callback = callback;
    }

    public void onDraw() {
        View view = this.viewReference.getAndSet(null);
        if (view == null) {
            return;
        }
        view.getViewTreeObserver().addOnGlobalLayoutListener(() -> view.getViewTreeObserver().removeOnDrawListener((ViewTreeObserver.OnDrawListener)this));
        this.mainThreadHandler.postAtFrontOfQueue(this.callback);
    }

    private static boolean isAliveAndAttached(View view) {
        return view.getViewTreeObserver().isAlive() && FirstDrawDoneListener.isAttachedToWindow(view);
    }

    private static boolean isAttachedToWindow(View view) {
        if (Build.VERSION.SDK_INT >= 19) {
            return view.isAttachedToWindow();
        }
        return view.getWindowToken() != null;
    }
}

