/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.util;

import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.concurrent.TimeUnit;

public class Timer
implements Parcelable {
    private long wallClockMicros;
    private long elapsedRealtimeMicros;
    private long uptimeMicros;
    public static final Parcelable.Creator<Timer> CREATOR = new Parcelable.Creator<Timer>(){

        public Timer createFromParcel(Parcel in) {
            return new Timer(in);
        }

        public Timer[] newArray(int size) {
            return new Timer[size];
        }
    };

    public static Timer ofElapsedRealtime(long elapsedRealtimeMillis, long uptimeMillis) {
        long uptimeMicros = TimeUnit.MILLISECONDS.toMicros(uptimeMillis);
        long elapsedRealtimeMicros = TimeUnit.MILLISECONDS.toMicros(elapsedRealtimeMillis);
        long wallClockMicros = Timer.wallClockMicros() + (elapsedRealtimeMicros - Timer.elapsedRealtimeMicros());
        return new Timer(wallClockMicros, elapsedRealtimeMicros, uptimeMicros);
    }

    private static long wallClockMicros() {
        return TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis());
    }

    private static long elapsedRealtimeMicros() {
        if (Build.VERSION.SDK_INT >= 17) {
            return TimeUnit.NANOSECONDS.toMicros(SystemClock.elapsedRealtimeNanos());
        }
        return TimeUnit.MILLISECONDS.toMicros(SystemClock.elapsedRealtime());
    }

    private static long uptimeMicros() {
        return TimeUnit.MILLISECONDS.toMicros(SystemClock.uptimeMillis());
    }

    public Timer() {
        this(Timer.wallClockMicros(), Timer.elapsedRealtimeMicros(), Timer.uptimeMicros());
    }

    @VisibleForTesting
    Timer(long epochMicros, long elapsedRealtimeMicros, long uptimeMicros) {
        this.wallClockMicros = epochMicros;
        this.elapsedRealtimeMicros = elapsedRealtimeMicros;
        this.uptimeMicros = uptimeMicros;
    }

    @VisibleForTesting
    public Timer(long testTime) {
        this(testTime, testTime, testTime);
    }

    private Timer(Parcel in) {
        this(in.readLong(), in.readLong(), in.readLong());
    }

    public void reset() {
        this.wallClockMicros = Timer.wallClockMicros();
        this.elapsedRealtimeMicros = Timer.elapsedRealtimeMicros();
        this.uptimeMicros = Timer.uptimeMicros();
    }

    public long getMicros() {
        return this.wallClockMicros;
    }

    public long getDurationMicros() {
        return this.getDurationMicros(new Timer());
    }

    public long getDurationMicros(@NonNull Timer end) {
        return end.elapsedRealtimeMicros - this.elapsedRealtimeMicros;
    }

    public long getDurationUptimeMicros(@NonNull Timer end) {
        return end.uptimeMicros - this.uptimeMicros;
    }

    public long getCurrentTimestampMicros() {
        return this.wallClockMicros + this.getDurationMicros();
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeLong(this.wallClockMicros);
        out.writeLong(this.elapsedRealtimeMicros);
        out.writeLong(this.uptimeMicros);
    }

    public int describeContents() {
        return 0;
    }
}

