/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.metrics;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import java.util.concurrent.atomic.AtomicLong;

public class Counter
implements Parcelable {
    private final String name;
    private final AtomicLong count;
    public static final Parcelable.Creator<Counter> CREATOR = new Parcelable.Creator<Counter>(){

        public Counter createFromParcel(Parcel in) {
            return new Counter(in);
        }

        public Counter[] newArray(int size) {
            return new Counter[size];
        }
    };

    public Counter(@NonNull String name) {
        this.name = name;
        this.count = new AtomicLong(0L);
    }

    private Counter(Parcel in) {
        this.name = in.readString();
        this.count = new AtomicLong(in.readLong());
    }

    public void increment(long counts) {
        this.count.addAndGet(counts);
    }

    @NonNull
    String getName() {
        return this.name;
    }

    long getCount() {
        return this.count.get();
    }

    void setCount(long newCount) {
        this.count.set(newCount);
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.name);
        out.writeLong(this.count.get());
    }

    public int describeContents() {
        return 0;
    }
}

